/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy;

import java.math.BigDecimal;
import kd.bos.algo.Row;

public class QtyStore {
    private BigDecimal baseQty = BigDecimal.ZERO;
    private BigDecimal qty = BigDecimal.ZERO;
    private BigDecimal qty2end = BigDecimal.ZERO;
    private BigDecimal lockBaseQty = BigDecimal.ZERO;
    private BigDecimal lockQty = BigDecimal.ZERO;
    private BigDecimal lockQty2end = BigDecimal.ZERO;

    public QtyStore() {
    }

    public QtyStore(BigDecimal baseQty, BigDecimal qty, BigDecimal qty2end) {
        this.qty2end = qty2end.abs();
        this.qty = qty.abs();
        this.baseQty = baseQty.abs();
    }

    public QtyStore(QtyStore store) {
        if (store != null) {
            this.baseQty = store.getBaseQty();
            this.qty = store.getQty();
            this.qty2end = store.getQty2end();
        }
    }

    public QtyStore(Row row) {
        if (row != null) {
            this.baseQty = row.getBigDecimal("avbbaseqty");
            if (this.baseQty == null) {
                this.baseQty = BigDecimal.ZERO;
            }
            this.qty = row.getBigDecimal("avbqty");
            if (this.qty == null) {
                this.qty = BigDecimal.ZERO;
            }
            this.qty2end = row.getBigDecimal("avbqty2nd");
            if (this.qty2end == null) {
                this.qty2end = BigDecimal.ZERO;
            }
        }
    }

    public QtyStore(Row row, String type) {
        this.baseQty = row.getBigDecimal("baseqty");
        if (this.baseQty == null) {
            this.baseQty = BigDecimal.ZERO;
        }
        if (row.getBigDecimal("lockbaseqty") != null) {
            this.baseQty = this.baseQty.subtract(row.getBigDecimal("lockbaseqty"));
        }
        this.qty = row.getBigDecimal("qty");
        if (this.qty == null) {
            this.qty = BigDecimal.ZERO;
        }
        if (row.getBigDecimal("lockqty") != null) {
            this.qty = this.qty.subtract(row.getBigDecimal("lockqty"));
        }
        this.qty2end = row.getBigDecimal("qty2nd");
        if (this.qty2end == null) {
            this.qty2end = BigDecimal.ZERO;
        }
        if (row.getBigDecimal("lockqty2nd") != null) {
            this.qty2end = this.qty2end.subtract(row.getBigDecimal("lockqty2nd"));
        }
    }

    public boolean isReservable() {
        return this.baseQty != null && this.baseQty.compareTo(BigDecimal.ZERO) > 0;
    }

    public BigDecimal getBaseQty() {
        return this.baseQty;
    }

    public void setBaseQty(BigDecimal baseQty) {
        this.baseQty = baseQty.abs();
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty.abs();
    }

    public BigDecimal getQty2end() {
        return this.qty2end;
    }

    public void setQty2end(BigDecimal qty2end) {
        this.qty2end = qty2end.abs();
    }

    public BigDecimal getLockBaseQty() {
        return this.lockBaseQty;
    }

    public void addLockBaseQty(BigDecimal lockBaseQty) {
        if (lockBaseQty != null) {
            this.lockBaseQty = this.lockBaseQty.add(lockBaseQty);
        }
    }

    public BigDecimal getLockQty() {
        return this.lockQty;
    }

    public void addLockQty(BigDecimal lockQty) {
        if (lockQty != null) {
            this.lockQty = this.lockQty.add(lockQty);
        }
    }

    public BigDecimal getLockQty2end() {
        return this.lockQty2end;
    }

    public void addLockQty2end(BigDecimal lockQty2end) {
        if (lockQty2end != null) {
            this.lockQty2end = this.lockQty2end.add(lockQty2end);
        }
    }
}

