/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.engine.parser;

import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.user.UserService;

public class FilterParser {
    private static final Log logger = LogFactory.getLog(FilterParser.class);

    public static QFilter parseFilter(String jsonCondition, String entityName) {
        if (jsonCondition == null || jsonCondition.trim().isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), condition);
        fb.setUserService((IUserService)new UserService());
        fb.buildFilter();
        QFilter filter = fb.getQFilter();
        if (filter == null) {
            filter = new QFilter("1", "=", (Object)1);
        }
        return filter;
    }

    public static boolean execExcelFormula(String filterstr, DynamicObject data) {
        MainEntityType entityType = (MainEntityType)data.getDataEntityType();
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(entityType, condition);
        String[] script = fb.buildFilterScript();
        logger.info("script:" + script);
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null || property instanceof EntryProp) continue;
            if (property instanceof MuliLangTextProp) {
                ctx.put(var, data.getLocaleString(var).getLocaleValue());
                continue;
            }
            ctx.put(var, FilterParser.getProValue(var, data));
        }
        logger.info("\u5339\u914d\u5668\u5355\u636emap\u503c" + ctx);
        logger.info("expr:" + expr.getExpr());
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        logger.info("\u5339\u914d\u7ed3\u679c" + exec);
        return exec;
    }

    public static boolean execExcelFormulaByEntry(String filterstr, DynamicObject entry) {
        EntryType entityType = (EntryType)entry.getDataEntityType();
        MainEntityType parent = (MainEntityType)entityType.getParent();
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(parent, condition);
        String[] script = fb.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null && sp.length > 1) {
                property = entityType.findProperty(sp[1]);
            }
            if (property == null) continue;
            if (property instanceof MuliLangTextProp) {
                ctx.put(var, entry.getLocaleString(var).getLocaleValue());
                continue;
            }
            ctx.put(var, FilterParser.getProValue(var, entry));
        }
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        return exec;
    }

    public static boolean execExcelFormulaHasNoEntry(String filterstr, DynamicObject entry) {
        if (entry.getDataEntityType() instanceof EntryType) {
            return FilterParser.execExcelFormulaByEntry(filterstr, entry);
        }
        return FilterParser.execExcelFormula(filterstr, entry);
    }

    public static Object getProValue(String var, DynamicObject data) {
        String formId = data.getDataEntityType().getName();
        String[] sp = var.split("\\.");
        Object value = null;
        for (int i = 0; i < sp.length; ++i) {
            if (i == 0) {
                if (formId.equals(sp[i])) {
                    ++i;
                }
                value = data.get(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }
}

