/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.engine.parser;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.LogicParser;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.RuleRowParser;

public class RuleParser {
    private static final Log logger = LogFactory.getLog(RuleParser.class);

    public static QFilter toQFilter(DynamicObject rule, DynamicObject requestBill, DynamicObject requestEntry) {
        DynamicObjectCollection rows = rule.getDynamicObjectCollection("rule_entry");
        if (rows.isEmpty()) {
            return RuleParser.getDefaultFilter(requestEntry);
        }
        QFilter filter = RuleRowParser.toQFilter((DynamicObject)rows.get(0), requestBill, requestEntry);
        for (int i = 1; i < rows.size(); ++i) {
            QFilter tmpFilter = RuleRowParser.toQFilter((DynamicObject)rows.get(i), requestBill, requestEntry);
            filter = LogicParser.mergeWithQFilter(filter, tmpFilter, ((DynamicObject)rows.get(i - 1)).getString("logic"));
        }
        filter.and(RuleParser.getDefaultFilter(requestEntry));
        return filter;
    }

    public static QFilter toQFilter(DynamicObject rule, Map<String, String> stdInv2Inv, DynamicObject requestBill, DynamicObject requestEntry) {
        if (rule == null) {
            return RuleParser.getDefaultFilter(requestEntry, stdInv2Inv);
        }
        DynamicObjectCollection rows = rule.getDynamicObjectCollection("rule_entry");
        if (rows.isEmpty()) {
            return RuleParser.getDefaultFilter(requestEntry, stdInv2Inv);
        }
        QFilter filter = RuleRowParser.toQFilter((DynamicObject)rows.get(0), stdInv2Inv, requestBill, requestEntry);
        for (int i = 1; i < rows.size(); ++i) {
            QFilter tmpFilter = RuleRowParser.toQFilter((DynamicObject)rows.get(i), stdInv2Inv, requestBill, requestEntry);
            filter = LogicParser.mergeWithQFilter(filter, tmpFilter, ((DynamicObject)rows.get(i - 1)).getString("logic"));
        }
        filter.and(RuleParser.getDefaultFilter(requestEntry, stdInv2Inv));
        logger.info("QFilter: " + filter);
        return filter;
    }

    private static QFilter getDefaultFilter(DynamicObject requestEntry) {
        DynamicObject materielValue = requestEntry.getDynamicObject("material");
        DynamicObject unit = requestEntry.getDynamicObject("unit");
        DynamicObject baseUnit = requestEntry.getDynamicObject("base_unit");
        QFilter materielFilter = new QFilter("materiel", "=", materielValue.getPkValue());
        QFilter unitFilter = new QFilter("unit", "=", unit.getPkValue());
        QFilter baseUnitFilter = new QFilter("baseunit", "=", baseUnit.getPkValue());
        return materielFilter.and(unitFilter).and(baseUnitFilter);
    }

    private static QFilter getDefaultFilter(DynamicObject requestEntry, Map<String, String> stdInv2Inv) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        try {
            DynamicObject materielValue = requestEntry.getDynamicObject("material");
            if (materielValue != null && materielValue.getDynamicObjectType().getName().equals("bd_material")) {
                filter = new QFilter(stdInv2Inv.get("materiel"), "=", materielValue.getPkValue());
            }
        }
        catch (Exception e) {
            logger.info(StringUtils.join((Object[])new String[]{"\u5f53\u524d\u7684\u5206\u5f55\u6ca1\u6709\u7269\u6599\u8fd9\u4e2a\u5c5e\u6027:", requestEntry.getDynamicObjectType().getName(), e.getMessage()}));
        }
        try {
            DynamicObject baseUnit = requestEntry.getDynamicObject("base_unit");
            if (baseUnit != null) {
                filter = filter.and(new QFilter(stdInv2Inv.get("baseunit"), "=", baseUnit.getPkValue()));
            }
        }
        catch (Exception e) {
            logger.info(StringUtils.join((Object[])new String[]{"\u5f53\u524d\u7684\u5206\u5f55\u6ca1\u6709\u57fa\u7840\u5355\u4f4d\u8fd9\u4e2a\u5c5e\u6027:", requestEntry.getDynamicObjectType().getName(), e.getMessage()}));
        }
        return filter;
    }
}

