/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.engine.parser;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.CompareTypeParser;
import org.apache.commons.lang3.StringUtils;

public class RuleRowParser {
    private static final Log logger = LogFactory.getLog(RuleRowParser.class);

    public static QFilter toQFilter(DynamicObject ruleRow, DynamicObject requestBill, DynamicObject requestEntry) {
        Object value;
        String property = ruleRow.getString("std_inv_col_no");
        String compareType = ruleRow.getString("compare_type");
        if (CompareTypeParser.isValueType(compareType)) {
            value = RuleRowParser.parseToLong(ruleRow.get("require_bill_col_no"));
            if (value == null || value.equals("")) {
                value = RuleRowParser.parseToLong(ruleRow.get("require_bill_col"));
            }
        } else {
            String valueKey = ruleRow.getString("require_bill_col_no");
            value = ReserveHelper.getProValue(valueKey, requestBill, requestEntry);
        }
        if (value == null || property == null || compareType == null) {
            return new QFilter("1", "=", (Object)1);
        }
        return new QFilter(property, CompareTypeParser.toQFilterType(compareType), value);
    }

    public static QFilter toQFilter(DynamicObject ruleRow, Map<String, String> stdInv2Inv, DynamicObject requestBill, DynamicObject requestEntry) {
        Object value;
        String property = ruleRow.getString("std_inv_col_no");
        String compareType = ruleRow.getString("compare_type");
        String propertyKey = RuleRowParser.getDBField(stdInv2Inv, property);
        if (property == null || property.isEmpty() || compareType == null || propertyKey == null || propertyKey.trim().isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        if (CompareTypeParser.isValueType(compareType)) {
            value = RuleRowParser.parseToLong(ruleRow.get("require_bill_col_no"));
            if (value == null || value.equals("")) {
                value = RuleRowParser.parseToLong(ruleRow.get("require_bill_col"));
            }
        } else {
            if (compareType.equals("E")) {
                return new QFilter(propertyKey, CompareTypeParser.toQFilterType(compareType), null);
            }
            if (compareType.equals("F")) {
                return new QFilter(propertyKey, CompareTypeParser.toQFilterType(compareType), null);
            }
            if (compareType.equals("G")) {
                String valueKey = ruleRow.getString("require_bill_col_no");
                Object value2 = ReserveHelper.getProValue(valueKey, requestBill, requestEntry);
                if (value2 == null || value2.toString().trim().isEmpty() || value2 instanceof DynamicObjectCollection && ((DynamicObjectCollection)value2).isEmpty()) {
                    QFilter filter = new QFilter(propertyKey, "is null", null).or(new QFilter(propertyKey, "=", (Object)" "));
                    return filter;
                }
                return new QFilter(propertyKey, CompareTypeParser.toQFilterType(compareType), value2);
            }
            String valueKey = ruleRow.getString("require_bill_col_no");
            value = ReserveHelper.getProValue(valueKey, requestBill, requestEntry);
        }
        if (value == null || value.toString().trim().isEmpty() || value instanceof DynamicObjectCollection && ((DynamicObjectCollection)value).isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        if ("in".equals(CompareTypeParser.toQFilterType(compareType))) {
            Object[] values = RuleRowParser.parseToLong(value.toString().split(","));
            return new QFilter(propertyKey, CompareTypeParser.toQFilterType(compareType), (Object)values);
        }
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection valueCol = (DynamicObjectCollection)value;
            int size = valueCol.size();
            Object[] valueList = new Object[size];
            for (int i = 0; i < size; ++i) {
                valueList[i] = ((DynamicObject)valueCol.get(i)).get("fbasedataid_id");
            }
            return new QFilter(propertyKey, "in", (Object)valueList);
        }
        return new QFilter(propertyKey, CompareTypeParser.toQFilterType(compareType), value);
    }

    private static Object parseToLong(Object value) {
        StringBuilder errSb = new StringBuilder();
        try {
            return Long.valueOf(value.toString());
        }
        catch (Exception e) {
            errSb.append(e.getMessage());
            return value;
        }
    }

    private static Object[] parseToLong(String[] split) {
        StringBuilder errSb = new StringBuilder();
        Object[] values = new Object[split.length];
        try {
            for (int i = 0; i < split.length; ++i) {
                values[i] = Long.valueOf(split[i]);
            }
        }
        catch (Exception e) {
            errSb.append(e.getMessage());
            return split;
        }
        return values;
    }

    private static String getDBField(Map<String, String> stdInv2Inv, String stdInvField) {
        String value;
        if (!stdInvField.contains(".")) {
            value = stdInv2Inv.get(stdInvField);
        } else {
            String firstKey;
            Object[] keys = StringUtils.split((String)stdInvField, (String)".");
            String key = keys[0];
            keys[0] = firstKey = stdInv2Inv.get(key);
            value = StringUtils.join((Object[])keys, (String)".");
        }
        if (value == null || value.isEmpty()) {
            logger.warn("\u6ca1\u627e\u5230\u6620\u5c04\u5b57\u6bb5, \u6807\u51c6\u5e93\u5b58\u5b57\u6bb5\uff1a " + stdInvField);
        }
        return value;
    }
}

