/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BillReserveOpSearchPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(BillReserveOpSearchPlugin.class);
    private static final String BILLOPERATION = "billoperation";
    private static final String BILLOBJECT = "billobject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bt_search"});
        EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid3 = (EntryGrid)this.getView().getControl("entryentity1");
        entryGrid3.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"recordflex", "opecordflex"});
    }

    public void click(EventObject evt) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"recordflex", "opecordflex"});
        String billName = null;
        try {
            DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILLOBJECT);
            if (billObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReleaseCheckToolPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            String billNum = (String)this.getModel().getValue("billno");
            if ("".equals(billNum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReleaseCheckToolPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            billName = billObj.getString("number");
            Map<Long, Map<String, Object>> recordMap = this.getRecordDataSet(billNum, billName);
            String opSelectCols = "id,reserveid,billobj,billid,billno,billentryid,billentryseq,balobj,balid,baseqty,qty,qty2nd,op,optype,creater,createdate,traceid,billobj.name";
            QFilter opBillFilter = new QFilter("billno", "=", (Object)billNum);
            opBillFilter = opBillFilter.and("billobj", "=", (Object)billName);
            QFilter opFilter = new QFilter("reserveid", "in", recordMap.keySet());
            opBillFilter = opBillFilter.or(opFilter);
            DataSet opDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ":getOpDataSet"), (String)"msmod_reserve_oplog", (String)opSelectCols, (QFilter[])opBillFilter.toArray(), (String)"createdate");
            IFormView formView = this.getView();
            formView.setVisible(Boolean.valueOf(true), new String[]{"opecordflex"});
            String opEntryName = "entryentity1";
            if (opDataSet.isEmpty()) {
                formView.setVisible(Boolean.valueOf(false), new String[]{opEntryName});
                formView.getModel().setValue("recordinfo1", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u9884\u7559\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"BillReserveOpSearchPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                formView.setVisible(Boolean.valueOf(true), new String[]{"entryentity21"});
            } else {
                formView.setVisible(Boolean.valueOf(true), new String[]{opEntryName});
                formView.setVisible(Boolean.valueOf(false), new String[]{"entryentity21"});
                AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
                model.getDataEntity(true);
                model.deleteEntryData(opEntryName);
                TableValueSetter vs = new TableValueSetter(new String[0]);
                while (opDataSet.hasNext()) {
                    Row row = opDataSet.next();
                    long reserveId = row.getLong("reserveid");
                    vs.addField("reserveid", new Object[]{reserveId});
                    vs.addField("billobj", new Object[]{row.get("billobj")});
                    vs.addField("billobjname", new Object[]{row.get("billobj.name")});
                    vs.addField("billno2", new Object[]{row.get("billno")});
                    vs.addField("billentryseq", new Object[]{row.get("billentryseq")});
                    vs.addField("balobj", new Object[]{row.get("balobj")});
                    vs.addField("balid", new Object[]{row.get("balid")});
                    vs.addField("baseqty", new Object[]{row.get("baseqty")});
                    vs.addField("qty2", new Object[]{row.get("qty")});
                    vs.addField("qty2nd2", new Object[]{row.get("qty2nd")});
                    vs.addField("op", new Object[]{row.get("op")});
                    vs.addField("optype", new Object[]{row.get("optype")});
                    vs.addField("creater", new Object[]{row.get("creater")});
                    vs.addField("createdate", new Object[]{row.get("createdate")});
                }
                model.batchCreateNewEntryRow(opEntryName, vs);
                formView.updateView(opEntryName);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private Map<Long, Map<String, Object>> getRecordDataSet(String billNum, String billName) {
        HashMap<Long, Map<String, Object>> recordMap = new HashMap<Long, Map<String, Object>>(16);
        QFilter recordFilter = new QFilter("bill_no", "=", (Object)billNum);
        recordFilter = recordFilter.and("bill_obj", "=", (Object)billName);
        String recordSelectCols = "id,bal_obj,bal_id,billentry_id,base_qty,qty,qty2nd,aggregateid,reservemethod,reserveobjtype,bal_entryid,bill_no,billentry_seq,s_materiel.number,s_materiel.name,s_unit,s_baseunit,s_unit2nd,create_date,s_billnum,s_entryseq";
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ":getRecordDataSet"), (String)"msmod_reserve_record", (String)recordSelectCols, (QFilter[])recordFilter.toArray(), (String)"id");
        String recordEntryName = "entryentity";
        IFormView formView = this.getView();
        formView.setVisible(Boolean.valueOf(true), new String[]{"recordflex"});
        if (recordDataSet.isEmpty()) {
            formView.setVisible(Boolean.valueOf(false), new String[]{recordEntryName});
            formView.getModel().setValue("recordinfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReleaseCheckToolPlugin_13", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            formView.setVisible(Boolean.valueOf(true), new String[]{"entryentity2"});
            return recordMap;
        }
        formView.setVisible(Boolean.valueOf(true), new String[]{recordEntryName});
        DataSet recordDataSetCopy = recordDataSet.copy();
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        model.getDataEntity(true);
        model.deleteEntryData(recordEntryName);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String[] fieldNameArray = recordDataSetCopy.getRowMeta().getFieldNames();
        while (recordDataSetCopy.hasNext()) {
            Row row = recordDataSetCopy.next();
            long recordId = row.getLong("id");
            HashMap<String, Object> valMap = new HashMap<String, Object>(32);
            for (int i = 0; i < fieldNameArray.length; ++i) {
                valMap.put(fieldNameArray[i], row.get(fieldNameArray[i]));
            }
            recordMap.put(recordId, valMap);
            BigDecimal baseQty = row.getBigDecimal("base_qty");
            if (baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
            vs.addField("recordid", new Object[]{recordId});
            vs.addField("bill_no", new Object[]{row.getString("bill_no")});
            vs.addField("billentry_seq", new Object[]{row.get("billentry_seq")});
            vs.addField("s_materiel", new Object[]{row.get("s_materiel.number")});
            vs.addField("s_materialname", new Object[]{row.get("s_materiel.name")});
            vs.addField("s_unit", new Object[]{row.get("s_unit")});
            vs.addField("qty", new Object[]{row.get("qty")});
            vs.addField("s_baseunit", new Object[]{row.get("s_baseunit")});
            vs.addField("base_qty", new Object[]{baseQty});
            vs.addField("s_unit2nd", new Object[]{row.get("s_unit2nd")});
            vs.addField("qty2nd", new Object[]{row.get("qty2nd")});
            vs.addField("create_date", new Object[]{row.get("create_date")});
            vs.addField("bal_obj", new Object[]{row.get("bal_obj")});
            vs.addField("bal_id", new Object[]{row.get("bal_id")});
            vs.addField("s_billnum", new Object[]{row.get("s_billnum")});
            vs.addField("s_entryseq", new Object[]{row.get("s_entryseq")});
            vs.addField("aggregateid", new Object[]{row.get("aggregateid")});
            vs.addField("reservemethod", new Object[]{row.getString("reservemethod")});
        }
        model.batchCreateNewEntryRow(recordEntryName, vs);
        formView.updateView(recordEntryName);
        formView.setVisible(Boolean.valueOf(false), new String[]{"entryentity2"});
        return recordMap;
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "recordid": {
                this.showForm(row, "entryentity", "recordid", "msmod_reserve_record");
                break;
            }
            case "reserveid": {
                this.showForm(row, "entryentity1", "reserveid", "msmod_reserve_record");
                break;
            }
        }
    }

    private void showForm(int row, String entryName, String idName, String formName) {
        long mapId = this.getModel().getEntryRowEntity(entryName, row).getLong(idName);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)mapId);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

