/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class EnumValueEdit
extends AbstractFormPlugin {
    private static final String F_ENTITY = "entity";
    private static final String F_ENUM_COL = "enumcol";
    private static final String F_ENUM_COL_FLAG = "enumcolflag";
    private static final String F_ENUM_COL_NAME = "enumcolname";
    private volatile boolean trigger = true;
    private MainEntityType tempEntityType;

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        if (!this.trigger) {
            return;
        }
        switch (name = e.getProperty().getName()) {
            case "entity": {
                this.trigger = false;
                this.entityChanged(e);
                break;
            }
            case "enumcol": {
                this.trigger = false;
                this.enumColChanged(e);
                break;
            }
        }
    }

    private void enumColChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String selectedCol = model.getDataEntity().getString(F_ENUM_COL);
        if (StringUtils.isBlank((CharSequence)selectedCol)) {
            this.clearSelectedCol();
        } else {
            MainEntityType type = this.getEntityType();
            if (type != null) {
                IDataEntityProperty pro = type.findProperty(selectedCol);
                model.setValue(F_ENUM_COL_FLAG, (Object)pro.getName());
                model.setValue(F_ENUM_COL_NAME, (Object)pro.getDisplayName());
            }
        }
    }

    private void clearSelectedCol() {
        IDataModel model = this.getModel();
        model.setValue(F_ENUM_COL_FLAG, (Object)"");
        model.setValue(F_ENUM_COL_NAME, (Object)"");
    }

    private void entityChanged(PropertyChangedArgs e) {
        this.clearSelectedCol();
        this.initEnumCol();
    }

    private void initEnumCol() {
        ComboEdit combo = (ComboEdit)this.getControl(F_ENUM_COL);
        ArrayList<ComboItem> pros = new ArrayList<ComboItem>(16);
        MainEntityType type = this.getEntityType();
        if (type != null) {
            Map allFields = type.getAllFields();
            for (IDataEntityProperty pro : allFields.values()) {
                ComboItem tempItem = new ComboItem(pro.getDisplayName(), pro.getName());
                pros.add(tempItem);
            }
        }
        combo.setComboItems(pros);
        DynamicObject data = this.getModel().getDataEntity();
        String selectedCol = data.getString(F_ENUM_COL_FLAG);
        this.getModel().setValue(F_ENUM_COL, (Object)selectedCol);
    }

    private MainEntityType getEntityType() {
        if (this.tempEntityType == null) {
            DynamicObject entity = this.getModel().getDataEntity().getDynamicObject(F_ENTITY);
            this.tempEntityType = entity != null ? MetadataServiceHelper.getDataEntityType((String)entity.getPkValue().toString()) : null;
        }
        return this.tempEntityType;
    }

    public void afterCreateNewData(EventObject e) {
        this.initEnumCol();
    }
}

