/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.reserve.common.colsAssist.SelectParams;
import kd.mpscmm.msbd.reserve.common.util.ColsTreeUtil;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;

public class FieldMappingEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(FieldMappingEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetobjcolno", "sourcebillcolno"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjcolno": {
                this.clickTargetObjCol(evt);
                break;
            }
            case "sourcebillcolno": {
                this.clickSourceObjCol();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "targetobj": {
                this.targetColClosedCallBack(e);
                break;
            }
            case "sourcebill": {
                this.sourceColClosedCallBack(e);
                break;
            }
        }
    }

    private void sourceColClosedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        model.setValue("sourcebillcol", (Object)id, index);
        model.setValue("sourcebillcolno", (Object)info.getString("text"), index);
    }

    private void targetColClosedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        model.setValue("targetobjcol", (Object)id, index);
        model.setValue("targetobjcolno", (Object)info.getString("text"), index);
    }

    private void clickTargetObjCol(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("targetobj");
        if (targetObj == null) {
            String message = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"FieldMappingEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        this.showColsTreePage(targetObj.getString("number"), "targetobj");
    }

    private void clickSourceObjCol() {
        DynamicObject sourceObj = (DynamicObject)this.getModel().getValue("sourcebill");
        if (sourceObj == null) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"FieldMappingEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        this.showColsTreePage(sourceObj.getString("number"), "sourcebill");
    }

    private void showColsTreePage(String entityNumber, String key) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        option.setIncludePKField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        SelectParams params = new SelectParams();
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }
}

