/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.UnitHelper;
import kd.mpscmm.msbd.reserve.business.helper.MaterialHelper;
import kd.mpscmm.msbd.reserve.business.helper.PrecisionAccountEnum;
import kd.mpscmm.msbd.reserve.business.helper.UnitConverDirEnum;
import kd.mpscmm.msbd.reserve.common.util.BigDecimalUtils;
import kd.mpscmm.msbd.reserve.common.util.DateUtils;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;

public class ReserveBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(ReserveBillEditPlugin.class);
    public static final ThreadLocal<Boolean> triggerChangeEventLocal = new ThreadLocal();
    AbstractFormPlugin plugin;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "material", "location", "configuredcode", "reserveobj", "unit");
        this.addClickListeners(new String[]{"lotnumber"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "location": {
                this.beforeLocation(e);
                break;
            }
            case "configuredcode": {
                this.beforeTrackNumOrConfigCode(showParameter, rowIndex, key);
                break;
            }
            case "reserveobj": {
                this.beforeReseveobj(showParameter, rowIndex, key);
                break;
            }
            case "unit": {
                this.beforeUnit(showParameter, rowIndex, key);
                break;
            }
            case "material": {
                Object value = this.getModel().getValue("invorg", rowIndex);
                if (value != null) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u3002", (String)"SCOMMON-W-075252", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        }
    }

    private void beforeUnit(ListShowParameter showParameter, int rowIndex, String key) {
        Object value = this.getModel().getValue("material", rowIndex);
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ReserveBillEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        IDataModel bill = this.getModel();
        Long masterMaterialId = 0L;
        Object material = bill.getValue("material", rowIndex);
        Object masterMaterial = material;
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : Long.valueOf(baseUnit.getPkValue().toString());
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeReseveobj(ListShowParameter showParameter, int rowIndex, String key) {
        String value = (String)this.getModel().getValue("reserveobjtype", rowIndex);
        if ("bd_operator".equals(value)) {
            QFilter qFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void beforeTrackNumOrConfigCode(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                DynamicObject material = (DynamicObject)value;
                qFilter = ReserveBillEditPlugin.getConfigureCodeFilter(material.get("masterid.id"));
            }
        } else {
            qFilter = ReserveBillEditPlugin.getTrackNumberFilter();
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static QFilter getConfigureCodeFilter(Object masterId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("material.status", "=", (Object)"C");
        qFilter.and("material.enable", "=", (Object)"1");
        qFilter.and("material.id", "=", masterId);
        return qFilter;
    }

    public static QFilter getTrackNumberFilter() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("trackstatus", "=", (Object)"0");
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (newValue instanceof BigDecimal && oldValue instanceof BigDecimal && newValue != null && oldValue != null && ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) == 0) {
            return;
        }
        switch (propName) {
            case "material": {
                this.resetMaterial((DynamicObject)newValue, rowIndex);
                this.changeMaterialByBillAuxpty((DynamicObject)newValue, rowIndex);
                this.changeMaterialByBillLot((DynamicObject)newValue, rowIndex);
                break;
            }
            case "qty": {
                this.changeAuditQty(oldValue, newValue, rowIndex);
                break;
            }
            case "qtyunit2nd": {
                this.changeQtyOrUnitByBillBizQty(propName, newValue, rowIndex);
                break;
            }
            case "unit": {
                this.changeQtyOrUnitByBillBizQty(propName, newValue, rowIndex);
                break;
            }
            case "producedate": {
                this.changeProduceDate((Date)newValue, rowIndex);
                break;
            }
            case "expirydate": {
                this.changeExpirydate((Date)oldValue, (Date)newValue, rowIndex);
                break;
            }
            case "warehouse": {
                this.changeWarehouse(valueSet);
                break;
            }
            case "invorg": {
                this.clearEntryField("material", rowIndex);
                ReserveBillEditPlugin.updateViewRow(this.getView(), rowIndex, "billentry");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": {
                this.openPageSelectLotMainfile(key);
                break;
            }
        }
    }

    private void beforeLocation(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
        if (ReserveBillEditPlugin.isNull(warehouse)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u4fe1\u606f\u3002", (String)"ReserveBillEditPlugin_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        List<Long> ids = this.getLoactionIds(locationCol);
        QFilter qFilter1 = new QFilter("id", "in", ids);
        showParameter.getListFilterParameter().setFilter(qFilter1);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (ReserveBillEditPlugin.isNull(locationCol) || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private void changeWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowindex = valueSet[i].getRowIndex();
            ReserveBillEditPlugin.setValue(this.getModel(), "location", null, rowindex, false);
            if (!ReserveBillEditPlugin.isNull(newValue)) {
                boolean isopenlocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
                if (isopenlocation) {
                    this.getView().setEnable(Boolean.TRUE, rowindex, new String[]{"location"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
        }
    }

    private void changeExpirydate(Date oldExpirydate, Date date, int rowIndex) {
        Date oldProducedate;
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife(materialInvInfo, false)) {
            Date oldProducedate2 = (Date)model.getValue("producedate", rowIndex);
            this.checkShelflifeDate(oldProducedate2, date, rowIndex, "expirydate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate = (Date)model.getValue("producedate", rowIndex);
        if (!"2".equals(calculationForEndDate)) {
            producedate = ReserveBillEditPlugin.shelflifeDateCal(shelflifeUnit, shelflife * -1, date, calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165,\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ReserveBillEditPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            ReserveBillEditPlugin.setValue(this.getModel(), "expirydate", oldExpirydate, rowIndex, false);
            return;
        }
        ReserveBillEditPlugin.setValue(this.getModel(), "producedate", producedate, rowIndex, false);
    }

    private void changeProduceDate(Date date, int rowIndex) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife(materialInvInfo, true)) {
            Date expirydate = (Date)this.getModel().getValue("expirydate", rowIndex);
            this.checkShelflifeDate(date, expirydate, rowIndex, "producedate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ReserveBillEditPlugin.shelflifeDateCal(shelflifeUnit, shelflife = materialInvInfo.getInt("shelflife"), date, calculationForEndDate = materialInvInfo.getString("calculationforenddate"));
        if (expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u201c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u201d\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ReserveBillEditPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            ReserveBillEditPlugin.setValue(this.getModel(), "producedate", null, rowIndex, false);
            return;
        }
        ReserveBillEditPlugin.setValue(this.getModel(), "expirydate", expirydate, rowIndex, false);
    }

    private void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u201c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u201d\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ReserveBillEditPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            ReserveBillEditPlugin.setValue(this.getModel(), key, null, rowIndex, false);
        }
    }

    public static Date shelflifeDateCal(String shelflifeunit, int shelflife, Date inDate, String calculationforenddate) {
        if ("day".equals(shelflifeunit)) {
            if ("0".equals(calculationforenddate)) {
                return DateUtils.addDay(inDate, shelflife);
            }
            if ("1".equals(calculationforenddate)) {
                return DateUtils.addDay(inDate, shelflife > 0 ? shelflife - 1 : shelflife + 1);
            }
            if ("2".equals(calculationforenddate)) {
                return DateUtils.getLastMonthEndDayByDate(DateUtils.addDay(inDate, shelflife));
            }
        }
        if ("month".equals(shelflifeunit)) {
            if ("0".equals(calculationforenddate)) {
                return DateUtils.addMonth(inDate, shelflife);
            }
            if ("1".equals(calculationforenddate)) {
                Date date = DateUtils.addMonth(inDate, shelflife);
                if (shelflife < 0) {
                    return DateUtils.addOneDay(date);
                }
                return DateUtils.reduceOneDay(date);
            }
            if ("2".equals(calculationforenddate)) {
                return DateUtils.getLastMonthEndDayByDate(DateUtils.addMonth(inDate, shelflife));
            }
        }
        if ("year".equals(shelflifeunit)) {
            if ("0".equals(calculationforenddate)) {
                return DateUtils.addYear(inDate, shelflife);
            }
            if ("1".equals(calculationforenddate)) {
                Date date = DateUtils.addYear(inDate, shelflife);
                if (shelflife < 0) {
                    return DateUtils.addOneDay(date);
                }
                return DateUtils.reduceOneDay(date);
            }
            if ("2".equals(calculationforenddate)) {
                return DateUtils.getLastMonthEndDayByDate(DateUtils.addYear(inDate, shelflife));
            }
        }
        return DateUtils.addDay(inDate, shelflife);
    }

    public static void setValue(IDataModel model, String key, Object value, int i, boolean isTriggerChangeEvent) {
        triggerChangeEventLocal.set(isTriggerChangeEvent);
        if (value == null) {
            model.setValue(key, null, i);
        } else {
            model.setValue(key, value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value, i);
        }
        triggerChangeEventLocal.remove();
    }

    private String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    private void openPageSelectLotMainfile(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = model.getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotnumField = "billentry." + fieldKey;
        String lotld = "billentry.lot";
        ReserveBillEditPlugin.showPageLotMainfileList((IFormPlugin)this, this.getView(), bill, selectEntry, lotnumField, lotld, model);
    }

    public static void showPageLotMainfileList(IFormPlugin form, IFormView view, DynamicObject bill, DynamicObject selectEntry, String lotnumField, String lotld, IDataModel model) {
        if (ReserveBillEditPlugin.isUseLotMainFile()) {
            DynamicObject matreialDy = (DynamicObject)model.getValue("material");
            if (matreialDy != null) {
                Long masterid = matreialDy.getLong("masterid.id");
                QFilter filter = new QFilter("material", "=", (Object)masterid);
                HashMap<String, String> paramMap = new HashMap<String, String>(4);
                paramMap.put("formId", "msmod_selectlot");
                paramMap.put("lotidfield", lotld);
                paramMap.put("lotnumfield", lotnumField);
                paramMap.put("filter", filter.toSerializedString());
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack(form, "msmod_selectlot"));
                view.showForm(showParameter);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ReserveBillEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"ReserveBillEditPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "msmod_selectlot": {
                this.closedSelectedLot(e);
                break;
            }
        }
    }

    private void closedSelectedLot(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("billentry");
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            String lotnumfield = (String)lotAttr.get("lotnumfield");
            model.setValue(lotnumfield, lotAttr.get("lotnumber"), rowIndex);
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }

    public static boolean isUseLotMainFile() {
        return ReserveBillEditPlugin.isEnable("sbs_scmcapplevelparam", "INV0003");
    }

    public static boolean isEnable(String entityNumber, String paramNumber) {
        DynamicObject systemCallParam = BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)"enable", (QFilter[])new QFilter("number", "=", (Object)paramNumber).toArray());
        return systemCallParam != null && systemCallParam.getBoolean("enable");
    }

    private void changeAuditQty(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        if (qty.compareTo((BigDecimal)newValue) < 0) {
            this.getModel().setValue("qty", oldValue, rowIndex);
        } else {
            this.changeQtyOrUnitByBillBizQty("qty", newValue, rowIndex);
        }
    }

    private void changeQtyOrUnitByBillBizQty(String propName, Object newValue, int rowIndex) {
        IDataModel bill;
        Object material;
        if ("unit".equals(propName)) {
            this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        if (StringUtils.isBlank((Object)(material = (bill = this.getModel()).getValue("material", rowIndex)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ReserveBillEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        ReserveBillEditPlugin.setBizQtyAndUnitWithAuditQty(bill, rowIndex, propName, newValue);
        ReserveBillEditPlugin.setAuxBizQtyAndUnit(bill, rowIndex, propName, newValue);
        ReserveBillEditPlugin.updateViewRow(this.getView(), rowIndex, "billentry");
    }

    public static void setAuxBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowindex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        switch (fieldName) {
            case "qty": 
            case "unit": {
                ReserveBillEditPlugin.changeUntAndQty(bill, rowindex, material, auxptyUnit);
                break;
            }
            case "qtyunit2nd": {
                ReserveBillEditPlugin.changeAuxptyQty(bill, rowindex, material);
                break;
            }
        }
    }

    private static void changeAuxptyQty(IDataModel bill, int rowindex, DynamicObject material) {
        boolean isConvert;
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConverDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConverDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        DynamicObject unit2nd = (DynamicObject)bill.getValue("unit2nd", rowindex);
        BigDecimal qtyUnit2nd = (BigDecimal)bill.getValue("qtyunit2nd", rowindex);
        BigDecimal baseQty = ReserveBillEditPlugin.getDesQtyConv(material, unit2nd, qtyUnit2nd, baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip(bill, baseQty, "baseqty");
        bill.beginInit();
        bill.setValue("baseqty", (Object)baseQty, rowindex);
        bill.endInit();
        ReserveBillEditPlugin.setQtyByBaseQtyChange(bill, rowindex, material, baseUnit, baseQty);
    }

    private static void setQtyByBaseQtyChange(IDataModel bill, int rowindex, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty) {
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = (DynamicObject)bill.getValue("unit", rowindex);
            if (unit == null) {
                return;
            }
            qty = ReserveBillEditPlugin.getDesQtyConv(material, baseUnit, baseQty, unit);
        }
        BigDecimalUtils.showBigDecimalErrorTip(bill, qty, "qty");
        bill.beginInit();
        bill.setValue("qty", (Object)qty, rowindex);
        bill.endInit();
    }

    private static void changeUntAndQty(IDataModel bill, int rowindex, DynamicObject material, DynamicObject auxptyUnit) {
        boolean isConvert;
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConverDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConverDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            bill.beginInit();
            bill.setValue("qtyunit2nd", (Object)BigDecimal.ZERO, rowindex);
            bill.endInit();
            return;
        }
        BigDecimal qtyUnit2nd = ReserveBillEditPlugin.getDesQtyConv(material, baseUnit, baseQty, auxptyUnit);
        BigDecimalUtils.showBigDecimalErrorTip(bill, qtyUnit2nd, "qtyunit2nd");
        bill.beginInit();
        bill.setValue("qtyunit2nd", (Object)qtyUnit2nd, rowindex);
        bill.endInit();
    }

    public static void setBizQtyAndUnitWithAuditQty(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        ReserveBillEditPlugin.setBizQtyAndUnit(bill, rowindex, fieldName, newValue, true);
    }

    private static void setBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue, boolean isBaseAuditQty) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowindex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        switch (fieldName) {
            case "qty": {
                ReserveBillEditPlugin.changeQty(bill, rowindex, (BigDecimal)newValue, material);
                break;
            }
            case "unit": {
                if (isBaseAuditQty) {
                    ReserveBillEditPlugin.changeUnitByAuditQty(bill, rowindex, (DynamicObject)newValue, material);
                    break;
                }
                ReserveBillEditPlugin.changeUnit(bill, rowindex, (DynamicObject)newValue, material);
                break;
            }
        }
    }

    private static void changeUnit(IDataModel bill, int rowindex, DynamicObject unit, DynamicObject material) {
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        qty = ReserveBillEditPlugin.dealWithprecision(unit, qty);
        bill.setValue("qty", (Object)qty, rowindex);
        ReserveBillEditPlugin.setBaseQtyValue(bill, rowindex, material, qty, baseUnit, unit);
    }

    private static void changeUnitByAuditQty(IDataModel bill, int rowindex, DynamicObject unit, DynamicObject material) {
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowindex);
        qty = ReserveBillEditPlugin.dealWithprecision(unit, qty);
        bill.setValue("qty", (Object)qty, rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        ReserveBillEditPlugin.setBaseQtyValue(bill, rowindex, material, qty, baseUnit, unit);
    }

    public static BigDecimal dealWithprecision(DynamicObject unit, BigDecimal srcmuCount) {
        if (unit == null) {
            return srcmuCount;
        }
        return srcmuCount.setScale(unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal(unit.getInt("precisionaccount")));
    }

    private static void changeQty(IDataModel bill, int rowindex, BigDecimal qty, DynamicObject material) {
        DynamicObject unit = (DynamicObject)bill.getValue("unit", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        ReserveBillEditPlugin.setBaseQtyValue(bill, rowindex, material, qty, baseUnit, unit);
    }

    private static void setBaseQtyValue(IDataModel bill, int rowindex, DynamicObject material, BigDecimal qty, DynamicObject baseUnit, DynamicObject unit) {
        BigDecimal baseQty = ReserveBillEditPlugin.getDesQtyConv(material, unit, qty, baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip(bill, baseQty, "baseqty");
        bill.beginInit();
        bill.setValue("baseqty", (Object)baseQty, rowindex);
        bill.endInit();
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal(Integer.parseInt(precisionAccount)));
                }
            }
        }
        return BigDecimal.ZERO;
    }

    private void changeMaterialByBillLot(DynamicObject materialInvInfo, int rowIndex) {
        IDataModel bill = this.getModel();
        bill.setValue("lotnumber", null, rowIndex);
        if (null == materialInvInfo) {
            return;
        }
        Boolean enablelot = materialInvInfo.getBoolean("enablelot");
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lot"});
    }

    private void changeMaterialByBillAuxpty(DynamicObject materialInvInfo, int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject material = MaterialHelper.getMaterialByMatBiz(materialInvInfo);
        if (!ReserveBillEditPlugin.isNull(material)) {
            Boolean isuseauxpty = material.getBoolean("isuseauxpty");
            if (isuseauxpty.booleanValue() && UnitHelper.isExistField(bill, "auxpty")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"auxpty"});
            }
            this.getView().setEnable(isuseauxpty, rowIndex, new String[]{"auxpty"});
        }
    }

    private void resetMaterial(DynamicObject material, int rowIndex) {
        IDataModel bill = this.getModel();
        this.clearMaterialInfo(bill, rowIndex);
        if (material != null) {
            this.resetMaterialInfo(bill, material, rowIndex);
        }
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject material, int rowIndex) {
        DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz(material);
        this.getView().setEnable(Boolean.valueOf("2".equals(masterMaterial.get("configproperties"))), rowIndex, new String[]{"configuredcode"});
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"ReserveBillEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        bill.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        DynamicObject unit = MaterialHelper.getMaterialBizUnit(material);
        bill.setValue("unit", unit.getPkValue(), rowIndex);
        boolean isOnShelf = material.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        DynamicObject invUnit = material.getDynamicObject("inventoryunit");
        if (invUnit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u7684\u5e93\u5b58\u5355\u4f4d\u3002", (String)"ReserveBillEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseAuxptyUnit = auxptyUnit != null;
        if (isUseAuxptyUnit.booleanValue()) {
            BigDecimal unit2ndRate = ReserveBillEditPlugin.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)auxptyUnit.getPkValue(), (Long)baseUnit.getPkValue());
            unit2ndRate = unit2ndRate == null ? BigDecimal.ZERO : unit2ndRate;
            bill.setValue("unit2nd", auxptyUnit.getPkValue(), rowIndex);
            this.getView().setVisible(Boolean.TRUE, new String[]{"unit2nd"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"qtyunit2nd"});
        }
        this.getView().setEnable(isUseAuxptyUnit, rowIndex, new String[]{"qtyunit2nd"});
        ReserveBillEditPlugin.updateViewRow(this.getView(), rowIndex, "billentry");
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e24\u4e2a\u5355\u4f4d\u7684\u6362\u7b97\u7387\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    private static void updateViewCell(IFormView view, int index, String entryField, String key) {
        IDataModel model = view.getModel();
        if (UnitHelper.isExistField(model, entryField, key) && !ReserveBillEditPlugin.isNull(view.getControl(key))) {
            view.updateView(key, index);
        }
    }

    private void clearEntryField(String fieldkey, int rowIndex) {
        IDataModel model = this.getModel();
        if (UnitHelper.isExistField(model, "billentry", fieldkey)) {
            model.setValue(fieldkey, null, rowIndex);
        }
    }

    public static void updateViewRow(IFormView view, int index, String entryField) {
        IDataModel model = view.getModel();
        Map type = model.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryField);
        Map map = entityType.getFields();
        for (Map.Entry field : map.entrySet()) {
            String key = (String)field.getKey();
            ReserveBillEditPlugin.updateViewCell(view, index, entryField, key);
        }
    }

    private void clearMaterialInfo(IDataModel bill, int rowindex) {
        bill.beginInit();
        this.clearEntryField("unit", rowindex);
        this.clearEntryField("qty", rowindex);
        this.clearEntryField("baseunit", rowindex);
        this.clearEntryField("baseqty", rowindex);
        this.clearEntryField("unit2nd", rowindex);
        this.clearEntryField("qtyunit2nd", rowindex);
        this.clearEntryField("auxpty", rowindex);
        this.clearEntryField("lotnumber", rowindex);
        this.clearEntryField("producedate", rowindex);
        this.clearEntryField("expirydate", rowindex);
        this.clearEntryField("configuredcode", rowindex);
        bill.endInit();
        ReserveBillEditPlugin.updateViewRow(this.getView(), rowindex, "billentry");
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).size() == 0) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        int parentRowIndex = 0;
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        for (int i = 0; i < rowDataEntities.length; ++i) {
            Object value;
            RowDataEntity rowDataEntity = rowDataEntities[i];
            int curRowIndex = rowDataEntity.getRowIndex();
            if (i == 0 && curRowIndex != 0) {
                parentRowIndex = curRowIndex - 1;
            }
            if ((value = this.getModel().getValue("invorg", parentRowIndex)) == null) continue;
            rowDataEntity.getDataEntity().set("invorg", value);
            ReserveBillEditPlugin.updateViewCell(this.getView(), curRowIndex, entryName, "invorg");
        }
    }
}

