/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.trans.FieldFormTranslator;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.billresult.RuleResultHandlerFactory;
import kd.mpscmm.msbd.reserve.common.colsAssist.SelectParams;
import kd.mpscmm.msbd.reserve.common.util.ColsTreeUtil;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;
import org.apache.commons.beanutils.ConvertUtils;

public class ReserveInvRuleEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(ReserveInvRuleEditPlugin.class);
    private static final String BTN_SELECT = "btnselect";
    private static final String P_ENUM_VALUE = "msmod_enumvalue";
    private static final String BAL_MODEL = "BalanceModel";
    private static final String BOS_MULTITEXT = "bos_multitext";
    private static final String IDE_COMBOITEMSSELECT = "ide_comboitemsselect";
    private static final String MSCOMMON_COMBOITEMSSELECT = "mscommon_comboitemsselect";
    private static final List<String> COMPARE_TYPE_LIST = new ArrayList<String>();
    private static final List<String> COMPARE_TYPEFILED_LIST = new ArrayList<String>();
    private static final String BASEDATAPROP = "BasedataProp";
    private static final String TEXTPROP = "TextProp";
    private static final String COMBOPROP = "CombProp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"require_bill_col", "std_inv_col", BTN_SELECT, "sort_field"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("supsrcobj");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRulePluginVisible();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int index = e.getRowDataEntities()[0].getRowIndex();
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"require_bill_date"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.handleBtnOkEvent(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        if (logger.isDebugEnabled()) {
            logger.debug("ReserveInvRuleEditPlugin.propertyChanged: " + key);
        }
        int index = this.getModel().getEntryCurrentRowIndex("rule_entry");
        switch (key) {
            case "use_plugin": {
                this.handleRulePluginVisible(newValue);
                break;
            }
            case "std_inv_col": {
                this.getModel().setValue("compare_type", null, index, 2);
                this.getModel().setValue("require_bill_col", null, index, 3);
                this.getModel().setValue("require_bill_col_no", null, index, 4);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("compare_type", null);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col", null);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col_no", null);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_date", null);
                this.getView().updateView("require_bill_date", index);
                break;
            }
            case "compare_type": {
                this.getModel().setValue("require_bill_col", null, index, 3);
                this.getModel().setValue("require_bill_col_no", null, index, 4);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col", null);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col_no", null);
                ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_date", null);
                this.getView().updateView("require_bill_date", index);
                this.handleCompareTypeChanged(newValue, index);
                break;
            }
            case "require_bill_col": {
                this.handleRequireBillColChanged(newValue, index);
                break;
            }
            case "supsrcobj": {
                this.setIsPredict(newValue);
                break;
            }
            case "std_inv_col_no": {
                this.handleBillEnable(index);
            }
        }
    }

    private void handleBillEnable(int index) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String invColField = (String)model.getValue("std_inv_col_no", index);
        boolean dateField = this.checkIfDateField(invColField);
        view.setEnable(Boolean.valueOf(dateField), index, new String[]{"require_bill_date"});
    }

    private void setIsPredict(Object newValue) {
        if (newValue == null) {
            return;
        }
        String modeltype = ((DynamicObject)newValue).getString("modeltype");
        this.getModel().setValue("ispredict", (Object)(!BAL_MODEL.equals(modeltype) ? 1 : 0));
    }

    private void handleRequireBillColChanged(Object newValue, int index) {
        IDataModel model = this.getModel();
        String colName = (String)model.getValue("std_inv_col_no", index);
        String compare = (String)model.getValue("compare_type", index);
        Map<String, Object> fieldProp = this.getBaseEntityId(colName);
        boolean qtyProp = this.checkIfBigDecimalField(colName);
        IPageCache pageCache = this.getPageCache();
        Set<String> baseDataProp = fieldProp.keySet();
        if (baseDataProp.contains(BASEDATAPROP)) {
            String key = pageCache.get("key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                model.setValue("require_bill_col", null, index);
            }
        } else if (qtyProp) {
            String key = pageCache.get("key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                if (COMPARE_TYPEFILED_LIST.contains(compare)) {
                    model.setValue("require_bill_col", null, index);
                    model.setValue("require_bill_col_no", null, index);
                } else {
                    Object qty = ReserveInvRuleEditPlugin.parseToBigDecimal(newValue, compare);
                    model.setValue("require_bill_col", qty, index);
                    model.setValue("require_bill_col_no", qty, index);
                }
            }
        } else if (baseDataProp.contains(COMBOPROP)) {
            String key = pageCache.get("key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                model.setValue("require_bill_col", null, index);
            }
        } else {
            String key = pageCache.get("key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                if (COMPARE_TYPEFILED_LIST.contains(compare)) {
                    model.setValue("require_bill_col", null, index);
                    model.setValue("require_bill_col_no", null, index);
                } else {
                    model.setValue("require_bill_col", newValue, index);
                    model.setValue("require_bill_col_no", newValue, index);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)((String)newValue))) {
            model.setValue("require_bill_col_no", null, index);
        }
    }

    private static Object parseToBigDecimal(Object value, String compre) {
        try {
            if ("D".equals(compre) || "I".equals(compre)) {
                String[] split;
                String values = (String)value;
                for (String s : split = values.split(",")) {
                    Double.valueOf(s);
                }
                return value;
            }
            return BigDecimal.valueOf(Double.parseDouble(value.toString()));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "require_bill_col": {
                this.clickRequireBillCol(key);
                break;
            }
            case "std_inv_col": {
                this.clickReserveBillCol(evt, key);
                break;
            }
            case "btnselect": {
                this.handleBtnSelectEvent();
                break;
            }
            case "sort_field": {
                this.clickSortFieldCol(evt, key);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "require_bill_col": {
                this.callBack4RequireBillCol(e);
                break;
            }
            case "std_inv_col": {
                this.callBack4ReserveBillCol(e);
                break;
            }
            case "btnselect": {
                this.callBack4SelectRule(e);
                break;
            }
            case "custom": {
                this.callBack4ExtendField(e);
                break;
            }
            case "baseData": {
                this.callBack4BaseDataField(e);
                break;
            }
            case "bos_multitext": {
                this.callBack4TextActionIdField(e);
                break;
            }
            case "ide_comboitemsselect": {
                this.callBack4ComboActionIdField(e);
                break;
            }
            case "mscommon_comboitemsselect": {
                this.callBack4MultipleComboField(e);
                break;
            }
            case "sort_field": {
                this.callBack4SortFieldCol(e);
                break;
            }
        }
    }

    private void callBack4MultipleComboField(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        Object returnData = e.getReturnData();
        StringBuilder col = new StringBuilder();
        StringBuilder colNo = new StringBuilder();
        if (returnData != null) {
            List combPropValueList = SerializationUtils.fromJsonStringToList((String)returnData.toString(), CRFormula.class);
            for (CRFormula crFormula : combPropValueList) {
                if (col.length() > 0) {
                    col.append(",");
                }
                if (colNo.length() > 0) {
                    colNo.append(",");
                }
                String name = crFormula.getExprTran();
                String value = crFormula.getExpression();
                col.append(name);
                colNo.append(value);
            }
            int index = Integer.parseInt(this.getPageCache().get("selectRowIndex"));
            this.getPageCache().put("key", "value");
            model.setValue("require_bill_col", (Object)col, index);
            model.setValue("require_bill_col_no", (Object)colNo, index);
            this.getPageCache().remove("key");
        }
    }

    private void callBack4ComboActionIdField(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        Object returnData = e.getReturnData();
        if (returnData != null) {
            CRFormula combPropValue = (CRFormula)SerializationUtils.fromJsonString((String)returnData.toString(), CRFormula.class);
            String value = combPropValue.getExpression();
            String name = combPropValue.getExprTran();
            int index = Integer.parseInt(this.getPageCache().get("selectRowIndex"));
            this.getPageCache().put("key", "value");
            model.setValue("require_bill_col", (Object)name, index);
            model.setValue("require_bill_col_no", (Object)value, index);
            this.getPageCache().remove("key");
        }
    }

    private void callBack4TextActionIdField(ClosedCallBackEvent e) {
        String returnDataObj = (String)e.getReturnData();
        if (!StringUtils.isEmpty((CharSequence)returnDataObj)) {
            String value = returnDataObj.replaceAll("\n", ",");
            this.getPageCache().put("key", "value");
            this.getModel().setValue("require_bill_col", (Object)value);
            this.getModel().setValue("require_bill_col_no", (Object)value);
            this.getPageCache().remove("key");
        }
    }

    private void handleRequireBillEnable(int index) {
        boolean dateColEnable;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String compareType = (String)model.getValue("compare_type", index);
        String invColField = (String)model.getValue("std_inv_col_no", index);
        boolean dateField = this.checkIfDateField(invColField);
        if (compareType == null) {
            view.setEnable(Boolean.FALSE, index, new String[]{"require_bill_date"});
            return;
        }
        if (COMPARE_TYPE_LIST.contains(compareType) && dateField) {
            dateColEnable = Boolean.TRUE;
            view.setEnable(Boolean.FALSE, index, new String[]{"require_bill_col"});
        } else {
            dateColEnable = Boolean.FALSE;
            model.setValue("require_bill_date", null, index);
        }
        view.setEnable(Boolean.valueOf(dateColEnable), index, new String[]{"require_bill_date"});
    }

    private void setRulePluginVisible() {
        IDataModel model = this.getModel();
        boolean usePlugin = (Boolean)model.getValue("use_plugin");
        this.getView().setVisible(Boolean.valueOf(usePlugin), new String[]{"rule_plugin"});
    }

    private void handleCompareTypeChanged(Object newValue, int index) {
        String invColField;
        boolean dateField;
        boolean isEnable = true;
        if ("E".equals(newValue) || "F".equals(newValue)) {
            isEnable = false;
            ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col", null);
            ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_col_no", null);
            ((DynamicObject)this.getModel().getEntryEntity("rule_entry").get(index)).set("require_bill_date", null);
        }
        if (!(dateField = this.checkIfDateField(invColField = (String)this.getModel().getValue("std_inv_col_no", index)))) {
            this.getModel().beginInit();
            this.getView().setEnable(Boolean.valueOf(isEnable), index, new String[]{"require_bill_col"});
            this.getView().setEnable(Boolean.valueOf(isEnable), index, new String[]{"require_bill_col_no"});
            this.getView().updateView("require_bill_col", index);
            this.getView().updateView("require_bill_col_no", index);
            this.getModel().endInit();
        } else if ("<".equals(newValue) || ">".equals(newValue) || "=".equals(newValue) && dateField) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"require_bill_col"});
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"require_bill_date"});
        } else {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"require_bill_col"});
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"require_bill_date"});
        }
    }

    private void handleRulePluginVisible(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{"rule_plugin"});
    }

    private void callBack4ExtendField(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        model.beginInit();
        if (rows != null && rows.size() != 0) {
            Map<Object, DynamicObject> enumValueData = this.getAllEnumValueData(rows);
            StringBuilder nameSb = new StringBuilder();
            StringBuilder valueSb = new StringBuilder();
            for (ListSelectedRow row : rows) {
                DynamicObject singleEnumValue = enumValueData.get(row.getPrimaryKeyValue());
                if (singleEnumValue == null) continue;
                nameSb.append(singleEnumValue.getString("dbvalue")).append(",");
                valueSb.append(singleEnumValue.getString("colvalue")).append(",");
            }
            int index = Integer.parseInt(this.getPageCache().get("selectRowIndex"));
            model.setValue("require_bill_col_no", nameSb.length() > 0 ? nameSb.substring(0, nameSb.length() - 1) : null, index);
            model.setValue("require_bill_col", valueSb.length() > 0 ? valueSb.substring(0, valueSb.length() - 1) : null, index);
        }
        model.endInit();
        this.getView().updateView("rule_entry");
    }

    private Map<Object, DynamicObject> getAllEnumValueData(ListSelectedRowCollection rows) {
        Object[] enumValueIds = new Object[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            enumValueIds[i] = rows.get(i).getPrimaryKeyValue();
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])enumValueIds, (String)P_ENUM_VALUE);
    }

    private void callBack4BaseDataField(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        StringBuilder col = new StringBuilder();
        StringBuilder colNo = new StringBuilder();
        if (rows == null) {
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            String name;
            ListSelectedRow row = rows.get(i);
            if (col.length() > 0) {
                col.append(",");
            }
            if (colNo.length() > 0) {
                colNo.append(",");
            }
            if (StringUtils.isEmpty((CharSequence)(name = row.getName()))) {
                col.append(row.getNumber());
            } else {
                col.append(name);
            }
            Object valueId = row.getPrimaryKeyValue();
            colNo.append(valueId);
        }
        int index = Integer.parseInt(this.getPageCache().get("selectRowIndex"));
        this.getPageCache().put("key", "value");
        model.setValue("require_bill_col", (Object)col.toString(), index);
        model.setValue("require_bill_col_no", (Object)colNo.toString(), index);
        this.getPageCache().remove("key");
    }

    private void callBack4SortFieldCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "sort_field", "sort_field_no", "sort_entry");
    }

    private void handleBtnSelectEvent() {
        ListShowParameter baseDataF7Param = ShowFormHelper.createShowListForm((String)"msmod_reserve_inv_rule", (boolean)false);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(new QFilter("demandsrcobj", "=", this.getModel().getValue("demandsrcobj_id")));
        baseDataF7Param.setListFilterParameter(filterParameter);
        baseDataF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SELECT));
        this.getView().showForm((FormShowParameter)baseDataF7Param);
    }

    private void handleBtnOkEvent(AfterDoOperationEventArgs e) {
        if (!e.getOperationResult().isSuccess()) {
            return;
        }
        IDataModel model = this.getModel();
        Object desc = model.getValue("rule_desc");
        String ruleDesc = "";
        if (desc instanceof OrmLocaleValue) {
            ruleDesc = ((OrmLocaleValue)desc).getLocaleValue();
        } else if (desc instanceof String) {
            ruleDesc = (String)desc;
        }
        Long ruleId = (Long)model.getValue("id");
        JSONObject jsonReturnObject = new JSONObject();
        jsonReturnObject.put("rule_desc", (Object)ruleDesc);
        int index = (Integer)this.getView().getFormShowParameter().getCustomParam("selectRowIndex");
        jsonReturnObject.put("selectRowIndex", (Object)index);
        jsonReturnObject.put("rule_id", (Object)ruleId);
        this.getView().returnDataToParent((Object)jsonReturnObject);
        this.getView().close();
    }

    private void callBack4SelectRule(ClosedCallBackEvent e) {
        this.getModel().setDataChanged(false);
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows != null && rows.size() != 0) {
            ListSelectedRow row = rows.get(0);
            Object ruleId = row.getPrimaryKeyValue();
            QFilter filter = new QFilter("id", "=", ruleId);
            String ruleDesc = "";
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_reserve_inv_rule", (QFilter[])filter.toArray());
            if (rule != null) {
                ruleDesc = rule.getString("rule_desc");
            }
            JSONObject jsonReturnObject = new JSONObject();
            int index = (Integer)this.getView().getFormShowParameter().getCustomParam("selectRowIndex");
            jsonReturnObject.put("selectRowIndex", (Object)index);
            jsonReturnObject.put("rule_desc", (Object)ruleDesc);
            jsonReturnObject.put("rule_id", ruleId);
            this.getView().returnDataToParent((Object)jsonReturnObject);
            this.getView().close();
        }
    }

    private void callBack4ReserveBillCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "std_inv_col", "std_inv_col_no", "rule_entry");
    }

    private void callBack4RequireBillCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "require_bill_col", "require_bill_col_no", "rule_entry");
    }

    private void handleValues(JSONArray data, String col, String colNo, String entryField) {
        IDataModel model = this.getModel();
        Set<String> existSortCols = this.getExistCols(col, entryField);
        this.getPageCache().put("key", "value");
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customParam");
        String number = jsonObject.getString("requirebillNumber");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        for (int i = 0; i < data.size(); ++i) {
            Map allEntities;
            EntityType entityType;
            String[] splitIdArr;
            JSONObject info = data.getJSONObject(i);
            if (existSortCols.contains(info.getString("id"))) continue;
            int index = i == 0 ? this.getModel().getEntryCurrentRowIndex(entryField) : model.createNewEntryRow(entryField);
            String text = info.getString("text");
            String id = info.getString("id");
            if ("require_bill_col".equals(col) && (splitIdArr = id.split("\\.")).length > 1 && (entityType = (EntityType)(allEntities = dataEntityType.getAllEntities()).get(splitIdArr[0])) != null) {
                text = entityType.getDisplayName().getLocaleValue() + '.' + text;
            }
            model.setValue(col, (Object)text, index);
            model.setValue(colNo, (Object)info.getString("id"), index);
        }
        this.getPageCache().remove("key");
    }

    private Set<String> getExistCols(String colNo, String entryField) {
        HashSet<String> sortCols = new HashSet<String>();
        DynamicObjectCollection sortList = this.getModel().getEntryEntity(entryField);
        for (DynamicObject row : sortList) {
            sortCols.add(row.getString(colNo));
        }
        return sortCols;
    }

    private void clickRequireBillCol(String key) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("rule_entry");
        String compareType = (String)model.getValue("compare_type", index);
        this.getPageCache().put("selectRowIndex", String.valueOf(index));
        String colName = (String)model.getValue("std_inv_col_no", index);
        String value = (String)model.getValue("require_bill_col_no", index);
        String[] split = value.split(",");
        Object[] strArrNum = (Long[])ConvertUtils.convert((String[])split, Long.class);
        if (StringUtils.isBlank((CharSequence)colName)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u6765\u6e90\u5b57\u6bb5\u3002", (String)"ReserveInvRuleEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        if (COMPARE_TYPE_LIST.contains(compareType)) {
            boolean isMultiSelect = false;
            if ("D".equals(compareType) || "I".equals(compareType)) {
                isMultiSelect = true;
            }
            Map<String, Object> dataProp = this.getBaseEntityId(colName);
            String BaseEntityId = (String)dataProp.get(BASEDATAPROP);
            String textProp = (String)dataProp.get(TEXTPROP);
            List comboItemsList = (List)dataProp.get(COMBOPROP);
            if (StringUtils.isNotEmpty((CharSequence)BaseEntityId)) {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)BaseEntityId, (boolean)isMultiSelect);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseData"));
                listShowParameter.setSelectedRows(strArrNum);
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else if (StringUtils.isNotEmpty((CharSequence)textProp)) {
                this.showParameter(textProp, BOS_MULTITEXT);
            } else if (null != comboItemsList && comboItemsList.size() != 0) {
                List<Map<String, Object>> items = this.getComboItemsList(comboItemsList);
                if (isMultiSelect) {
                    this.showParameter(items, MSCOMMON_COMBOITEMSSELECT);
                } else {
                    this.showParameter(items, IDE_COMBOITEMSSELECT);
                }
            }
        } else {
            JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customParam");
            String number = jsonObject.getString("requirebillNumber");
            this.showColsTreePage(number, key);
        }
    }

    private List<Map<String, Object>> getComboItemsList(List<ValueMapItem> comboItemsList) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(comboItemsList.size());
        for (ValueMapItem valueMapItem : comboItemsList) {
            HashMap<String, String> combItemMap = new HashMap<String, String>(comboItemsList.size());
            String name = valueMapItem.getName().getLocaleValue();
            String value = valueMapItem.getValue();
            combItemMap.put("Name", name);
            combItemMap.put("Value", value);
            items.add(combItemMap);
        }
        return items;
    }

    private void showParameter(Object textProp, String formId) {
        IFormView view = this.getView();
        Object value = this.getModel().getValue("std_inv_col");
        String col = (String)this.getModel().getValue("require_bill_col_no");
        String[] split = col.split(",");
        List<String> sp = Arrays.asList(split);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setCaption(value.toString());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("comboProp", textProp);
        parameter.setCustomParam("params", sp);
        parameter.setFormId(formId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(parameter);
    }

    private void clickReserveBillCol(EventObject evt, String key) {
        this.showColsTreePage("msmod_std_inv_field", key);
    }

    private void clickSortFieldCol(EventObject evt, String key) {
        this.showColsTreePage("msmod_std_inv_field", key);
    }

    private void showColsTreePage(String entityNumber, String key) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        SelectParams params = new SelectParams();
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translateInfo();
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customParam");
        if (jsonObject == null) {
            return;
        }
        String number = jsonObject.getString("requirebillNumber");
        this.getModel().setValue("demandsrcobj", (Object)number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            OrmLocaleValue ruleDesc;
            String localeValue;
            Object ruleDescObj = this.getModel().getValue("rule_desc");
            if (Objects.nonNull(ruleDescObj) && ruleDescObj instanceof OrmLocaleValue && StringUtils.isBlank((CharSequence)(localeValue = (ruleDesc = (OrmLocaleValue)ruleDescObj).getLocaleValue()))) {
                String gLang = ruleDesc.get((Object)"GLang");
                this.getModel().setValue("rule_desc", (Object)gLang);
            }
            FieldFormTranslator translator = FieldFormTranslator.create((IDataModel)this.getModel());
            MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
            translator.entryTranslate("rule_entry", curType, "std_inv_col_no", "std_inv_col");
            translator.headToEntryTranslate("rule_entry", "demandsrcobj", "require_bill_col_no", "require_bill_col");
            translator.entryTranslate("sort_entry", curType, "sort_field_no", "sort_field");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customParam");
        if (jsonObject != null) {
            String number = jsonObject.getString("requirebillNumber");
            this.getModel().setValue("demandsrcobj", (Object)number);
        }
    }

    private Map<String, Object> getBaseEntityId(String sourceField) {
        HashMap<String, Object> fieldTypeMap = new HashMap<String, Object>(8);
        String DataField = "";
        IDataEntityProperty pro = null;
        MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
        if (sourceField.contains(".")) {
            IDataEntityProperty curPro;
            String[] keys = StringUtils.split((String)sourceField, (String)".");
            for (int i = 0; i < keys.length && (pro = (curPro = (IDataEntityProperty)curType.getAllFields().get(keys[i]))) instanceof BasedataProp; ++i) {
                String nextType = ((BasedataProp)curPro).getBaseEntityId();
                if (nextType == null) continue;
                curType = MetadataServiceHelper.getDataEntityType((String)nextType);
            }
        } else {
            pro = (IDataEntityProperty)curType.getAllFields().get(sourceField);
        }
        if (pro instanceof BasedataProp) {
            DataField = this.getMultiCate(sourceField, pro);
            fieldTypeMap.put(BASEDATAPROP, DataField);
        } else if (pro instanceof TextProp) {
            DataField = String.valueOf(pro.getName());
            fieldTypeMap.put(TEXTPROP, DataField);
        } else if (pro instanceof ComboProp) {
            List comboItems = ((ComboProp)pro).getComboItems();
            fieldTypeMap.put(COMBOPROP, comboItems);
        }
        return fieldTypeMap;
    }

    private String getMultiCate(String sourceField, IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            DynamicObjectCollection rule_entry = this.getModel().getEntryEntity("rule_entry");
            String type = sourceField + "_type";
            for (DynamicObject dynamicObject : rule_entry) {
                String typeName = dynamicObject.getString("std_inv_col_no");
                String compertype = dynamicObject.getString("compare_type");
                if (!type.equals(typeName) || !"A".equals(compertype)) continue;
                return dynamicObject.getString("require_bill_col_no");
            }
        }
        return ((BasedataProp)pro).getBaseEntityId();
    }

    private boolean checkIfDateField(String sourceField) {
        boolean dateField = false;
        IDataEntityProperty pro = null;
        MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
        if (sourceField != null && sourceField.contains(".")) {
            IDataEntityProperty curPro;
            String[] keys = StringUtils.split((String)sourceField, (String)".");
            for (int i = 0; i < keys.length && (pro = (curPro = (IDataEntityProperty)curType.getAllFields().get(keys[i]))) instanceof BasedataProp; ++i) {
                String nextType = ((BasedataProp)curPro).getBaseEntityId();
                if (nextType == null) continue;
                curType = MetadataServiceHelper.getDataEntityType((String)nextType);
            }
        } else {
            pro = (IDataEntityProperty)curType.getAllFields().get(sourceField);
        }
        if (pro != null && pro.getPropertyType().getName().contains("Date")) {
            dateField = true;
        }
        return dateField;
    }

    private boolean checkIfBigDecimalField(String sourceField) {
        boolean dateField = false;
        IDataEntityProperty pro = null;
        MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
        if (sourceField != null && sourceField.contains(".")) {
            IDataEntityProperty curPro;
            String[] keys = StringUtils.split((String)sourceField, (String)".");
            for (int i = 0; i < keys.length && (pro = (curPro = (IDataEntityProperty)curType.getAllFields().get(keys[i]))) instanceof BasedataProp; ++i) {
                String nextType = ((BasedataProp)curPro).getBaseEntityId();
                if (nextType == null) continue;
                curType = MetadataServiceHelper.getDataEntityType((String)nextType);
            }
        } else {
            pro = (IDataEntityProperty)curType.getAllFields().get(sourceField);
        }
        if (pro != null && pro.getPropertyType().getName().contains("BigDecimal")) {
            dateField = true;
        }
        return dateField;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"qty"});
        List entities = e.getRows();
        entities.forEach(entry -> this.handleRequireBillEnable(entry.getRowIndex()));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "supsrcobj": {
                this.beforeSupSrcSelset(e);
                break;
            }
        }
    }

    private void beforeSupSrcSelset(BeforeF7SelectEvent e) {
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"msmod_std_inv_field").toArray());
        Set srcIds = fieldMap.values().stream().map(v -> v.get("sourcebill_id")).collect(Collectors.toSet());
        srcIds.remove("msmod_releasebill");
        srcIds.remove("msmod_reserveaggre");
        if (srcIds.isEmpty()) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", srcIds));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                boolean userPlugin = (Boolean)this.getModel().getValue("use_plugin");
                if (!userPlugin) break;
                Object rulePlugin = this.getModel().getValue("rule_plugin");
                if (rulePlugin == null || rulePlugin.toString().trim().length() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u63d2\u4ef6\u6a21\u5f0f\uff0c\u89c4\u5219\u63d2\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveInvRuleEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                }
                RuleResultHandlerFactory.getResultHandlerPlugin(rulePlugin.toString());
                break;
            }
        }
    }

    static {
        COMPARE_TYPE_LIST.add("A");
        COMPARE_TYPE_LIST.add("H");
        COMPARE_TYPE_LIST.add("B");
        COMPARE_TYPE_LIST.add("C");
        COMPARE_TYPE_LIST.add("D");
        COMPARE_TYPE_LIST.add("I");
        COMPARE_TYPEFILED_LIST.add("=");
        COMPARE_TYPEFILED_LIST.add(">");
        COMPARE_TYPEFILED_LIST.add("<");
    }
}

