/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;

public class ReserveRecordFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ReserveRecordFormPlugin.class);
    private String recordSelectSql = null;
    private static final List<String> recordFieldList = Arrays.asList("bill_obj", "bal_obj", "bal_id", "bal_entryid", "bill_no", "bill_id", "billentry_id", "reserve_scheme", "create_date", "reserveprctype", "base_qty", "qty", "qty2nd", "billentry_seq");
    private Set<String> recordFieldSet = new HashSet<String>(recordFieldList);
    private Set<String> billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
    private Set<String> balModelFieldSet = new HashSet<String>(16);
    private static final String SUP_SEQ = "s_entryseq";
    private static final String[] orderBySel = new String[]{"create_date desc", "bill_no desc", "billentry_seq asc "};
    private static final String MPSCMM_APPID = "0ZACM0PE=J24";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey;
        switch (opKey = event.getOperateKey()) {
            case "queryap": {
                this.queryAp();
                break;
            }
            case "release": {
                this.release();
            }
        }
    }

    private void queryAp() {
        this.initSelectInfo();
        List<QFilter> recordFilter = this.getRecordFilter();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ":queryAp";
        DataSet reserveRecord = null;
        try {
            reserveRecord = QueryServiceHelper.queryDataSet((String)algoKey, (String)"msmod_reserve_record", (String)this.recordSelectSql, (QFilter[])recordFilter.toArray(new QFilter[recordFilter.size()]), null);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getCause().getMessage());
            return;
        }
        try {
            HashMap<String, Set<Object>> billIdMap = new HashMap<String, Set<Object>>(16);
            HashMap<String, Set<Object>> balIdMap = new HashMap<String, Set<Object>>(16);
            this.collectBalIdAndBillId(reserveRecord.copy(), billIdMap, balIdMap);
            if (!billIdMap.isEmpty() && !balIdMap.isEmpty()) {
                reserveRecord = this.getBalAndBillData(algoKey, reserveRecord, billIdMap, balIdMap);
            }
            this.write2Model(reserveRecord);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7559\u6620\u5c04\u914d\u7f6e\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u9700\u6c42\u6a21\u578b\u548c\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\u3002", (String)"ReserveRecordFormPlugin_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
    }

    private void collectBalIdAndBillId(DataSet copy, Map<String, Set<Object>> billIdMap, Map<String, Set<Object>> balIdMap) {
        while (copy.hasNext()) {
            Row next = copy.next();
            String billNum = next.getString("bill_obj");
            String balNum = next.getString("bal_obj");
            Set<Object> billIds = billIdMap.get(billNum);
            Set<Object> balIds = balIdMap.get(balNum);
            if (billIds == null) {
                billIds = new HashSet<Object>(16);
                billIdMap.put(billNum, billIds);
            }
            if (balIds == null) {
                balIds = new HashSet<Object>(16);
                balIdMap.put(balNum, balIds);
            }
            billIds.add(next.get("bill_id"));
            balIds.add(next.get("bal_id"));
        }
    }

    private void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveform").getAllFields();
        this.billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
        this.balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                this.billModelFieldSet.add(key);
                continue;
            }
            if (key.startsWith("s_")) {
                this.balModelFieldSet.add(key);
                continue;
            }
            if ("reserveid".equals(key)) continue;
            this.recordFieldSet.add(key);
        }
        this.buildRecordSelectSql();
    }

    private void buildRecordSelectSql() {
        StringBuilder sb = new StringBuilder();
        for (String field : this.recordFieldSet) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(field);
        }
        this.recordSelectSql = sb.append(",id as reserveid").toString();
    }

    private DataSet getBalAndBillData(String algoKey, DataSet reserveRecord, Map<String, Set<Object>> billIdMap, Map<String, Set<Object>> balIdMap) {
        Map<String, String> balSelectMap = this.getSupBillSelectSqlMap(balIdMap.keySet(), this.balModelFieldSet, ReserveHelper.getBalDefaultMap(), "msmod_std_inv_field");
        DataSet balData = ReserveHelper.queryObjData(algoKey, balIdMap, balSelectMap);
        reserveRecord = reserveRecord.join(balData, JoinType.LEFT).on("bal_entryid", "entryid").select(reserveRecord.getRowMeta().getFieldNames(), balData.getRowMeta().getFieldNames()).finish();
        Map<String, String> billSelectMap = this.getBillSelectSqlMap(billIdMap.keySet(), this.billModelFieldSet, ReserveHelper.getBillDefaultMap(), "msmod_std_request_bill");
        DataSet billData = ReserveHelper.queryObjData(algoKey, billIdMap, billSelectMap);
        if (billData == null) {
            return reserveRecord;
        }
        reserveRecord = reserveRecord.join(billData, JoinType.LEFT).on("billentry_id", "bill_entry").select(reserveRecord.getRowMeta().getFieldNames(), billData.getRowMeta().getFieldNames()).finish();
        reserveRecord = reserveRecord.orderBy(orderBySel);
        return reserveRecord;
    }

    private void write2Model(DataSet reserveRecord) {
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.getDataEntity(true);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        while (reserveRecord.hasNext()) {
            Row row = reserveRecord.next();
            for (String billField : this.billModelFieldSet) {
                if ("bill_entry".equals(billField)) continue;
                vs.addField(billField, new Object[]{row.get(billField)});
            }
            for (String recordField : this.recordFieldSet) {
                if ("bal_entryid".equals(recordField)) continue;
                vs.addField(recordField, new Object[]{row.get(recordField)});
            }
            for (String balField : this.balModelFieldSet) {
                if ("id".equals(balField)) continue;
                vs.addField(balField, new Object[]{row.get(balField)});
            }
            vs.addField("reserveid", new Object[]{row.get("reserveid")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Map<String, String> getBillSelectSqlMap(Set<String> billObjs, Set<String> modelFields, Map<String, Object> fieldDefaultMap, String modelFormId) {
        HashMap<String, String> billSelectSqlMap = new HashMap<String, String>(16);
        Map<String, ColsMap> billColMaps = ColsMapHelper.findBillColMaps(billObjs, modelFormId);
        for (Map.Entry<String, ColsMap> entry : billColMaps.entrySet()) {
            String formId = entry.getKey();
            ColsMap colsMap = entry.getValue();
            Map<String, String> balColMap = colsMap.getBalColMap();
            String select = this.getSelectByCol(balColMap, modelFields, fieldDefaultMap);
            billSelectSqlMap.put(formId, select);
        }
        return billSelectSqlMap;
    }

    private Map<String, String> getSupBillSelectSqlMap(Set<String> billObjs, Set<String> modelFields, Map<String, Object> fieldDefaultMap, String modelFormId) {
        Map<String, ColsMap> billColMaps = ColsMapHelper.findBillColMaps(billObjs, modelFormId);
        Map<String, String> sqlKeyMap = this.getEntrySeqMap(billObjs, billColMaps);
        Map<String, String> billSelectSqlMap = this.getBillSelectSqlMap(billObjs, modelFields, fieldDefaultMap, modelFormId);
        for (Map.Entry<String, String> entrySql : billSelectSqlMap.entrySet()) {
            String key = entrySql.getKey();
            StringBuilder sqlSb = new StringBuilder(entrySql.getValue());
            if (sqlKeyMap == null) continue;
            sqlSb.append(sqlKeyMap.get(key));
            entrySql.setValue(sqlSb.toString());
        }
        return billSelectSqlMap;
    }

    private Map<String, String> getEntrySeqMap(Set<String> billObjs, Map<String, ColsMap> billColMaps) {
        HashMap<String, String> sqlKeyMap = new HashMap<String, String>(billColMaps.size());
        Map<String, Boolean> isPredictMap = ReserveHelper.getIsPredictMap(billObjs);
        for (Map.Entry<String, ColsMap> entry : billColMaps.entrySet()) {
            String formId = entry.getKey();
            ColsMap colsMap = entry.getValue();
            Map<String, String> balColMap = colsMap.getBalColMap();
            String materiel = balColMap.get("materiel");
            if (materiel == null) {
                return null;
            }
            String[] materielArray = materiel.split("\\.");
            Boolean isPredict = isPredictMap.get(formId);
            if (isPredict != null && isPredict.booleanValue()) {
                String entryKey = balColMap.get("billentry");
                StringBuilder sb = new StringBuilder();
                if (entryKey != null && materielArray.length > 1) {
                    sb.append(',').append(entryKey).append('.').append("seq").append(" AS ").append(SUP_SEQ).append(',').append(entryKey).append('.').append("id").append(" AS ").append("entryid");
                } else {
                    sb.append(',').append(0).append(" AS ").append(SUP_SEQ).append(',').append(0).append(" AS ").append("entryid");
                }
                sqlKeyMap.put(formId, sb.toString());
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(',').append(0).append(" AS ").append(SUP_SEQ);
            sb.append(',').append("id").append(" AS ").append("entryid");
            sqlKeyMap.put(formId, sb.toString());
        }
        return sqlKeyMap;
    }

    private String getSelectByCol(Map<String, String> colMap, Set<String> modelFields, Map<String, Object> fieldDefaultMap) {
        StringBuilder sb = new StringBuilder();
        for (String modelField : modelFields) {
            String billField;
            if (SUP_SEQ.equals(modelField)) continue;
            String field = modelField;
            if (modelField.startsWith("r_") || modelField.startsWith("s_")) {
                field = modelField.substring(2);
            }
            if (StringUtils.isBlank((CharSequence)(billField = colMap.get(field)))) {
                billField = colMap.get("bill_entry." + field);
            }
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            if (StringUtils.isNotBlank((CharSequence)billField)) {
                if ("bill_entry".equals(modelField)) {
                    billField = billField + ".id";
                }
                sb.append(billField).append(" as ").append(modelField);
                continue;
            }
            sb.append(fieldDefaultMap.get(field)).append(" as ").append(modelField);
        }
        return sb.toString();
    }

    private List<QFilter> getRecordFilter() {
        ArrayList<QFilter> recordFilters = new ArrayList<QFilter>(16);
        String filter = (String)this.getView().getFormShowParameter().getCustomParam("filter");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            recordFilters.add(QFilter.fromSerializedString((String)filter));
        }
        recordFilters.add(new QFilter("base_qty", "<>", (Object)BigDecimal.ZERO).or(new QFilter("qty", "<>", (Object)BigDecimal.ZERO)));
        return recordFilters;
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "bill_no": {
                this.showSrcBill(row);
                break;
            }
            case "s_billnum": {
                this.showSupplyBill(row);
            }
        }
    }

    private void showSrcBill(int row) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        long billId = singleEntry.getLong("bill_id");
        String billTpye = singleEntry.getDynamicObject("bill_obj").getString("id");
        this.showBillEdit(this.getView(), billTpye, billId);
    }

    private void showSupplyBill(int row) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        long billId = singleEntry.getLong("bal_id");
        String billTpye = singleEntry.getDynamicObject("bal_obj").getString("id");
        this.showBillEdit(this.getView(), billTpye, billId);
    }

    private void release() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u89e3\u9664\u3002", (String)"ReserveRecordFormPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> reserveIds = new ArrayList<Object>(rows.length);
        HashMap<Object, OpLogAppInfo> logInfoMap = new HashMap<Object, OpLogAppInfo>(rows.length);
        for (int i : rows) {
            Object reserveId = this.getModel().getValue("reserveid", i);
            reserveIds.add(reserveId);
            logInfoMap.put(reserveId, this.getAppLogInfo(i));
        }
        if (reserveIds.isEmpty()) {
            return;
        }
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"remove", (String)"msmod_reserve_record", (Object[])reserveIds.toArray(new Object[reserveIds.size()]));
        if (executeOperate.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u7559\u8bb0\u5f55\u89e3\u9664\u6210\u529f\u3002", (String)"ReserveRecordFormPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(executeOperate.getMessage() + this.getErroInfo(executeOperate));
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        List successPkIds = executeOperate.getSuccessPkIds();
        for (Object reserveId : successPkIds) {
            logService.addLog((AppLogInfo)logInfoMap.get(reserveId));
        }
        if (!successPkIds.isEmpty()) {
            this.getView().invokeOperation("queryap");
        }
    }

    private OpLogAppInfo getAppLogInfo(int i) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setBizAppID(MPSCMM_APPID);
        logInfo.setBizObjID("msmod_reserveform");
        logInfo.setOpName("release", ResManager.loadKDString((String)"\u9884\u7559\u89e3\u9664", (String)"ReserveRecordFormPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        String billNo = (String)this.getModel().getValue("bill_no", i);
        DynamicObject billObj = (DynamicObject)this.getModel().getValue("bill_obj", i);
        DynamicObject material = (DynamicObject)this.getModel().getValue("s_materiel", i);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue("base_qty", i);
        StringBuilder sb = new StringBuilder();
        if (billObj != null) {
            sb.append(billObj.getString("name"));
        }
        sb.append(billNo);
        if (material != null) {
            sb.append(": ").append(ResManager.loadKDString((String)"\u7269\u6599", (String)"ReserveRecordFormPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0])).append("( ").append(material.getString("number")).append(" , ").append(material.getString("name")).append(" ), ");
        }
        sb.append(ResManager.loadKDString((String)"\u9884\u7559\u57fa\u672c\u6570\u91cf", (String)"ReserveRecordFormPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0])).append(baseQty.stripTrailingZeros().toPlainString()).append(" \uff0c").append(ResManager.loadKDString((String)"\u9884\u7559\u89e3\u9664\u6210\u529f\u3002", (String)"ReserveRecordFormPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        logInfo.setOpDescription(sb.toString());
        return logInfo;
    }

    private void showBillEdit(IFormView view, String entityName, Object pkValue) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(pkValue);
        view.showForm((FormShowParameter)showParameter);
    }

    private String getErroInfo(OperationResult result) {
        StringBuilder sb = new StringBuilder();
        result.getAllErrorOrValidateInfo().forEach(info -> sb.append(info.getMessage()));
        result.getAllErrorInfo().forEach(info -> sb.append(info.getMessage()));
        return sb.toString();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().invokeOperation("queryap");
    }
}

