/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.helper.MetaHelper;
import kd.mpscmm.msbd.reserve.business.strategy.FilterStrategy;
import kd.mpscmm.msbd.reserve.business.strategy.IColsSelectStrategy;
import kd.mpscmm.msbd.reserve.business.strategy.SimpleStrategy;
import kd.mpscmm.msbd.reserve.common.colsAssist.SelectParams;
import kd.mpscmm.msbd.reserve.common.util.ColsTreeUtil;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;

public class ReserveReleaseEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"std_inv_col", "release_col", "sort_field", "releasebillfield"});
        EntryGrid ruleEntryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        ruleEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        EntryGrid sortEntryGrid = (EntryGrid)this.getView().getControl("sort_entry");
        sortEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit datas = (BasedataEdit)this.getControl("release_bill");
        if (datas != null) {
            datas.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("release_bill".equals(fieldKey)) {
            this.requireBillF7Select(beforeF7SelectEvent);
        }
    }

    private void requireBillF7Select(BeforeF7SelectEvent e) {
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"msmod_releasebill").toArray());
        Set srcIds = fieldMap.values().stream().map(v -> v.get("sourcebill_id")).collect(Collectors.toSet());
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", srcIds));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateReleaseFilterCols(false);
        this.initReleaseFilters();
        EntryGrid ruleEntryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        ruleEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        EntryGrid sortEntryGrid = (EntryGrid)this.getView().getControl("sort_entry");
        sortEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    private void updateReleaseFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("bill_filter");
        filterGrid.SetValue(new FilterCondition());
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView("bill_filter");
    }

    private void initReleaseFilters() {
        String reserveFsStr = this.getModel().getDataEntity().getString("filter_value_tag");
        FilterCondition condition = kd.bos.util.StringUtils.isBlank((String)reserveFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)reserveFsStr, FilterCondition.class);
        FilterGrid reserveFilter = (FilterGrid)this.getControl("bill_filter");
        reserveFilter.SetValue(condition);
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("release_bill");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "std_inv_col": 
            case "sort_field": {
                ReserveHelper.showColsTreePage(this.getView(), (IFormPlugin)this, "msmod_std_inv_field", key);
                break;
            }
            case "release_col": {
                MainEntityType mainEntityType = this.getRequireBillMainEntityType();
                if (mainEntityType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91ca\u653e\u5355\u636e\u3002", (String)"ReserveReleaseEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                    break;
                }
                if (mainEntityType.getName() == null) break;
                ReserveHelper.showColsTreePage(this.getView(), (IFormPlugin)this, mainEntityType.getName(), key);
                break;
            }
            case "releasebillfield": {
                MainEntityType mainEntity = this.getRequireBillMainEntityType();
                if (mainEntity == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91ca\u653e\u5355\u636e\u3002", (String)"ReserveReleaseEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                    break;
                }
                if (mainEntity.getName() == null) break;
                Map allFields = mainEntity.getAllFields();
                ArrayList<String> Cols = new ArrayList<String>(16);
                for (Map.Entry entry : allFields.entrySet()) {
                    if (entry.getValue() instanceof BasedataProp) continue;
                    Cols.add((String)entry.getKey());
                }
                Map allEntities = mainEntity.getAllEntities();
                for (Map.Entry entryEntity : allEntities.entrySet()) {
                    EntityType value = (EntityType)entryEntity.getValue();
                    if (!(value instanceof EntryType)) continue;
                    Cols.add((String)entryEntity.getKey());
                }
                this.showColsTreePage(mainEntity.getName(), new FilterStrategy(Cols, true), key, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"plsselectfield_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        this.getView().showForm(fp);
    }

    private void prioritySeqValidate(Object newValue, int index, String filedNum) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            if (i == index) continue;
            int ruleSeq = (Integer)model.getValue("priority", i);
            if ("priority".equals(filedNum) && (Integer)newValue == ruleSeq) {
                model.beginInit();
                model.setValue("priority", (Object)0, index);
                this.getView().updateView("priority", index);
                model.endInit();
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u4f18\u5148\u7ea7\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ReserveReleaseEditPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                break;
            }
            String releaseType = (String)model.getValue("releasetype", i);
            if (!kd.bos.util.StringUtils.isNotEmpty((String)releaseType) || !"releasetype".equals(filedNum) || !releaseType.equals(newValue)) continue;
            model.beginInit();
            model.setValue("releasetype", (Object)"", index);
            this.getView().updateView("releasetype", index);
            model.endInit();
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u9884\u7559\u5bf9\u8c61\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ReserveReleaseEditPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                IDataModel model = this.getModel();
                String requestFilter = this.getFilterGridCondition("bill_filter");
                model.setValue("filter_value_tag", (Object)requestFilter);
                this.checkResObj();
                this.relSpace();
                break;
            }
        }
    }

    private void relSpace() {
        IDataModel model = this.getModel();
        String currentValue = (String)model.getValue("number");
        if (currentValue != null) {
            currentValue = currentValue.replaceAll("\u3000", " ").trim();
            model.beginInit();
            model.setValue("number", (Object)currentValue);
            model.endInit();
        }
    }

    private void checkResObj() {
        DynamicObjectCollection objMatDyna = this.getModel().getEntryEntity("objresentity");
        DynamicObjectCollection objRelease = this.getModel().getEntryEntity("entryentity");
        if (objMatDyna.size() != 0) {
            Object o = ((DynamicObject)objMatDyna.get(objMatDyna.size() - 1)).get("objreleasetype");
            if (o == null) {
                this.getModel().deleteEntryRow("objresentity", objMatDyna.size() - 1);
                this.getView().updateView("objresentity");
            }
            if (objMatDyna.size() > 1 && objRelease.size() == 0 && o != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8c61\u9884\u7559\u5339\u914d\u5b58\u5728\u591a\u4e2a\u9884\u7559\u5bf9\u8c61\uff0c\u8bf7\u7ef4\u62a4\u5bf9\u8c61\u9884\u7559\u91ca\u653e\u987a\u5e8f\u3002", (String)"ReserveReleaseEditPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        }
    }

    private String getFilterGridCondition(String filterName) {
        FilterGrid grid = (FilterGrid)this.getControl(filterName);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        switch (key = e.getActionId()) {
            case "std_inv_col": {
                this.handleF7CallBackValue(data, "std_inv_col", "std_inv_col_no", "rule_entry");
                break;
            }
            case "sort_field": {
                this.handleF7CallBackValue(data, "sort_field", "sort_field_no", "sort_entry");
                break;
            }
            case "release_col": {
                this.handleF7CallBackValue(data, "release_col", "release_col_no", "rule_entry");
                break;
            }
            case "releasebillfield": {
                this.handleF7CallBackValue(data, "releasebillfield", "releasebillfield_no", "objresentity");
                break;
            }
        }
    }

    private void handleF7CallBackValue(JSONArray data, String col, String colNo, String entryField) {
        IDataModel model = this.getModel();
        JSONObject info = data.getJSONObject(0);
        Set<String> existSortCols = this.getExistCols(colNo, entryField);
        if (existSortCols.contains(info.getString("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\u3002", (String)"ReserveReleaseEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        } else {
            model.setValue(col, (Object)info.getString("text"));
            model.setValue(colNo, (Object)info.getString("id"));
        }
    }

    private Set<String> getExistCols(String colNo, String entryField) {
        HashSet<String> sortCols = new HashSet<String>();
        DynamicObjectCollection sortList = this.getModel().getEntryEntity(entryField);
        for (DynamicObject row : sortList) {
            sortCols.add(row.getString(colNo));
        }
        return sortCols;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int index = valueSet[0].getRowIndex();
        switch (key) {
            case "release_bill": {
                this.dealReleaseBillChange(valueSet[0]);
                break;
            }
            case "std_inv_col": {
                this.clearRelaseBillMark(valueSet[0], "std_inv_col");
                break;
            }
            case "release_col": {
                this.clearRelaseBillMark(valueSet[0], "release_col");
                break;
            }
            case "priority": {
                this.prioritySeqValidate(newValue, index, "priority");
                break;
            }
            case "releasetype": {
                this.prioritySeqValidate(newValue, index, "releasetype");
                break;
            }
        }
    }

    private void clearRelaseBillMark(ChangeData changeData, String stdInvColOrRelease) {
        Object newValue = changeData.getNewValue();
        if ("std_inv_col".equals(stdInvColOrRelease)) {
            if (newValue == null || "".equals(newValue)) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.setValue("std_inv_col_no", null);
                model.endInit();
                this.getView().updateView("rule_entry");
            }
        } else if ("release_col".equals(stdInvColOrRelease) && (newValue == null || "".equals(newValue))) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("release_col_no", null);
            model.endInit();
            this.getView().updateView("rule_entry");
        }
    }

    private void dealReleaseBillChange(ChangeData changeData) {
        this.updateReleaseFilterCols(true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection ruleEntity = this.getModel().getEntryEntity("rule_entry");
        for (Object ruleDynamic : ruleEntity) {
            ruleDynamic.set("release_col", null);
            ruleDynamic.set("release_col_no", null);
        }
        DynamicObjectCollection objresEntity = this.getModel().getEntryEntity("objresentity");
        for (DynamicObject entity : objresEntity) {
            entity.set("releasebillfield", null);
            entity.set("releasebillfield_no", null);
            entity.set("objreleasetype", null);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entity : entryEntity) {
            entity.set("releasetype", null);
            entity.set("priority", null);
        }
        model.endInit();
        this.getView().updateView("rule_entry");
        this.getView().updateView("objresentity");
        this.getView().updateView("entryentity");
    }
}

