/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReserveSchemeOrgPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ReserveSchemeOrgPlugin.class);
    public static final String RESERVE_SCHEME_ID = "reserveschemeid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnsave"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "btnaddline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgf7();
            }
        }
    }

    private void refreshOrgf7() {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentity");
        HashSet<String> ids = new HashSet<String>();
        for (DynamicObject obj : curOrgList) {
            ids.add(String.valueOf(obj.getDynamicObject("orgid").getPkValue()));
        }
        Set orgs = ids.stream().map(Long::valueOf).collect(Collectors.toSet());
        this.getModel().setValue("orgf7", (Object)orgs.toArray());
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.getControl("orgf7");
        base.setOrgFuncId(this.getOrgFuncId(this.getModel().getValue("bizobjectid")));
        base.click();
    }

    private String getOrgFuncId(Object bizObject) {
        if (StringUtils.isBlank((Object)bizObject)) {
            return "15";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return "15";
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return "15";
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return "15";
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? "15" : orgfuncid;
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                Object reserveSchemeId = this.getView().getFormShowParameter().getCustomParam(RESERVE_SCHEME_ID);
                this.deleteEntry(reserveSchemeId);
                this.saveData();
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        Object schemeId = this.getView().getFormShowParameter().getCustomParam(RESERVE_SCHEME_ID);
        QFilter schemeFilter = new QFilter("id", "=", schemeId);
        QFilter[] filters = new QFilter[]{schemeFilter};
        DynamicObjectCollection coderuleOrgEntry = QueryServiceHelper.query((String)"msmod_reserve_scheme", (String)"id,orgentry.orgid orgid,orgentry.isincludesuborg isincludesuborg,orgentry.orgid.number number,orgentry.orgid.name name", (QFilter[])filters);
        HashSet<String> orgSet = new HashSet<String>();
        if (coderuleOrgEntry != null && coderuleOrgEntry.size() > 0) {
            for (int i = 0; i < coderuleOrgEntry.size(); ++i) {
                DynamicObject orgObj = (DynamicObject)coderuleOrgEntry.get(i);
                String orgid = orgObj.getString("orgid");
                if (StringUtils.isBlank((Object)orgObj.get("number"))) break;
                model.createNewEntryRow("orgentity");
                model.setValue("orgid", orgObj.get("orgid"), i);
                model.setValue("isincludesuborg", orgObj.get("isincludesuborg"), i);
                orgSet.add(orgid);
            }
        }
        Set orgs = orgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
        this.getModel().setValue("orgf7", (Object)orgs.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("orgf7".equals(proName)) {
            this.refreshOrgEntity(e);
        }
    }

    private void refreshOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentity");
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>();
        for (DynamicObject curOrgObj : curOrgList) {
            DynamicObject org = curOrgObj.getDynamicObject("orgid");
            if (org == null) continue;
            subOrgMap.put(org.getLong("id"), curOrgObj.get("isincludesuborg"));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        if (orgCol.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("orgentity", orgCol.size());
        int m = orgCol.size();
        for (int i = 0; i < m; ++i) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(i);
            DynamicObject org = orgObj.getDynamicObject("fbasedataId");
            if (org == null) continue;
            this.getModel().setValue("orgid", (Object)org, i);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong("id"));
            if (isIncludeSubOrg == null) continue;
            this.getModel().setValue("isincludesuborg", isIncludeSubOrg, i);
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        Object codeRuleId = this.getView().getFormShowParameter().getCustomParam(RESERVE_SCHEME_ID);
        DynamicObject scheme = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_scheme");
        scheme.set("id", codeRuleId);
        DynamicObjectCollection list = model.getEntryEntity("orgentity");
        DynamicObject[] orgArr = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject coderuleOrg = BusinessDataServiceHelper.newDynamicObject((String)"msmod_scheme_orgentity");
            coderuleOrg.set("id", (Object)scheme);
            coderuleOrg.set("orgid", model.getValue("orgid", i));
            coderuleOrg.set("isincludesuborg", model.getValue("isincludesuborg", i));
            coderuleOrg.set("seq", (Object)i);
            orgArr[i] = coderuleOrg;
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        this.writeOpLog(codeRuleId);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            parentView = this.getView();
        }
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReserveSchemeOrgPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
    }

    private void writeOpLog(Object codeRuleId) {
        QFilter qFilter = new QFilter("id", "=", codeRuleId);
        DynamicObject schemeDy = QueryServiceHelper.queryOne((String)"msmod_reserve_scheme", (String)"id,number", (QFilter[])qFilter.toArray());
        String schemeNumber = "";
        if (schemeDy != null) {
            schemeNumber = schemeDy.getString("number");
        }
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ReserveSchemeOrgPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
        String opDescription = ResManager.loadKDString((String)"\u9884\u7559\u65b9\u6848\u201c{0}\u201d\u7684\u9002\u7528\u7ec4\u7ec7\uff0c\u4fdd\u5b58\u6210\u529f\u3002", (String)"MSCOMMON-D-777287", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{schemeNumber});
        LogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)opDescription);
    }

    private void deleteEntry(Object id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":Fid", 1, id)};
                String SQL = "delete from t_msmod_schorg where Fid = ?;";
                DB.execute((DBRoute)new DBRoute("scm"), (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    private void clearAllEntryRow() {
        IDataModel model = this.getModel();
        model.deleteEntryData("orgentity");
    }
}

