/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.form.ReserveStrategyEditPlugin;
import org.apache.commons.lang3.StringUtils;

public class ReserveServiceConfigEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(ReserveStrategyEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("bill_filter");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("billobject");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"billobject"});
    }

    private void syncEntryRows() {
        IDataModel model = this.getModel();
        DynamicObject entity = this.getModel().getDataEntity(true);
        String opValue = (String)model.getValue("billoperation");
        if (kd.bos.util.StringUtils.isEmpty((String)opValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveServiceConfigEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        String[] opValues = opValue.split(",");
        ArrayList<String> opValList = new ArrayList<String>(opValue.length());
        for (String value : opValues) {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)value)) continue;
            opValList.add(value);
        }
        DynamicObjectCollection entryRows = entity.getDynamicObjectCollection("entryentity");
        for (int i = entryRows.size() - 1; i >= 0; --i) {
            String opKey = ((DynamicObject)entryRows.get(i)).getString("operation");
            if (opValList.remove(opKey)) continue;
            entryRows.remove(i);
        }
        if (!opValList.isEmpty()) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
            for (String opKey : opValList) {
                DynamicObject entryRow = new DynamicObject((DynamicObjectType)entryType);
                entryRow.set("operation", (Object)opKey);
                entryRows.add((Object)entryRow);
            }
        }
        this.getView().updateView("entryentity");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setVisibleAboutType();
        this.updateRequestFilterCols(false);
        this.updateBillOp();
        this.initRequestFilters();
        Object transType = this.getModel().getValue("transfertype");
        if (!"4".equals(transType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recordid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryid"});
        }
    }

    protected void setFilterGrid(String gridKey, FilterCondition condition) {
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridKey);
        reserveFilter.SetValue(condition);
    }

    private void initRequestFilters() {
        String reserveFsStr = this.getModel().getDataEntity().getString("filter_value_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)reserveFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)reserveFsStr, FilterCondition.class);
        this.setFilterGrid("bill_filter", condition);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave();
                this.syncEntryRows();
                this.transType();
                break;
            }
        }
    }

    private void transType() {
        String trantype = (String)this.getModel().getValue("transfertype");
        DynamicObject value = (DynamicObject)this.getModel().getValue("group");
        if (kd.bos.util.StringUtils.isEmpty((String)trantype) && value != null && ("ReserveReplace".equals(value.getString("number")) || "UnReserveTransfer".equals(value.getString("number")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u7559\u8f6c\u79fb\u670d\u52a1\uff0c\u8bf7\u9009\u62e9\u8f6c\u79fb\u7c7b\u578b\u3002", (String)"ReserveServiceConfigEditPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filter_value_tag", (Object)requestFilter);
        this.getView().updateView("filter_value");
    }

    private String getRequestFilterStr() {
        return this.getFilterGridCondition("bill_filter");
    }

    private String getFilterGridCondition(String filterName) {
        FilterGrid grid = (FilterGrid)this.getControl(filterName);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    private void updateRequestFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("bill_filter");
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView("bill_filter");
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("billobject");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (key) {
            case "billobject": {
                this.updateRequestFilterCols(true);
                this.clearBillOp(newValue, oldValue);
                this.updateBillOp();
                break;
            }
            case "group": {
                this.setVisibleAboutType();
                IDataModel model = this.getModel();
                if (newValue != null && newValue.equals(oldValue)) break;
                model.setValue("transfertype", null);
                this.getView().updateView("transfertype");
                break;
            }
            case "transfertype": {
                if (!"4".equals(newValue)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{"recordid"});
                this.getView().updateView("recordid");
                this.getView().setVisible(Boolean.TRUE, new String[]{"entryid"});
                this.getView().updateView("entryid");
                break;
            }
        }
    }

    private void setVisibleAboutType() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("group");
        if (value != null && ("ReserveReplace".equals(value.getString("number")) || "UnReserveTransfer".equals(value.getString("number")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"transfertype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"transfertype"});
        }
        this.getView().updateView("transfertype");
    }

    private void clearBillOp(Object newValue, Object oldValue) {
        IDataModel model = this.getModel();
        if (newValue == null || !newValue.equals(oldValue)) {
            model.setValue("billoperation", null);
            ComboEdit comboEdit = (ComboEdit)this.getControl("billoperation");
            comboEdit.setComboItems(null);
        }
    }

    private void updateBillOp() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue("billobject");
        if (objectType != null) {
            String str = (String)objectType.getPkValue();
            List ops = EntityMetadataCache.getDataEntityOperate((String)str);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            for (Map op : ops) {
                String opTypeId = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
                String opKey = (String)op.get("key");
                Map mapLocaleString = (Map)op.get("name");
                String opName = opKey;
                if (mapLocaleString != null) {
                    opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
                }
                ComboItem comboItem = new ComboItem(new LocaleString(opName), opKey);
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("billoperation");
            comboEdit.setComboItems(comboItems);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }

    public void afterBindData(EventObject e) {
        this.setServiceNameDisable();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.setServiceNameDisable();
    }

    private void setServiceNameDisable() {
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"group"});
        }
    }
}

