/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReleaseHelper;
import kd.mpscmm.msbd.reserve.business.RequestBillHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.ReserveServiceCfgFilterHelper;
import kd.mpscmm.msbd.reserve.business.check.NegativeChecker;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.decision.DecisionTreeHelper;
import kd.mpscmm.msbd.reserve.business.decision.Node;
import kd.mpscmm.msbd.reserve.business.decision.NodeResultHelper;
import kd.mpscmm.msbd.reserve.business.decision.SolutionFinder;
import kd.mpscmm.msbd.reserve.business.decision.TreeFactory;
import kd.mpscmm.msbd.reserve.business.decision.evaluator.SolutionFinderFactory;
import kd.mpscmm.msbd.reserve.business.helper.AutoTaskHelper;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveLogHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveOpLogHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveReplaceHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;
import kd.mpscmm.msbd.reserve.business.record.ReleaseRecordHelper;
import kd.mpscmm.msbd.reserve.business.record.ReserveRecordHelper;
import kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceService;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;
import kd.mpscmm.msbd.reserve.common.util.ErrorInfoUtils;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;
import kd.mpscmm.msbd.reserve.mservice.InventorySearchResult;
import org.apache.commons.lang3.StringUtils;

public class ReserveService {
    private static final Log logger = LogFactory.getLog(ReserveService.class);
    private static final String RESBILLNUMBER = "bill_id";
    private static final String SUPBILLNUMBER = "bal_id";
    private static final String OBJBILLNUMBER = "reserveobj";
    private static final List<String> billNumberList = new ArrayList<String>(Arrays.asList("bill_id", "bal_id", "reserveobj"));
    private static final DBRoute scmRoute = new DBRoute("scm");

    public static BillReserveResult reserveByBill(DynamicObject originalRequestBill) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveByBill");){
            BillReserveResult result;
            logger.info("Reverse: " + originalRequestBill.getDynamicObjectType().getName() + ", id: " + originalRequestBill.getPkValue());
            if (logger.isDebugEnabled()) {
                logger.debug(originalRequestBill.toString());
            }
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ThreadCache.put((Object)"ReserveOpType", (Object)"autoreserve");
            BillReserveResult billReserveResult = result = ReserveHelper.reserveOneBill(originalRequestBill);
            return billReserveResult;
        }
    }

    public static String reserveByBills(List<DynamicObject> originalRequestBillList) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveByBills");){
            ArrayList resultList = new ArrayList(originalRequestBillList.size());
            originalRequestBillList.forEach(originalRequestBill -> resultList.add(ReserveService.reserveByBill(originalRequestBill)));
            String string = JSON.toJSONString(resultList);
            return string;
        }
    }

    public static void createReserveRecord(Collection<DynamicObject> records) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"createReserveRecord");){
            ReserveRecordHandler.createReserveRecord(records);
        }
    }

    public static void reserveReleaseQty(List<DynamicObject> releaseDatas) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveReleaseQty");){
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ThreadCache.put((Object)"ReserveOpType", (Object)"release2");
            ReserveRecordHandler.reserveReleaseQty(releaseDatas);
        }
    }

    public static void reserveReleaseBatch(Collection<Map<String, Object>> params) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveBatch");){
            ReserveService.reserveReleaseQty(RequestBillHelper.getDynamic4Map(params, "msmod_release_record", null));
        }
    }

    public static void unDoReserveReleaseBatch(Collection<Map<String, Object>> params) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"unDoReserveReleaseBatch");){
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ThreadCache.put((Object)"ReserveOpType", (Object)"unrelease2");
            ReserveRecordHandler.unDoReserveReleaseQty(RequestBillHelper.getDynamic4Map(params, "msmod_release_record", null), true);
        }
    }

    public static void reserveRemove(Object billId, Object billEntryId) {
        if (ThreadCache.get((Object)"ReserveOpName") == null) {
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"delete");
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveRemove");){
            logger.info("\u9884\u7559\u89e3\u9664\uff1a billId=" + billId + ", billEntryId=" + billEntryId);
            try (TXHandle tx = TX.requiresNew((String)"reserveRemove");){
                ReserveRecordHandler.reserveRemoveByBillId(billId, billEntryId, "", false);
            }
        }
    }

    public static BillReserveResult reserve(DynamicObject stdRequestBill) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserve");){
            DynamicObject savedBIll;
            QFilter billNoFilter = new QFilter("bill_no", "=", stdRequestBill.get("bill_no"));
            QFilter billIdFilter = new QFilter(RESBILLNUMBER, "=", stdRequestBill.get(RESBILLNUMBER));
            if (stdRequestBill.getPkValue() == null || (Long)stdRequestBill.getPkValue() == 0L) {
                DeleteServiceHelper.delete((String)"msmod_std_request_bill", (QFilter[])billNoFilter.or(billIdFilter).toArray());
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("key", "ReserveService.reserve");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"msmod_std_request_bill", (DynamicObject[])new DynamicObject[]{stdRequestBill}, (OperateOption)operateOption);
                if (!saveResult.isSuccess()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u6807\u51c6\u9700\u6c42\u5355\u5931\u8d25: %1$s", (String)"ReserveService_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), ErrorInfoUtils.getErrorInfo(saveResult)));
                }
            }
            if ((savedBIll = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_std_request_bill", (QFilter[])billNoFilter.or(billIdFilter).toArray())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6807\u51c6\u9700\u6c42\u5355\u5931\u8d25\u3002", (String)"ReserveService_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
            ReserveService.subtractReserved(savedBIll);
            BillReserveResult result = ReserveHelper.reserveBill(savedBIll);
            if (!stdRequestBill.getBoolean("auto_reserve")) {
                DeleteServiceHelper.delete((String)"msmod_std_request_bill", (QFilter[])billNoFilter.or(billIdFilter).toArray());
            }
            BillReserveResult billReserveResult = result;
            return billReserveResult;
        }
    }

    public static BillReserveResult reserveWithWarehouseList(DynamicObject stdRequestBill, List<Object> warehouseList, String property) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveWithWarehouseList");){
            ReserveContext context = new ReserveContext(stdRequestBill, ReserveAggregateHelper.getAggregateConfig());
            HashMap<Object, Object> args = new HashMap<Object, Object>(4);
            args.put("request_bill", stdRequestBill);
            args.put("warehouse_list", warehouseList);
            args.put("compare_property", property);
            args.put("context", context);
            TreeFactory treeFactory = DecisionTreeHelper.getTreeFactoryWithScheme(context.getScheme());
            Node root = treeFactory.newTree(args);
            HashMap<Object, Object> solutionFinderArgs = new HashMap<Object, Object>(2);
            solutionFinderArgs.put("scheme", context.getScheme());
            SolutionFinder finder = SolutionFinderFactory.getBestSolutionFinder(solutionFinderArgs);
            Node bestSolutionNode = finder.find(root, args);
            BillReserveResult result = NodeResultHelper.getResult(bestSolutionNode);
            ReserveHelper.validateBillResult(result);
            ReserveHelper.handleBillResult(result, context);
            logger.info("\u9884\u7559\u7ed3\u679c\uff1a " + JSON.toJSONString((Object)result));
            BillReserveResult billReserveResult = result;
            return billReserveResult;
        }
    }

    public static List<BillReserveResult> reserveBills(Collection<DynamicObject> requestBills) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveBills");){
            logger.info("\u8c03\u7528reserveBills: " + requestBills.size());
            ArrayList<BillReserveResult> result = new ArrayList<BillReserveResult>(requestBills.size());
            for (DynamicObject bill : requestBills) {
                result.add(ReserveService.reserve(bill));
            }
            ArrayList<BillReserveResult> arrayList = result;
            return arrayList;
        }
    }

    public static String reserveBatch(Collection<Map<String, Object>> params) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveBatch");){
            List<DynamicObject> requestBills = RequestBillHelper.getDynamic4Map(params, "msmod_std_request_bill", "bill_entry");
            String string = SerializationUtils.toJsonString(ReserveService.reserveBills(requestBills));
            return string;
        }
    }

    public static void subtractReserved(DynamicObject stdRequestBill) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"subtractReserved");){
            DynamicObjectCollection requestEntryList = stdRequestBill.getDynamicObjectCollection("bill_entry");
            Object billId = RequestBillHelper.getBillId(stdRequestBill);
            for (int i = 0; i < requestEntryList.size(); ++i) {
                DynamicObject entry = (DynamicObject)requestEntryList.get(i);
                Object billEntryId = RequestBillHelper.getEntryId(stdRequestBill, entry);
                DynamicObjectCollection recordList = ReserveRecordHandler.getReserveData(billId, billEntryId);
                if (recordList == null) continue;
                ReserveService.setEntryQtyField(entry, recordList);
            }
        }
    }

    private static void setEntryQtyField(DynamicObject entry, DynamicObjectCollection recordList) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"setEntryQtyField");){
            BigDecimal baseQty = (BigDecimal)entry.get("base_qty");
            BigDecimal qty = (BigDecimal)entry.get("qty");
            BigDecimal qty2nd = (BigDecimal)entry.get("aux_qty");
            Map<String, BigDecimal> summaryQtyMap = ReserveService.getSummaryQtyMap(recordList);
            BigDecimal summaryBaseQty = summaryQtyMap.get("summaryBaseQty");
            BigDecimal summaryQty = summaryQtyMap.get("summaryQty");
            BigDecimal summaryQty2nd = summaryQtyMap.get("summaryQty2nd");
            if (summaryBaseQty.compareTo(baseQty) > 0 || summaryQty.compareTo(qty) > 0 || summaryQty2nd.compareTo(qty2nd) > 0) {
                String msg = ResUtil.formatMsg(ResManager.loadKDString((String)"\u8d85\u989d\u9884\u7559", (String)"ReserveRecordHandler_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_5", new Object[0]);
                throw new KDBizException(msg);
            }
            BigDecimal avaBaseQty = baseQty.subtract(summaryBaseQty);
            BigDecimal avaQty = baseQty.subtract(summaryQty);
            BigDecimal avaQty2nd = baseQty.subtract(avaBaseQty);
            entry.set("base_qty", (Object)avaBaseQty);
            entry.set("qty", (Object)avaQty);
            entry.set("aux_qty", (Object)avaQty2nd);
        }
    }

    private static Map<String, BigDecimal> getSummaryQtyMap(DynamicObjectCollection recordList) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"getSummaryQtyMap");){
            HashMap<String, BigDecimal> summaryQtyMap = new HashMap<String, BigDecimal>(3);
            BigDecimal summaryBaseQty = BigDecimal.ZERO;
            BigDecimal summaryQty = BigDecimal.ZERO;
            BigDecimal summaryQty2nd = BigDecimal.ZERO;
            for (DynamicObject record : recordList) {
                BigDecimal baseQty = record.getBigDecimal("base_qty");
                BigDecimal qty = record.getBigDecimal("qty");
                BigDecimal qty2nd = record.getBigDecimal("qty2nd");
                summaryBaseQty = summaryBaseQty.add(baseQty);
                summaryQty = summaryQty.add(qty);
                summaryQty2nd = summaryQty2nd.add(qty2nd);
            }
            summaryQtyMap.put("summaryBaseQty", summaryBaseQty);
            summaryQtyMap.put("summaryQty", summaryQty);
            summaryQtyMap.put("summaryQty2nd", summaryQty2nd);
            HashMap<String, BigDecimal> hashMap = summaryQtyMap;
            return hashMap;
        }
    }

    public static OperationResult doAuditReleaseReserve(String billName, String ids) {
        String releaseReserved = "ReleaseReserved";
        return ReleaseHelper.reserveReleaseByBill(billName, ids, null, releaseReserved, null, false, null);
    }

    public static OperationResult doAuditReleaseReserveOp(String billName, String ids, String opName) {
        String releaseReserved = "ReleaseReserved";
        return ReleaseHelper.reserveReleaseByBill(billName, ids, null, releaseReserved, opName, false, null);
    }

    public static OperationResult releaseReserve(String billName, String ids, String entryIds) {
        String releaseReserved = "ReleaseReserved";
        if (ThreadCache.get((Object)"ReserveOpName") == null) {
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
        }
        return ReleaseHelper.reserveReleaseByBill(billName, ids, null, releaseReserved, null, true, entryIds);
    }

    public static OperationResult terminalReleaseReserve(String billName, List<Object> ids, String opName) {
        OperationResult result = new OperationResult();
        String tmlReleaseReserve = "TmlReleaseReserve";
        if (opName != null) {
            ids = ReserveServiceCfgFilterHelper.canReserveBillIds(tmlReleaseReserve, ids.toArray(new Long[0]), billName, opName);
        }
        if (ids.size() == 0) {
            return result;
        }
        try (TXHandle tx = TX.requiresNew((String)"terminalReleaseReserve");){
            try {
                HashSet<Object> idSet = new HashSet<Object>(ids.size());
                idSet.addAll(ids);
                QFilter qFilter = new QFilter("bill_obj", "=", (Object)billName).and(new QFilter(RESBILLNUMBER, "in", (Object)idSet.toArray())).and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
                QFilter qFilterSup = new QFilter("bal_obj", "=", (Object)billName).and(new QFilter(SUPBILLNUMBER, "in", (Object)idSet.toArray())).and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
                QFilter qFilters = qFilter.or(qFilterSup);
                DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)"ReserveService:doReleaseReserve4Close", (String)"msmod_reserve_record", (String)"id,bill_id,bill_obj,billentry_id,base_qty,qty,qty2nd,billentry_seq,bal_obj,bal_id,bill_no,aggregateid", (QFilter[])qFilters.toArray(), null);
                ReserveService.releaseRecordByFilter(opName, reserveRecord);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(e.getMessage());
            }
        }
        return result;
    }

    private static void releaseRecordByFilter(String opName, DataSet reserveRecord) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(16);
        while (reserveRecord.hasNext()) {
            Row next = reserveRecord.next();
            DynamicObject obj = (DynamicObject)dt.createInstance();
            obj.set("reserve_record", next.get("id"));
            obj.set("bill_obj", next.get("bill_obj"));
            obj.set("entryid", next.get("billentry_id"));
            obj.set("billid", next.get(RESBILLNUMBER));
            obj.set("billno", next.get("bill_no"));
            obj.set("balid", next.get(SUPBILLNUMBER));
            obj.set("balobj", next.get("bal_obj"));
            obj.set("base_qty", next.get("base_qty"));
            obj.set("qty", next.get("qty"));
            obj.set("qty2nd", next.get("qty2nd"));
            obj.set("op", (Object)opName);
            obj.set("release_type", (Object)"endrelease");
            obj.set("aggregateid", (Object)next.getLong("aggregateid"));
            releaseList.add(obj);
        }
        if (ThreadCache.get((Object)"ReserveOpName") == null && opName != null) {
            ThreadCache.put((Object)"ReserveOpName", (Object)opName);
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"terminalrelease");
        ReserveRecordHandler.reserveReleaseQty(releaseList);
    }

    public static OperationResult UnAuditUnReleaseReserve(String billName, String ids, boolean checkNegative, String opName) {
        return ReserveService.unReleaseReServe(billName, ids, checkNegative, opName, false);
    }

    public static OperationResult unReleaseReServeForRollback(String billName, String ids, boolean checkNegative, String opName) {
        return ReserveService.unReleaseReServe(billName, ids, checkNegative, opName, true);
    }

    private static OperationResult unReleaseReServe(String billName, String ids, boolean checkNegative, String opName, boolean isRollBack) {
        OperationResult result;
        block22: {
            List<Object> idArrList;
            Throwable throwable;
            TXHandle tx;
            block19: {
                OperationResult operationResult;
                block20: {
                    block21: {
                        result = new OperationResult();
                        String unReleaseReserved = "TmlUnReleaseReserve";
                        if (ThreadCache.get((Object)"ReserveOpName") == null) {
                            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
                        }
                        tx = TX.requiresNew((String)"MpsReserveService-TmlUnReleaseReserve");
                        throwable = null;
                        Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                        idArrList = Arrays.asList(idArr);
                        if (opName == null || (idArrList = ReserveServiceCfgFilterHelper.canReserveBillIds(unReleaseReserved, idArr, billName, opName)).size() != 0) break block19;
                        operationResult = result;
                        if (tx == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    tx.close();
                }
                return operationResult;
            }
            try {
                try {
                    if (isRollBack) {
                        ReserveRecordHandler.unReleaseReserveQty(ReserveService.matchUnReleaseRecord2(idArrList), checkNegative, true);
                        break block22;
                    }
                    ReserveRecordHandler.unReleaseReserveQty(ReserveService.matchUnReleaseRecord(idArrList, billName), checkNegative, false);
                }
                catch (Exception e) {
                    tx.markRollback();
                    result.setSuccess(false);
                    result.setMessage(ReserveService.getMsgReserveServiceReverseFailOp() + e.getMessage());
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        return result;
    }

    public static OperationResult unReleaseReserve(String billName, String ids, String opName) {
        ThreadCache.put((Object)"ReserveOpType", (Object)"unrelease");
        OperationResult result = new OperationResult();
        String unReleaseReserved = "UnReleaseReserved";
        try (TXHandle tx = TX.requiresNew((String)"MpsReserveService-unReleaseReserve");){
            Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
            List<Object> idArrList = Arrays.asList(idArr);
            if (opName != null && (idArrList = ReserveServiceCfgFilterHelper.canReserveBillIds(unReleaseReserved, idArr, billName, opName)).size() == 0) {
                OperationResult operationResult = result;
                return operationResult;
            }
            try {
                ReserveRecordHandler.unReleaseReserveQty(ReserveService.matchUnReleaseRecord(idArrList, billName), false, false);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(ReserveService.getMsgReserveServiceReverseFailOp() + e.getMessage());
                throw new KDBizException(ReserveService.getMsgReserveServiceReverseFailOp() + e.getMessage());
            }
        }
        return result;
    }

    public static OperationResult UnAuditUnReleaseReserve(String billName, String ids) {
        return ReserveService.UnAuditUnReleaseReserve(billName, ids, true, null);
    }

    public static List<DynamicObject> matchUnReleaseRecord(List<Object> idArrList, String billName) {
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(idArrList.size());
        QFilter qFilter = new QFilter("billid", "in", idArrList);
        qFilter = qFilter.and("deletestatus", "!=", (Object)"1");
        DynamicObject[] releaseRecordList = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"reserve_record,bill_obj,billid,entryid,base_qty,qty,qty2nd,op,release_type,creater,create_date,deletestatus,billno,balobj,balid,aggregateid", (QFilter[])qFilter.toArray());
        releaseList.addAll(Arrays.asList(releaseRecordList));
        return releaseList;
    }

    private static List<DynamicObject> matchUnReleaseRecord2(List<Object> idArrList) {
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(idArrList.size());
        QFilter qFilter = new QFilter("billid", "in", idArrList);
        qFilter = qFilter.and("deletestatus", "!=", (Object)"1");
        qFilter = qFilter.and("release_type", "=", (Object)"endrelease");
        DynamicObject[] releaseRecordList = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"reserve_record,bill_obj,billid,entryid,base_qty,qty,qty2nd,op,release_type,creater,create_date,deletestatus,billno,balobj,balid,aggregateid", (QFilter[])qFilter.toArray());
        releaseList.addAll(Arrays.asList(releaseRecordList));
        return releaseList;
    }

    public static void unAutoReserve(String billName, List<Object> ids, String opName) {
        try (TXHandle tx = TX.requiresNew((String)"ReserveService-unAutoReserve");){
            try {
                ReserveService.delReserveRecord(billName, ids, opName);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
            }
        }
    }

    public static void unAutoReserve(Long recordId, String billName, List<Object> ids, String opName) {
        try (TXHandle tx = TX.requiresNew((String)"ReserveService-unAutoReserve");){
            try {
                ReserveLogHelper.writeCollectInfo(ids.size(), 0L, billName, Collections.emptyMap());
                ReserveService.delReserveRecord(billName, ids, opName);
                QFilter qFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
            }
        }
    }

    private static void delReserveRecord(String billName, List<Object> ids, String opName) {
        String mpsUnAutoReserve = "MpsUnAutoReserve";
        if (opName != null && (ids = ReserveServiceCfgFilterHelper.canReserveBillIds(mpsUnAutoReserve, ids.toArray(new Long[ids.size()]), billName, opName)).size() == 0) {
            return;
        }
        HashSet<Object> idSet = new HashSet<Object>(ids.size());
        idSet.addAll(ids);
        ReserveRecordHandler.batchReserveRemoveByBillId(idSet);
    }

    public static void removeReserveRecordByRecordId(List<Object> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection recordList = ReserveRecordHelper.queryReserveRecordList(filter);
        if (!recordList.isEmpty()) {
            ReserveRecordHandler.reserveRemoveByRecordList((List<DynamicObject>)recordList);
        }
    }

    public static OperationResult autoReserveByIds(String billName, List<Object> ids) {
        if (ThreadCache.get((Object)"ReserveOpName") == null) {
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
        }
        DynamicObject[] requestBillArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billName));
        return ReserveHelper.autoReserve(billName, requestBillArray);
    }

    public static OperationResult autoReserveByDynamicObject(String billName, DynamicObject requestBill) {
        return ReserveHelper.autoReserve(billName, new DynamicObject[]{requestBill});
    }

    public static OperationResult autoReserve(String billName, DynamicObject[] requestBillList) {
        return ReserveHelper.autoReserve(billName, requestBillList);
    }

    public static List<BillReserveResult> autoReservePredict(String billName, DynamicObject[] requestBillList) {
        return ReserveHelper.autoReservePredict(billName, requestBillList);
    }

    public static String autoReservePredictStr(String billName, DynamicObject[] requestBillList) {
        return SerializationUtils.toJsonString(ReserveHelper.autoReservePredict(billName, requestBillList));
    }

    public static void reserveReplace(String billName, List<Object> ids) {
        List<Object> idsList;
        Throwable throwable;
        TXHandle tx;
        block17: {
            block18: {
                block19: {
                    tx = TX.requiresNew((String)"MpsReserveService-reserveReplace");
                    throwable = null;
                    String reserveReplace = "ReserveReplace";
                    Map releaseBill = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)billName);
                    idsList = ReserveServiceCfgFilterHelper.canReserveBillIds(reserveReplace, ids.toArray(new Long[0]), billName, null);
                    if (idsList.size() != 0) break block17;
                    if (tx == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                ReserveReplaceHelper.reserveReplace(billName, idsList);
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static String getMsgReserveServiceReverseFailOp() {
        return ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u53cd\u5411\u64cd\u4f5c\u5931\u8d25\u3002", (String)"MpsReserveService_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }

    public static OperationResult doManualReserveService(String billName, String billId, String billEntryIds, IFormView formView) {
        OperationResult result = new OperationResult();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("billName", (Object)billName);
        showParameter.setCustomParam("billId", (Object)billId);
        showParameter.setCustomParam("billEntryIds", (Object)billEntryIds);
        showParameter.setFormId("msmod_manual_select");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formView.showForm(showParameter);
        return result;
    }

    public static void autoReleaseReserveRecord() {
        AutoTaskHelper.autoReleaseReserveRecord();
    }

    public static List<String> checkDimRange(List<QFilter> qFilters) {
        ArrayList<String> selColList = new ArrayList<String>(16);
        Map<String, String> invColMap = ColsMapHelper.findBillColMaps("im_inv_realbalance", "msmod_std_inv_field").getBillColMap();
        Map<String, String> aggColMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
        ArrayList<String> dimList = new ArrayList<String>(qFilters.size());
        for (QFilter qFilter : qFilters) {
            selColList.add(aggColMap.get(invColMap.get(qFilter.getProperty())));
            dimList.add(invColMap.get(qFilter.getProperty()));
        }
        List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
        ArrayList<String> aggDimList = new ArrayList<String>(aggregateField.size());
        for (String colString : aggregateField) {
            String dim = invColMap.get(aggColMap.get(colString));
            aggDimList.add(dim);
        }
        if (!aggDimList.containsAll(dimList)) {
            return new ArrayList<String>(16);
        }
        return selColList;
    }

    public static String getInventoryAvbQty(String barNumber, Map<String, Object> params) {
        InventorySearchResult result = ReserveService.getInvAvbQty(barNumber, params);
        return SerializationUtils.toJsonString((Object)result);
    }

    public static InventorySearchResult getInvAvbQty(String barNumber, Map<String, Object> params) {
        InventorySearchResult result;
        if (params.size() == 0) {
            InventorySearchResult result2 = new InventorySearchResult();
            result2.setSuccess(false);
            result2.setErrMsg("params is null.");
            return result2;
        }
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        boolean isAggregateInit = (Boolean)aggregateCfg.get("isAggregateInit");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)barNumber);
        if (isAggregateInit) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)"msmod_reserveaggre");
        }
        Map dataMap = mainEntityType.getFields();
        StringBuilder selectColSb = new StringBuilder();
        for (String field : dataMap.keySet()) {
            selectColSb.append(field).append(',');
        }
        selectColSb.append("id");
        if (isAggregateInit) {
            result = ReserveService.getAggregateInventoryAvbQty(barNumber, params, aggregateCfg, selectColSb.toString());
            barNumber = "msmod_reserveaggre";
        } else {
            result = ReserveService.getDetailInventoryAvbQty(barNumber, params, selectColSb.toString());
        }
        ReserveService.mergeQtyForHighHotSearch(barNumber, result);
        return result;
    }

    private static void mergeQtyForHighHotSearch(String barNumber, InventorySearchResult result) {
        if (result.isSuccess()) {
            ReserveHelper.mergeQtyForHighHot(barNumber, result.getCol());
        }
    }

    private static InventorySearchResult getAggregateInventoryAvbQty(String barNumber, Map<String, Object> params, Map<String, Object> aggregateCfg, String selectCols) {
        InventorySearchResult result = new InventorySearchResult();
        Map<String, String> aggBalMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
        ColsMap colsMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field");
        Map<String, String> billColMap = colsMap.getBillColMap();
        List aggregateField = (List)aggregateCfg.get("aggregateField");
        QFilter aggFilter = new QFilter("barobj", "=", (Object)barNumber);
        if ("im_inv_realbalance".equals(barNumber)) {
            aggFilter.or("barobj", "is null", null).or("barobj", "=", (Object)" ").or("barobj", "=", (Object)"");
        }
        StringBuilder errFieldSb = new StringBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String oldKey = param.getKey();
            String[] oldKeyArr = oldKey.split("\\.");
            if (oldKeyArr.length > 1) {
                oldKey = oldKeyArr[0];
            }
            if (!("id".equals(oldKey) || billColMap.get(oldKey) != null && aggregateField.contains(billColMap.get(oldKey)))) {
                errFieldSb.append(oldKey).append(',');
                continue;
            }
            String actKey = aggBalMap.get(billColMap.get(oldKey));
            if (oldKeyArr.length > 1) {
                actKey = param.getKey().replace(oldKey + ".", actKey + ".");
            }
            if ("id".equals(oldKey)) {
                actKey = "id";
            }
            if (param.getValue() instanceof Collection) {
                aggFilter = aggFilter.and(actKey, "in", param.getValue());
                continue;
            }
            aggFilter = aggFilter.and(actKey, "=", param.getValue());
        }
        if (errFieldSb.length() > 0) {
            result.setSuccess(false);
            result.setErrMsg(kd.bos.dataentity.utils.StringUtils.join((Object[])new String[]{ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u5fc5\u987b\u5728\u603b\u91cf\u7ef4\u5ea6\u4e2d\uff0c\u4e14\u5728\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u7684\u6620\u5c04\u914d\u7f6e\u4e2d\u5df2\u914d\u7f6e\uff1a", (String)"ReserveService_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), errFieldSb.toString()}));
        } else {
            DynamicObjectCollection col = QueryServiceHelper.query((String)"msmod_reserveaggre", (String)selectCols, (QFilter[])new QFilter[]{aggFilter});
            result.setSuccess(true);
            result.setCol(col);
        }
        return result;
    }

    private static InventorySearchResult getDetailInventoryAvbQty(String barNumber, Map<String, Object> params, String selectCols) {
        InventorySearchResult result = new InventorySearchResult();
        QFilter qFilter = new QFilter("baseqty", ">", (Object)0);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String actKey = param.getKey();
            if (param.getValue() instanceof Collection) {
                qFilter = qFilter.and(actKey, "in", param.getValue());
                continue;
            }
            qFilter = qFilter.and(actKey, "=", param.getValue());
        }
        try {
            DynamicObjectCollection col = QueryServiceHelper.query((String)barNumber, (String)selectCols, (QFilter[])new QFilter[]{qFilter});
            result.setSuccess(true);
            result.setCol(col);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrMsg(e.getMessage());
        }
        return result;
    }

    public static InventorySearchResult getInvQtyByBal(String balNumber, Map<String, Object> params) {
        if (params.size() == 0) {
            InventorySearchResult result = new InventorySearchResult();
            result.setSuccess(false);
            result.setErrMsg("params is null.");
            return result;
        }
        Map dataMap = EntityMetadataCache.getDataEntityType((String)balNumber).getFields();
        StringBuilder selectColSb = new StringBuilder();
        for (String field : dataMap.keySet()) {
            selectColSb.append(field).append(',');
        }
        selectColSb.append("id");
        InventorySearchResult result = ReserveService.getDetailInventoryAvbQty(balNumber, params, selectColSb.toString());
        ReserveService.mergeQtyForHighHotSearch(balNumber, result);
        return result;
    }

    public static String getInvQtyStrByBal(String balNumber, Map<String, Object> params) {
        return SerializationUtils.toJsonString((Object)ReserveService.getInvQtyByBal(balNumber, params));
    }

    public static String getReserveRecord(String billNumber, Map<Long, Set<Long>> params) {
        InventorySearchResult result = new InventorySearchResult();
        if (!billNumberList.contains(billNumber)) {
            result.setCol(null);
            result.setSuccess(false);
            result.setErrMsg(ResManager.loadKDString((String)"\u8bf7\u6309\u9700\u6c42ID\uff08bill_id\uff09\u3001\u6309\u4f9b\u5e94ID\uff08bal_id\uff09\u3001\u6309\u5bf9\u8c61ID\uff08reserveobj\uff09\u4f20\u5165\u6b63\u786e\u7684\u6807\u8bc6\u3002", (String)"ReserveTotalEditPlugin_8", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return SerializationUtils.toJsonString((Object)result);
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"msmod_reserve_record");
        Map dataMap = mainEntityType.getFields();
        StringBuilder selectColSb = new StringBuilder();
        for (String field : dataMap.keySet()) {
            selectColSb.append(field).append(',');
        }
        selectColSb.append("id");
        QFilter qfilter = ReserveService.getQfilter(billNumber, params);
        try {
            DynamicObjectCollection reserveRecord = QueryServiceHelper.query((String)"msmod_reserve_record", (String)selectColSb.toString(), (QFilter[])qfilter.toArray());
            result.setCol(reserveRecord);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrMsg(e.getMessage());
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    public static void reserveRemoveBySourceObj(String billNumber, Map<Long, Set<Long>> params) {
        InventorySearchResult result = new InventorySearchResult();
        if (!billNumberList.contains(billNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u9700\u6c42ID\uff08bill_id\uff09\u3001\u6309\u4f9b\u5e94ID\uff08bal_id\uff09\u3001\u6309\u5bf9\u8c61ID\uff08reserveobj\uff09\u4f20\u5165\u6b63\u786e\u7684\u6807\u8bc6\u3002", (String)"ReserveTotalEditPlugin_8", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"msmod_reserve_record");
        Map dataMap = mainEntityType.getFields();
        StringBuilder selectColSb = new StringBuilder();
        for (String field : dataMap.keySet()) {
            selectColSb.append(field).append(',');
        }
        selectColSb.append("id");
        QFilter qfilter = ReserveService.getQfilter(billNumber, params);
        DynamicObjectCollection reserveRecord = QueryServiceHelper.query((String)"msmod_reserve_record", (String)selectColSb.toString(), (QFilter[])qfilter.toArray());
        try (TXHandle tx = TX.requiresNew((String)"reserveRemoveBySourceObj");){
            if (!reserveRecord.isEmpty()) {
                ReserveRecordHandler.reserveRemoveByRecordList((List<DynamicObject>)reserveRecord);
            }
        }
    }

    private static QFilter getQfilter(String billNumber, Map<Long, Set<Long>> params) {
        HashSet<Long> billIdSet = new HashSet<Long>(params.size());
        HashSet billEntryIdSet = new HashSet(params.size());
        for (Map.Entry<Long, Set<Long>> param : params.entrySet()) {
            if (param.getValue() == null) {
                billIdSet.add(param.getKey());
                continue;
            }
            billIdSet.add(param.getKey());
            billEntryIdSet.addAll(param.getValue());
        }
        QFilter qFilter = new QFilter(billNumber, "in", billIdSet);
        if (billEntryIdSet.size() > 0) {
            if (RESBILLNUMBER.equals(billNumber)) {
                qFilter.and("billentry_id", "in", billEntryIdSet);
            } else if (SUPBILLNUMBER.equals(billNumber)) {
                qFilter.and("bal_entryid", "in", billEntryIdSet);
            }
        }
        qFilter.and("base_qty", ">", (Object)0);
        return qFilter;
    }

    public static void reserveReplaceInter(List<Map<String, Object>> paramCol) {
        ArrayList<Long> recordId = new ArrayList<Long>(paramCol.size());
        for (Map<String, Object> map : paramCol) {
            recordId.add((Long)map.get("recordId"));
        }
        HashMap<String, Set<Long>> supInfoMap = new HashMap<String, Set<Long>>(8);
        for (Map<String, Object> map : paramCol) {
            HashSet<Long> idSet = (HashSet<Long>)supInfoMap.get(map.get("supObj"));
            if (idSet == null) {
                idSet = new HashSet<Long>(8);
                supInfoMap.put((String)map.get("supObj"), idSet);
            }
            if (idSet == null) continue;
            idSet.add((Long)map.get("supId"));
        }
        QFilter qFilter = new QFilter("id", "in", (Object)recordId.toArray());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_record", (QFilter[])qFilter.toArray());
        DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_reserve_record", (String)"id,bill_id,bill_obj,billentry_id,base_qty,qty,qty2nd,bal_obj,bal_id,aggregateid", (QFilter[])qFilter.toArray(), null);
        HashMap<Object, Map<Object, Object>> tranSupMap = new HashMap<Object, Map<Object, Object>>(paramCol.size());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(paramCol.size());
        for (Map<String, Object> stringObjectMap : paramCol) {
            for (Map.Entry<String, Object> stringObjectEntry : stringObjectMap.entrySet()) {
                paramsMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
            tranSupMap.put(stringObjectMap.get("recordId"), paramsMap);
        }
        ReserveService.checkReplaceData(paramCol, map);
        try (TXHandle tx = TX.requiresNew((String)"reserveReplaceInter");){
            try {
                ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
                ThreadCache.put((Object)"ReserveOpType", (Object)"replacerelease");
                ReserveService.releaseRecordByFilter(reserveRecord, tranSupMap);
                ReserveReplaceHelper.doNewTransAndReserveRecord(paramCol, tranSupMap, supInfoMap, map);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void releaseRecordByFilter(DataSet reserveRecord, Map<Object, Map<Object, Object>> tranSupMap) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(16);
        while (reserveRecord.hasNext()) {
            Row next = reserveRecord.next();
            Map<Object, Object> map = tranSupMap.get(next.get("id"));
            DynamicObject obj = (DynamicObject)dt.createInstance();
            obj.set("reserve_record", next.get("id"));
            obj.set("bill_obj", map.get("transBill"));
            obj.set("billid", map.get("transBillId"));
            obj.set("entryid", map.get("transBillEntryId"));
            obj.set("base_qty", map.get("base_qty"));
            obj.set("qty", map.get("qty"));
            obj.set("qty2nd", map.get("qty2nd"));
            obj.set("op", (Object)"");
            obj.set("release_type", (Object)"endrelease");
            obj.set("balid", next.get(SUPBILLNUMBER));
            obj.set("balobj", next.get("bal_obj"));
            obj.set("aggregateid", (Object)next.getLong("aggregateid"));
            releaseList.add(obj);
        }
        ReserveRecordHandler.reserveReleaseQty(releaseList);
    }

    private static boolean checkReplaceData(List<Map<String, Object>> paramCol, Map<Object, DynamicObject> recordDyns) {
        for (Map<String, Object> stringObjectMap : paramCol) {
            Object base = stringObjectMap.get("base_qty");
            BigDecimal base_qty = new BigDecimal(Integer.parseInt(base.toString()));
            for (Map.Entry<Object, DynamicObject> dynamicObjectEntry : recordDyns.entrySet()) {
                BigDecimal baseQty = dynamicObjectEntry.getValue().getBigDecimal("base_qty");
                if (base_qty.compareTo(baseQty) <= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u66ff\u6362\u6570\u91cf\u5927\u4e8e\u9884\u7559\u8bb0\u5f55\u6570\u91cf\uff0c\u66ff\u6362\u5931\u8d25\u3002", (String)"ReserveService_11", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        }
        return true;
    }

    public static void reserveUnReplaceInter(List<Map<String, Object>> paramCol) {
        try (TraceSpan ruleSpan = Tracer.create((String)"ReserveTransHelper", (String)"unReserveRecordTrans");){
            ArrayList<Object> billIds = new ArrayList<Object>(paramCol.size());
            ArrayList<String> transbill = new ArrayList<String>(paramCol.size());
            ArrayList<Object> transBillEntryId = new ArrayList<Object>(paramCol.size());
            for (Map<String, Object> stringObjectMap : paramCol) {
                billIds.add(stringObjectMap.get("transBillId"));
                transbill.add((String)stringObjectMap.get("transBill"));
                transBillEntryId.add(stringObjectMap.get("transBillEntryId"));
            }
            QFilter qFilter = new QFilter("billid", "in", billIds).and(new QFilter("transbill", "in", transbill));
            DynamicObjectCollection reservetransCols = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"bfrecordid,afrecordid,billentryid", (QFilter[])qFilter.toArray());
            if (reservetransCols.isEmpty()) {
                return;
            }
            HashMap<Long, Long> reserveIdsMap = new HashMap<Long, Long>(reservetransCols.size());
            for (DynamicObject reservetrans : reservetransCols) {
                reserveIdsMap.put(reservetrans.getLong("afrecordid"), reservetrans.getLong("bfrecordid"));
            }
            QFilter reserveIdAf = new QFilter("id", "in", reserveIdsMap.keySet());
            QFilter reserveIdBf = new QFilter("id", "in", reserveIdsMap.values());
            DataSet afReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_reserve_record", (String)"id,reserveprctype,bal_id,bal_obj,bal_entryid,base_qty,qty,qty2nd", (QFilter[])new QFilter[]{reserveIdAf}, null);
            Map beforeReserveRecordMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_record", (QFilter[])reserveIdBf.toArray());
            try (TXHandle tx = TX.requiresNew((String)"reserveUnReplaceInter");){
                try {
                    ReserveService.handleBalAndReserveRecord(afReserveRecords, beforeReserveRecordMap, reserveIdsMap);
                    QFilter relqFilter = new QFilter("bill_obj", "in", transbill).and(new QFilter("billid", "in", billIds)).and(new QFilter("entryid", "in", transBillEntryId));
                    DeleteServiceHelper.delete((String)"msmod_reservetrans", (QFilter[])qFilter.toArray());
                    DeleteServiceHelper.delete((String)"msmod_release_record", (QFilter[])relqFilter.toArray());
                    DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])new QFilter("id", "in", reserveIdsMap.keySet()).toArray());
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static void handleBalAndReserveRecord(DataSet afReserveRecords, Map<Object, DynamicObject> bfReserveRecords, Map<Long, Long> reserveIdsMap) {
        HashMap<Long, Object[]> reserveParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> balParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> oldBalParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Object, DynamicObject> prectToDymMap = new HashMap<Object, DynamicObject>(reserveIdsMap.size());
        HashMap<Object, DynamicObject> notPrectToDymMap = new HashMap<Object, DynamicObject>(reserveIdsMap.size());
        for (Map.Entry<Object, DynamicObject> beforeReserveDym : bfReserveRecords.entrySet()) {
            boolean predict = beforeReserveDym.getValue().getBoolean("ispredict");
            if (predict) {
                prectToDymMap.put(beforeReserveDym.getKey(), beforeReserveDym.getValue());
                continue;
            }
            notPrectToDymMap.put(beforeReserveDym.getKey(), beforeReserveDym.getValue());
        }
        while (afReserveRecords.hasNext()) {
            Row reserveRecord = afReserveRecords.next();
            Long reserveId = reserveRecord.getLong("id");
            BigDecimal baseQty = reserveRecord.getBigDecimal("base_qty");
            BigDecimal qty = reserveRecord.getBigDecimal("qty");
            BigDecimal qty2nd = reserveRecord.getBigDecimal("qty2nd");
            Long balId = reserveRecord.getLong("bal_entryid");
            Long bfReserveId = reserveIdsMap.get(reserveId);
            if (bfReserveId == null) continue;
            Object[] reserveParam = (Object[])reserveParamsMap.get(bfReserveId);
            if (reserveParam == null) {
                reserveParam = new Object[]{baseQty, qty, qty2nd, bfReserveId};
                reserveParamsMap.put(bfReserveId, reserveParam);
            } else {
                reserveParam[0] = baseQty.add((BigDecimal)reserveParam[0]);
                reserveParam[1] = qty.add((BigDecimal)reserveParam[1]);
                reserveParam[2] = qty2nd.add((BigDecimal)reserveParam[2]);
            }
            Object[] balParam = (Object[])balParamsMap.get(balId);
            if (balParam == null) {
                balParam = new Object[]{baseQty, qty, qty2nd, balId};
                balParamsMap.put(balId, balParam);
                continue;
            }
            balParam[0] = baseQty.add((BigDecimal)balParam[0]);
            balParam[1] = qty.add((BigDecimal)balParam[1]);
            balParam[2] = qty2nd.add((BigDecimal)balParam[2]);
        }
        String reserveSql = "update t_msmod_reserverecord set  f_base_qty = f_base_qty + ? ,f_qty = f_qty+ ? ,f_qty2nd = f_qty2nd + ? where fid = ?";
        String ispredictBalSql = "update t_im_inv_realbalance_a  set flockbaseqty = flockbaseqty - ? ,flockqty = flockqty - ? ,flockqty2nd = flockqty2nd - ? where fid = ?";
        ReserveService.updateReserveParams(reserveParamsMap, prectToDymMap);
        ReserveService.executeBatchRecordSql(reserveParamsMap, reserveSql, DBRoute.of((String)"scm"));
        ReserveService.executeBatchRecordSql(balParamsMap, ispredictBalSql, DBRoute.of((String)"scm"));
        ReserveService.rollOldBalanceLockQty(reserveParamsMap, oldBalParamsMap, notPrectToDymMap, DBRoute.of((String)"scm"), "t_im_inv_realbalance");
    }

    private static void updateReserveParams(Map<Long, Object[]> reserveParamsMap, Map<Object, DynamicObject> prectToDymMap) {
        ConvRateContext convRate = new ConvRateContext();
        Set<Object> prectBfIds = prectToDymMap.keySet();
        DataSet oldReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_reserve_record", (String)"id,bal_entryid,bal_obj", (QFilter[])new QFilter("id", "in", prectBfIds).and(new QFilter("ispredict", "=", (Object)true)).toArray(), null);
        HashMap<Long, Long> oldBalIdsMap = new HashMap<Long, Long>(16);
        String formId = null;
        while (oldReserveRecords.hasNext()) {
            Row next = oldReserveRecords.next();
            if (formId == null) {
                formId = next.getString("bal_obj");
            }
            oldBalIdsMap.put(next.getLong("id"), next.getLong("bal_entryid"));
        }
        ColsMap colsMap = ColsMapHelper.findBillColMaps(formId, "msmod_std_inv_field");
        if (oldBalIdsMap.isEmpty() || StringUtils.isEmpty((CharSequence)formId) || colsMap == null) {
            return;
        }
        Map<String, String> colMap = colsMap.getBalColMap();
        StringBuilder sb = new StringBuilder();
        sb.append(colMap.get("materiel")).append(" as ").append("materiel");
        sb.append(" , ").append(colMap.get("baseunit")).append(" as ").append("baseunit");
        sb.append(" , ").append(colMap.get("unit")).append(" as ").append("unit");
        sb.append(" , ").append(colMap.get("billentry")).append(".id").append(" as ").append("entryid");
        DataSet bal = QueryServiceHelper.queryDataSet((String)(ReserveService.class.getName() + ":updateReserveParams"), (String)formId, (String)sb.toString(), (QFilter[])new QFilter(colMap.get("billentry") + ".id", "in", oldBalIdsMap.values()).toArray(), null);
        HashMap entryUnitMap = new HashMap(16);
        bal.forEach(v -> {
            Long balEntryId = v.getLong("entryid");
            HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
            unitMap.put("materiel", v.getLong("materiel"));
            unitMap.put("baseunit", v.getLong("baseunit"));
            unitMap.put("unit", v.getLong("unit"));
            entryUnitMap.put(balEntryId, unitMap);
        });
        for (Map.Entry<Long, Object[]> reserveParams : reserveParamsMap.entrySet()) {
            Long reserveId = reserveParams.getKey();
            Object[] objects = reserveParams.getValue();
            Map unitMap = (Map)entryUnitMap.get(oldBalIdsMap.get(reserveId));
            if (unitMap == null) continue;
            BigDecimal baseQty = (BigDecimal)objects[0];
            objects[1] = convRate.getSrcQty(baseQty, (Long)unitMap.get("materiel"), (Long)unitMap.get("unit"), (Long)unitMap.get("baseunit"));
        }
    }

    private static void executeBatchRecordSql(Map<Long, Object[]> paramsMap, String sql, DBRoute scmRoute) {
        if (paramsMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(1024);
        for (Object[] reserveParam : paramsMap.values()) {
            if (params.size() > 1000) {
                ReserveService.executeMethod(sql, params, scmRoute);
                params.clear();
            }
            params.add(reserveParam);
        }
        ReserveService.executeMethod(sql, params, scmRoute);
    }

    private static void rollOldBalanceLockQty(Map<Long, Object[]> reserveParamsMap, Map<Long, Object[]> oldBalParamsMap, Map<Object, DynamicObject> notPrectToDymMap, DBRoute scmRoute, String table) {
        Set<Object> bfReserveIds = notPrectToDymMap.keySet();
        if (bfReserveIds.isEmpty()) {
            return;
        }
        DataSet oldReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_reserve_record", (String)"id,bal_id", (QFilter[])new QFilter("id", "in", bfReserveIds).toArray(), null);
        while (oldReserveRecords.hasNext()) {
            Row next = oldReserveRecords.next();
            Long reserveId = next.getLong("id");
            Long balId = next.getLong(SUPBILLNUMBER);
            Object[] reserveObj = reserveParamsMap.get(reserveId);
            if (reserveObj == null) continue;
            Object[] balObj = oldBalParamsMap.get(balId);
            if (balObj == null) {
                balObj = new Object[]{reserveObj[0], reserveObj[1], reserveObj[2], balId};
                oldBalParamsMap.put(balId, balObj);
                continue;
            }
            balObj[0] = ((BigDecimal)balObj[0]).add((BigDecimal)reserveObj[0]);
            balObj[1] = ((BigDecimal)balObj[1]).add((BigDecimal)reserveObj[1]);
            balObj[2] = ((BigDecimal)balObj[2]).add((BigDecimal)reserveObj[2]);
        }
        String balSql = "update " + table + "_a  set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? ,flockqty2nd = flockqty2nd + ? where fid = ?";
        ReserveService.executeBatchRecordSql(oldBalParamsMap, balSql, scmRoute);
    }

    private static void executeMethod(String sql, List<Object[]> pramsList, DBRoute scmRoute) {
        DB.executeBatch((DBRoute)scmRoute, (String)sql, pramsList);
    }

    public static boolean getAggregate() {
        return ReserveAggregateHelper.isAggregate();
    }

    public static boolean aggregateInit() {
        return ReserveAggregateHelper.isAggregateInit();
    }

    public static Map<String, Boolean> totalAggQty() {
        return ReserveAggregateHelper.totalAggQty();
    }

    public static Map<String, String> controLevel() {
        return ReserveAggregateHelper.controLevel();
    }

    public static Map<String, String> colsMap() {
        return ColsMapHelper.findBillColMaps("im_inv_realbalance", "msmod_std_inv_field").getBillColMap();
    }

    public static Map<String, String> colsBillMap() {
        return ColsMapHelper.findBillColMaps("im_inv_realbalance", "msmod_std_inv_field").getBalColMap();
    }

    public static List<String> getAggregateField() {
        return ReserveAggregateHelper.getAggregateField();
    }

    public static List<ComboItem> getEffectiveSchemeItem(String billName, long billId) {
        return ColsMapHelper.getEffectiveSchemeItem(billName, billId);
    }

    public static void dealReserveForInvCheck(BalanceUpdateArgs args) {
        long t2;
        UpdateCtx ctx = args.getCtx();
        String op = ctx.getOp();
        Set billIdSet = ctx.getBillIds();
        String entityNumber = ctx.getEntityNumber();
        Object[] ids = new Object[billIdSet.size()];
        ReserveLogHelper.writeCollectInfo(ids.length, 0L, entityNumber, Collections.emptyMap());
        int i = 0;
        for (Object id : billIdSet) {
            ids[i] = id;
            ++i;
        }
        String idString = JSON.toJSONString((Object)ids);
        UpdateRule rule = args.getRule();
        long t1 = System.currentTimeMillis();
        ThreadCache.put((Object)"ReserveOpName", (Object)op);
        if (rule.isForwardOp(op)) {
            ReserveReplaceService.dealStockInfo(args);
            t2 = System.currentTimeMillis();
            logger.info("dealReserveForInvCheck===dealStockInfo===cost time===" + (t2 - t1));
            OperationResult releaseResult = ReserveService.doAuditReleaseReserveOp(entityNumber, idString, op);
            long t3 = System.currentTimeMillis();
            logger.info("reserveReleaseByBill===doAuditReleaseReserveOp===cost time===" + (t3 - t2));
            if (releaseResult != null && !releaseResult.isSuccess() && releaseResult.getMessage() != null) {
                throw new KDBizException(releaseResult.getMessage());
            }
        } else {
            if (ReserveService.unReplace(args, ctx, billIdSet)) {
                return;
            }
            t2 = System.currentTimeMillis();
            logger.info("dealReserveForInvCheck===unReplace===cost time===" + (t2 - t1));
            ReserveService.unReleaseReserve(entityNumber, idString, op);
            long t3 = System.currentTimeMillis();
            logger.info("dealReserveForInvCheck===unReleaseReserve===cost time===" + (t3 - t2));
        }
        long t4 = System.currentTimeMillis();
        NegativeChecker.check4Update(args);
        long t5 = System.currentTimeMillis();
        logger.info("dealReserveForInvCheck===check4Update===cost time===" + (t5 - t4));
    }

    private static boolean unReplace(BalanceUpdateArgs args, UpdateCtx ctx, Set<Object> billIdSet) {
        Set<Object> realBillIdSet;
        ThreadCache.put((Object)"ReserveOpType", (Object)"unreplace");
        DynamicObject serviceCfg = ReserveServiceCfgFilterHelper.ReserveServiceDynamic(ctx.getEntityNumber(), "UnReserveReplace");
        String opName = StringUtils.join((Object[])new String[]{",", ctx.getOp(), ","});
        if (serviceCfg != null && serviceCfg.getString("billoperation").indexOf(opName) > -1 && (realBillIdSet = kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.getReserveReplaceRealIdSet("UnReserveReplace", ctx.getEntityNumber(), billIdSet, ctx.getOp())).size() > 0) {
            BalanceTB tb = args.getRule().getBalanceTB();
            List<Object[]> result = ReserveReplaceService.unReserveRecordReplace(realBillIdSet, ctx.getEntityNumber(), tb.getDbRoute(), false);
            NegativeChecker.check4Update(args);
            if (result != null) {
                for (Object[] obj : result) {
                    if (obj == null || obj[0] == null || obj[1] == null || obj[2] == null) continue;
                    kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.executeBatchRecordSql((Map)obj[2], obj[1].toString(), (DBRoute)obj[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static OperationResult dealAuToReserve(String billName, DynamicObject[] requestBillArray, boolean isFromListForm, String opName) {
        long t1 = System.currentTimeMillis();
        OperationResult result = new OperationResult();
        String mpsAutoReserve = "MpsAutoReserve";
        boolean isAllowReserve = ReserveCommonHelper.getScmParam("INV0006");
        ReserveLogHelper.writeCollectInfo(requestBillArray.length, 0L, billName, Collections.emptyMap());
        if (!isFromListForm && requestBillArray.length == 1) {
            if ((requestBillArray = ReserveServiceCfgFilterHelper.canReserveBillIdDynamic(mpsAutoReserve, billName, requestBillArray, opName)).length > 0) {
                String exitReserveRecordMsg = ReserveHelper.checkBOTPExitReserveRecord(billName, requestBillArray[0].getLong("id"));
                if (exitReserveRecordMsg != null && !isAllowReserve) {
                    result.setSuccess(false);
                    result.setMessage(exitReserveRecordMsg);
                    return result;
                }
                result = ReserveService.autoReserve(billName, requestBillArray);
            }
        } else {
            ArrayList<Object> ids = new ArrayList<Object>(requestBillArray.length);
            for (DynamicObject data : requestBillArray) {
                ids.add(data.getPkValue());
            }
            DynamicObject[] requestBillFromDB = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billName));
            if (ids.size() != requestBillFromDB.length) {
                requestBillFromDB = requestBillArray;
            }
            if ((requestBillFromDB = ReserveServiceCfgFilterHelper.canReserveBillIdDynamic(mpsAutoReserve, billName, requestBillFromDB, opName)).length > 0) {
                StringBuilder tipSb = new StringBuilder();
                if (!isAllowReserve) {
                    requestBillFromDB = ReserveHelper.filterValidateReserveBills(billName, requestBillFromDB, tipSb);
                }
                result = ReserveService.autoReserve(billName, requestBillFromDB);
                if (tipSb.length() > 0) {
                    String message = result.getMessage();
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)message)) {
                        tipSb.append(message);
                    }
                    result.setMessage(tipSb.toString());
                }
            }
        }
        long t2 = System.currentTimeMillis();
        logger.info("dealAuToReserve===cost time===" + (t2 - t1));
        return result;
    }

    public static InventorySearchResult reserveBatchNoScheme(String balNumber, String billName, boolean isAggregate, List<Map<String, Object>> paramMap) {
        InventorySearchResult result = new InventorySearchResult();
        List<String> filedList = Arrays.asList("billId", "billEntryId", "billEntrySeq", "invId", "invEntryId", "baseQty", "qty", "qty2nd", "org", "material", "isPredict");
        ColsMap billColMap = ColsMapHelper.findBillColMap(billName, "msmod_std_request_bill");
        ColsMap balColMap = null;
        balColMap = "msmod_reserveaggre".equals(balNumber) ? ColsMapHelper.findBillColMap("msmod_reserveaggre", "msmod_std_inv_field") : ColsMapHelper.findBillColMap(balNumber, "msmod_std_inv_field");
        if (ReserveService.checkCanNotReserve(balNumber, billName, paramMap, result, filedList, billColMap, balColMap)) {
            return result;
        }
        LinkedList<DynamicObject> billReserveRecordList = new LinkedList<DynamicObject>();
        try {
            ArrayList<EntryReserveResult> entryReserveResultList = new ArrayList<EntryReserveResult>(8);
            HashMap<Object, Object> entryIdBillIdMap = new HashMap<Object, Object>(paramMap.size());
            ArrayList<Long> invId = new ArrayList<Long>(paramMap.size());
            StringBuilder qtyErrorSb = new StringBuilder();
            boolean isPredict = false;
            for (Map<String, Object> map : paramMap) {
                entryIdBillIdMap.put(map.get("billEntryId"), map.get("billId"));
                invId.add((Long)map.get("invId"));
                isPredict = (Boolean)map.get("isPredict");
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("baseQty")) > 0) {
                    qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"baseQty"}));
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("qty")) > 0) {
                    qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"qty"}));
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("qty2nd")) <= 0) continue;
                qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"qty2nd"}));
            }
            if (qtyErrorSb.length() > 0) {
                result.setSuccess(false);
                result.setErrMsg(qtyErrorSb.toString());
                return result;
            }
            HashMap<Long, Long> aggInvMap = new HashMap(16);
            if (!isPredict) {
                aggInvMap = kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.getAggInvMap(balNumber, invId, null);
            }
            List<String> aggFieldList = ReserveAggregateHelper.getAggregateField();
            Map<Object, DynamicObject> aggMap = ReserveService.getAggInfoMap(isAggregate, invId, aggFieldList, balColMap);
            for (Map<String, Object> map : paramMap) {
                ReserveService.buildEntryReserveResult(balNumber, isAggregate, entryReserveResultList, map, aggMap, aggFieldList, aggInvMap);
            }
            Map<Object, DynamicObject> requestBillMap = ReserveService.getRequestBillMap(billName, paramMap);
            ReserveRecordHelper.initSelectInfo();
            ArrayList<StdInvResult> stdInvResults = new ArrayList<StdInvResult>(8);
            for (int i = 0; i < entryReserveResultList.size(); ++i) {
                stdInvResults.addAll(((EntryReserveResult)entryReserveResultList.get(i)).getStdInvResultList());
            }
            Map<Object, DynamicObject> supInfoMap = ReserveRecordHelper.getSupInfoMap(stdInvResults);
            Map<Long, Integer> entryIdExpireDateMap = ReserveRecordHelper.getInventoryExpireMap(stdInvResults, null);
            for (EntryReserveResult entryResult : entryReserveResultList) {
                List<StdInvResult> stdInv = entryResult.getStdInvResultList();
                DynamicObject requestBill = requestBillMap.get(entryIdBillIdMap.get(entryResult.getEntryId()));
                DynamicObject scheme = null;
                ReserveContext context = new ReserveContext(requestBill, scheme);
                context.setReserveType("4");
                if (isAggregate) {
                    ReserveRecordHelper.createAggregateReserveRecord(entryResult, context, billReserveRecordList, stdInv, entryIdExpireDateMap);
                    continue;
                }
                ReserveRecordHelper.createDetailReserveRecord(entryResult, context, billReserveRecordList, stdInv, supInfoMap, entryIdExpireDateMap);
            }
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ThreadCache.put((Object)"ReserveOpType", (Object)"autoreserve");
            ReserveRecordHandler.createReserveRecordNew(billReserveRecordList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrMsg(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.addAll(billReserveRecordList);
        result.setCol(col);
        return result;
    }

    private static Map<Object, DynamicObject> getAggInfoMap(boolean isAggregate, List<Long> invId, List<String> aggFieldList, ColsMap balColMap) {
        HashMap<Object, DynamicObject> aggMap = new HashMap<Object, DynamicObject>(invId.size());
        if (isAggregate) {
            Map<String, String> colsMap = balColMap.getBalColMap();
            StringBuilder sb = new StringBuilder();
            for (String field : aggFieldList) {
                sb.append(colsMap.get(field)).append(" as ").append(field).append(",");
            }
            sb.append("id");
            QFilter qFilter = new QFilter("id", "in", invId);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"msmod_reserveaggre", (String)sb.toString(), (QFilter[])qFilter.toArray());
            for (DynamicObject obj : col) {
                aggMap.put(obj.getLong("id"), obj);
            }
        }
        return aggMap;
    }

    private static void buildEntryReserveResult(String balNumber, boolean isAggregate, List<EntryReserveResult> entryReserveResultList, Map<String, Object> map, Map<Object, DynamicObject> aggMap, List<String> aggFieldList, Map<Long, Long> aggInvMap) {
        LinkedList<StdInvResult> stdInvResults = new LinkedList<StdInvResult>();
        StdInvResult stdInvResult = ReserveService.buildStdInvResult(balNumber, isAggregate, map, aggMap, aggFieldList, aggInvMap);
        stdInvResults.add(stdInvResult);
        EntryReserveResult entryResult = new EntryReserveResult();
        entryResult.setEntryId(map.get("billEntryId"));
        entryResult.setSeq((Integer)map.get("billEntrySeq"));
        entryResult.setReservedBaseQty((BigDecimal)map.get("baseQty"));
        entryResult.setReservedQty((BigDecimal)map.get("qty"));
        entryResult.setReservedQty2nd((BigDecimal)map.get("qty2nd"));
        entryResult.setReserveResultType(ReserveResultType.FullSuccess);
        entryResult.setStdInvResultList(stdInvResults);
        entryReserveResultList.add(entryResult);
    }

    private static StdInvResult buildStdInvResult(String balNumber, boolean isAggregate, Map<String, Object> map, Map<Object, DynamicObject> aggMap, List<String> aggFieldList, Map<Long, Long> aggInvMap) {
        StdInvResult stdInvResult = new StdInvResult();
        stdInvResult.setBaseQty((BigDecimal)map.get("baseQty"));
        stdInvResult.setQty((BigDecimal)map.get("qty"));
        stdInvResult.setQty2nd((BigDecimal)map.get("qty2nd"));
        stdInvResult.setPredict((Boolean)map.get("isPredict"));
        HashMap<String, Object> invInfo = new HashMap<String, Object>(8);
        invInfo.put("source_bal_obj", balNumber);
        invInfo.put("source_type", "1");
        invInfo.put("org", map.get("org"));
        invInfo.put("materiel", map.get("material"));
        if (isAggregate) {
            invInfo.put("aggid", map.get("invId"));
            invInfo.put("id", 0L);
            invInfo.put("entryid", 0L);
            DynamicObject obj = aggMap.get(map.get("invId"));
            if (obj == null) {
                throw new KDBizException("invId is not exit.");
            }
            for (String field : aggFieldList) {
                invInfo.put(field, obj.get(field));
            }
        } else {
            if (aggInvMap.get(map.get("invId")) == null) {
                invInfo.put("aggid", 0L);
            } else {
                invInfo.put("aggid", aggInvMap.get(map.get("invId")));
            }
            invInfo.put("id", map.get("invId"));
            invInfo.put("entryid", map.get("invEntryId"));
        }
        stdInvResult.setInvInfo(invInfo);
        return stdInvResult;
    }

    private static Map<Object, DynamicObject> getRequestBillMap(String billName, List<Map<String, Object>> paramMap) {
        HashSet<Long> requestBillIdSet = new HashSet<Long>(paramMap.size());
        for (Map<String, Object> map : paramMap) {
            requestBillIdSet.add((Long)map.get("billId"));
        }
        DynamicObject[] requestBillArray = BusinessDataServiceHelper.load((Object[])requestBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billName));
        HashMap<Object, DynamicObject> requestBillMap = new HashMap<Object, DynamicObject>(requestBillArray.length);
        for (DynamicObject requestBill : requestBillArray) {
            requestBillMap.put(requestBill.getPkValue(), requestBill);
        }
        return requestBillMap;
    }

    private static boolean checkCanNotReserve(String balNumber, String billName, List<Map<String, Object>> paramMap, InventorySearchResult result, List<String> filedList, ColsMap billColMap, ColsMap balColMap) {
        if (paramMap == null || paramMap.size() == 0) {
            result.setSuccess(false);
            result.setErrMsg(ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveService_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"paramMap"}));
            return true;
        }
        if (balColMap == null) {
            result.setSuccess(false);
            result.setErrMsg(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61 {0} \u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\u3002", (String)"ReserveService_13", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{balNumber}));
            return true;
        }
        if (billColMap == null) {
            result.setSuccess(false);
            result.setErrMsg(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9700\u6c42\u5355\u636e {0} \u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u9700\u6c42\u6a21\u578b\uff09\u3002", (String)"ReserveService_14", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{billName}));
            return true;
        }
        StringBuilder fieldSb = new StringBuilder();
        int i = 0;
        boolean isError = false;
        for (Map<String, Object> param : paramMap) {
            fieldSb.append(ResManager.loadKDString((String)"\u7b2c {0} \u884c\u7f3a\u5c11\u5b57\u6bb5\uff1a", (String)"ReserveService_15", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{i}));
            for (String fieldName : filedList) {
                if (param.get(fieldName) != null) continue;
                fieldSb.append(fieldName).append(",");
                isError = true;
            }
            ++i;
        }
        if (isError) {
            result.setSuccess(false);
            result.setErrMsg(fieldSb.toString());
            return true;
        }
        return false;
    }

    public static String reserveBatchFree(String balNumber, String billName, boolean isAggregate, List<Map<String, Object>> paramMap) {
        InventorySearchResult result = ReserveService.reserveBatchNoScheme(balNumber, billName, isAggregate, paramMap);
        return SerializationUtils.toJsonString((Object)result);
    }

    public static String reserveBatchFreeHaveTrans(String balNumber, String billName, boolean isAggregate, List<Map<String, Object>> paramMap) {
        InventorySearchResult reserveResult = new InventorySearchResult();
        try (TXHandle tx = TX.requiresNew((String)"MpsReserveService-reserveBatchFreeHaveTrans");){
            try {
                reserveResult = ReserveService.reserveBatchNoScheme(balNumber, billName, isAggregate, paramMap);
                if (!reserveResult.isSuccess()) {
                    throw new KDBizException(reserveResult.getErrMsg());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                reserveResult.setSuccess(false);
                reserveResult.setErrMsg(e.getMessage());
            }
        }
        return SerializationUtils.toJsonString((Object)reserveResult);
    }

    public static DynamicObject buildReleaseOpRecord(String billName, String ids, String opType) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"buildReleaseOpRecord");){
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"msmod_release_op");
            long userId = RequestContext.get().getCurrUserId();
            Date date = new Date();
            record.set("creater", (Object)userId);
            record.set("createdate", (Object)date);
            record.set("opstatus", (Object)"INIT");
            record.set("billname", (Object)billName);
            record.set("idlist_tag", (Object)ids);
            record.set("optype", (Object)opType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            DynamicObject dynamicObject = record;
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void buildRemoveOpRecordByReserveRecord(Collection<DynamicObject> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>(records.size());
        for (DynamicObject reserveRecord : records) {
            idList.add(reserveRecord.getString("id"));
        }
        QFilter qFilter = new QFilter("billname", "=", (Object)"msmod_reserve_record");
        qFilter.and("idlist_tag", "in", idList);
        qFilter.and("optype", "=", (Object)"REMOVE");
        Set<String> existRecordIds = ReserveService.getRemoveOpRecordDataId("msmod_reserve_record", idList);
        ArrayList<DynamicObject> releaseOpRecList = new ArrayList<DynamicObject>(records.size());
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject record : records) {
            String recordId = record.getString("id");
            if (existRecordIds.contains(recordId)) continue;
            DynamicObject opRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_release_op");
            String billName = record.getDataEntityType().getName();
            opRecord.set("creater", (Object)userId);
            opRecord.set("createdate", (Object)date);
            opRecord.set("opstatus", (Object)"INIT");
            opRecord.set("billname", (Object)billName);
            opRecord.set("idlist_tag", (Object)record.getString("id"));
            opRecord.set("optype", (Object)"REMOVE");
            releaseOpRecList.add(opRecord);
        }
        if (!releaseOpRecList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])releaseOpRecList.toArray(new DynamicObject[0]));
        }
    }

    public static void deleteReleaseOpRecord(long recordId) {
        try (TXHandle tx = TX.requiresNew((String)"deleteReleaseOpRecord");){
            try {
                QFilter qFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void deleteRemoveOpRecordByReserveRecord(Collection<DynamicObject> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>(records.size());
        for (DynamicObject reserveRecord : records) {
            idList.add(reserveRecord.getString("id"));
        }
        QFilter qFilter = new QFilter("billname", "=", (Object)"msmod_reserve_record");
        qFilter.and("idlist_tag", "in", idList);
        qFilter.and("optype", "=", (Object)"REMOVE");
        DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
    }

    public static Set<String> getRemoveOpRecordDataId(String billName, List<String> ids) {
        QFilter qFilter = new QFilter("billname", "=", (Object)billName);
        qFilter.and("idlist_tag", "in", ids);
        qFilter.and("optype", "=", (Object)"REMOVE");
        DynamicObjectCollection removeOpRecord = QueryServiceHelper.query((String)"msmod_release_op", (String)"idlist_tag,id", (QFilter[])qFilter.toArray());
        if (removeOpRecord == null || removeOpRecord.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> idSet = new HashSet<String>(removeOpRecord.size());
        for (DynamicObject opRecord : removeOpRecord) {
            idSet.add(opRecord.getString("idlist_tag"));
        }
        return idSet;
    }

    public static void releaseReserveRollBack(long recordId, String billName, String ids) {
        try (TXHandle tx = TX.requiresNew((String)"releaseReserveRollBack");){
            try {
                List<Object> idArrList = Arrays.asList((Object[])JSON.parseObject((String)ids, Long[].class));
                ReserveRecordHandler.releaseReserveRollBackQty(ReserveService.matchUnReleaseRecord(idArrList, billName));
                QFilter qFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void unReleaseReserveRollBack(long recordId, String ids) {
        try (TXHandle tx = TX.requiresNew((String)"unReleaseReserveRollBack");){
            try {
                Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                QFilter releaseFilter = new QFilter("billid", "in", (Object)idArr);
                releaseFilter = releaseFilter.and("deletestatus", "=", (Object)"1");
                DynamicObjectCollection releaseCol = QueryServiceHelper.query((String)"msmod_release_record", (String)"id,reserve_record,base_qty,qty,qty2nd,billid,billno,bill_obj,entryid", (QFilter[])releaseFilter.toArray(), null);
                ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(releaseCol.size());
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(releaseCol.size());
                HashMap<Long, Object[]> releaseQtyMap = new HashMap<Long, Object[]>(releaseCol.size());
                HashMap<Long, Object[]> releaseBalMap = new HashMap<Long, Object[]>(releaseCol.size());
                for (int i = 0; i < releaseCol.size(); ++i) {
                    DynamicObject release = (DynamicObject)releaseCol.get(i);
                    Object[] param = new Object[]{release.getBigDecimal("base_qty"), release.getBigDecimal("qty"), release.getBigDecimal("qty2nd"), release.getLong("reserve_record")};
                    recordParamList.add(param);
                    paramList.add(new Object[]{release.getLong("id")});
                    long reserveRecordId = release.getLong("reserve_record");
                    Object[] qtyObj = (Object[])releaseQtyMap.get(reserveRecordId);
                    if (qtyObj == null) {
                        qtyObj = param;
                    } else {
                        qtyObj[0] = ((BigDecimal)qtyObj[0]).add(release.getBigDecimal("base_qty"));
                        qtyObj[1] = ((BigDecimal)qtyObj[1]).add(release.getBigDecimal("qty"));
                        qtyObj[2] = ((BigDecimal)qtyObj[2]).add(release.getBigDecimal("qty2nd"));
                    }
                    releaseQtyMap.put(reserveRecordId, qtyObj);
                    Object[] balArr = new Object[]{release.getString("bill_obj"), release.getLong("billid"), release.getString("billno"), release.getLong("entryid")};
                    releaseBalMap.put(reserveRecordId, balArr);
                }
                if (recordParamList.size() > 0) {
                    String reserveRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty - ?,f_qty = f_qty - ?,f_qty2nd = f_qty2nd - ? where fid=?";
                    DB.executeBatch((DBRoute)scmRoute, (String)reserveRecordSql, BalanceHelper.sortSqlParamList(recordParamList));
                    DynamicObject[] col = BusinessDataServiceHelper.load((Object[])releaseQtyMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msmod_reserve_record"));
                    ArrayList<DynamicObject> reserveRecordList = new ArrayList<DynamicObject>(col.length);
                    for (DynamicObject obj : col) {
                        long reserveRecordId = obj.getLong("id");
                        if (releaseQtyMap.get(reserveRecordId) == null) continue;
                        Object[] qtyObj = (Object[])releaseQtyMap.get(reserveRecordId);
                        obj.set("base_qty", (Object)((BigDecimal)qtyObj[0]).negate());
                        obj.set("qty", (Object)((BigDecimal)qtyObj[1]).negate());
                        obj.set("qty2nd", (Object)((BigDecimal)qtyObj[2]).negate());
                        obj.set("bal_obj", (Object)obj.getDynamicObject("bal_obj").getString("number"));
                        obj.set(SUPBILLNUMBER, (Object)obj.getLong(SUPBILLNUMBER));
                        obj.set("reserve_scheme", (Object)obj.getDynamicObject("reserve_scheme").getLong("id"));
                        Object[] balArr = (Object[])releaseBalMap.get(reserveRecordId);
                        obj.set("bill_obj", balArr[0]);
                        obj.set(RESBILLNUMBER, balArr[1]);
                        obj.set("bill_no", balArr[2]);
                        obj.set("billentry_id", balArr[3]);
                        obj.set("billentry_seq", (Object)0L);
                        reserveRecordList.add(obj);
                    }
                    ReserveRecordHandler.releaseReserveRecord(reserveRecordList);
                    if (ThreadCache.get((Object)"ReserveOpType") == null) {
                        ThreadCache.put((Object)"ReserveOpType", (Object)"unreleaseback");
                    }
                    ReserveOpLogHelper.createNewLogByRecord(reserveRecordList, false);
                    String updateSql = "update t_msmod_release_record set fdeletestatus ='0' where fid =?";
                    DB.executeBatch((DBRoute)scmRoute, (String)updateSql, BalanceHelper.sortSqlParamList(paramList));
                }
                QFilter qFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void releaseByUnAutoReserve(long recordId, String ids) {
        try (TXHandle tx = TX.requiresNew((String)"releaseByUnAutoReserve");){
            try {
                Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                if (idArr != null && idArr.length > 0) {
                    ReserveRecordHandler.batchReserveRemoveByBillId(new HashSet<Object>(Arrays.asList(idArr)));
                }
                QFilter qFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void deleteUnReleaseData(String ids) {
        try (TXHandle tx = TX.requiresNew((String)"unReleaseReserveRollBack");){
            try {
                Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                QFilter qFilter = new QFilter("billid", "in", (Object)idArr);
                qFilter.and("deletestatus", "=", (Object)"1");
                DeleteServiceHelper.delete((String)"msmod_release_record", (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void reservePollingTask() {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reservePollingTask");){
            ThreadCache.put((Object)"ReserveOpName", (Object)"autoTask");
            AutoTaskHelper.dealHighHotTask();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(11, -1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            QFilter qFilter = new QFilter("createdate", "<", (Object)cal.getTime());
            DynamicObjectCollection opObjList = QueryServiceHelper.query((String)"msmod_release_op", (String)"billname,id,optype,idlist_tag", (QFilter[])qFilter.toArray());
            for (DynamicObject op : opObjList) {
                long recordId = op.getLong("id");
                String opType = op.getString("optype");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)opType)) continue;
                switch (opType) {
                    case "RELEASE": {
                        ReserveService.releaseReserveRollBack(recordId, op.getString("billname"), op.getString("idlist_tag"));
                        break;
                    }
                    case "UNRELEASE": {
                        ReserveService.unReleaseReserveRollBack(recordId, op.getString("idlist_tag"));
                        break;
                    }
                    case "UNAUTORE": {
                        ReserveService.releaseByUnAutoReserve(recordId, op.getString("idlist_tag"));
                        break;
                    }
                    case "REMOVE": {
                        ReserveService.reserveRemove(recordId, op.getString("idlist_tag"));
                        break;
                    }
                }
            }
            QFilter releaseFilter = new QFilter("create_date", "<", (Object)cal.getTime());
            DynamicObjectCollection releaseList = QueryServiceHelper.query((String)"msmod_release_op", (String)"id", (QFilter[])releaseFilter.toArray());
            if (releaseList.size() > 0) {
                Long[] ids = new Long[releaseList.size()];
                for (int i = 0; i < releaseList.size(); ++i) {
                    DynamicObject release = (DynamicObject)releaseList.get(i);
                    ids[i] = release.getLong("id");
                }
                ReserveService.deleteUnReleaseData(JSON.toJSONString((Object)ids));
            }
        }
    }

    public static String checkBOTPExitReserveRecord(String billName, long billId) {
        return ReserveHelper.checkBOTPExitReserveRecord(billName, billId);
    }

    public static Set<Long> filterNoBOTPReserveBill(String billName, Set<Long> billIdSet) {
        return ReserveHelper.filterNoBOTPReserveBill(billName, billIdSet);
    }

    public static void autoCarryReserveOpLog() {
        AutoTaskHelper.autoCarryReserveOpLog();
    }

    public static OperationResult removeAllReserveByBill(String billName, Set<Object> billIdSet) {
        OperationResult operationResult = new OperationResult();
        if (billName == null) {
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveService_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"billName"}));
            return operationResult;
        }
        if (billIdSet == null) {
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveService_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"billIdSet"}));
            return operationResult;
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)"chargeagainst");
        ThreadCache.put((Object)"ReserveOpType", (Object)"unreplace");
        List<Object[]> result = ReserveReplaceService.unReserveRecordReplace(billIdSet, billName, scmRoute, false);
        if (result != null) {
            for (Object[] objectArray : result) {
                if (objectArray == null || objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) continue;
                kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.executeBatchRecordSql((Map)objectArray[2], objectArray[1].toString(), (DBRoute)objectArray[0]);
            }
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"unrelease");
        ArrayList<Object> idList = new ArrayList<Object>(billIdSet.size());
        for (Object object : billIdSet) {
            idList.add(object);
        }
        Throwable throwable = null;
        try (TXHandle tXHandle = TX.requiresNew((String)"removeAllReserveByBill-unrelease");){
            try {
                ReserveRecordHandler.unReleaseReserveQty(ReserveService.matchUnReleaseRecord(idList, billName), false, false);
            }
            catch (Exception e1) {
                tXHandle.markRollback();
                ThreadCache.put((Object)"ReserveOpType", (Object)"unreplaceback");
                ReserveReplaceService.unReserveReplaceRollBack(billName, billIdSet);
                throw e1;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"release");
        operationResult = ReserveService.terminalReleaseReserve(billName, idList, null);
        if (operationResult != null && !operationResult.isSuccess()) {
            ThreadCache.put((Object)"ReserveOpType", (Object)"unreplaceback");
            ReserveReplaceService.unReserveReplaceRollBack(billName, billIdSet);
            ThreadCache.put((Object)"ReserveOpType", (Object)"unreleaseback");
            ReserveService.unReleaseReserveRollBack(0L, JSON.toJSONString(idList));
        }
        return operationResult;
    }

    public static OperationResult removeAllReserveByBillRollBack(String billName, Set<Object> billIdSet) {
        OperationResult operationResult = new OperationResult();
        if (billName == null) {
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveService_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"billName"}));
            return operationResult;
        }
        if (billIdSet == null) {
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveService_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"billIdSet"}));
            return operationResult;
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)"chargeagainstback");
        ThreadCache.put((Object)"ReserveOpType", (Object)"unreplaceback");
        ReserveReplaceService.unReserveReplaceRollBack(billName, billIdSet);
        Long[] ids = new Long[billIdSet.size()];
        int i = 0;
        for (Object o : billIdSet) {
            ids[i] = (Long)o;
            ++i;
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"releaseback");
        ReserveService.unReleaseReserveRollBack(0L, JSON.toJSONString((Object)ids));
        ThreadCache.put((Object)"ReserveOpType", (Object)"unreleaseback");
        return ReserveService.unReleaseReServeForRollback(billName, JSON.toJSONString((Object)ids), false, null);
    }

    public static void reserveRemove(long recordId, String ids) {
        try (TXHandle tx = TX.requiresNew((String)"reserveRemove");){
            try {
                long id = Long.parseLong(ids);
                QFilter qFilter = new QFilter("id", "=", (Object)id);
                DynamicObject[] recordDataArr = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)"id,base_qty,qty,qty2nd,expiredate,ispredict,bal_obj,reserve_scheme,bal_id,aggregateid,bill_obj,bill_id,bill_no,billentry_id,billentry_seq", (QFilter[])qFilter.toArray());
                if (recordDataArr.length > 0) {
                    ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(recordDataArr.length);
                    recordList.addAll(Arrays.asList(recordDataArr));
                    ReserveRecordHelper.removeReserveRecord(recordList);
                    ReserveOpLogHelper.createNewLogByRecord(recordList, true);
                    ReleaseRecordHelper.createByReserveRecord(recordList, false);
                }
                QFilter delFilter = new QFilter("id", "=", (Object)recordId);
                DeleteServiceHelper.delete((String)"msmod_release_op", (QFilter[])delFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static InventorySearchResult reserveBatchNotSup(String balNumber, String billName, boolean isAggregate, List<Map<String, Object>> paramMap) {
        InventorySearchResult result = new InventorySearchResult();
        List<String> filedList = Arrays.asList("billId", "billEntryId", "billEntrySeq", "invId", "invEntryId", "baseQty", "qty", "qty2nd", "org", "material", "isPredict");
        ColsMap billColMap = ColsMapHelper.findBillColMap(billName, "msmod_std_request_bill");
        ColsMap balColMap = null;
        balColMap = "msmod_reserveaggre".equals(balNumber) ? ColsMapHelper.findBillColMap("msmod_reserveaggre", "msmod_std_inv_field") : ColsMapHelper.findBillColMap(balNumber, "msmod_std_inv_field");
        if (ReserveService.checkCanNotReserve(balNumber, billName, paramMap, result, filedList, billColMap, balColMap)) {
            return result;
        }
        LinkedList<DynamicObject> billReserveRecordList = new LinkedList<DynamicObject>();
        try {
            ArrayList<EntryReserveResult> entryReserveResultList = new ArrayList<EntryReserveResult>(8);
            HashMap<Object, Object> entryIdBillIdMap = new HashMap<Object, Object>(paramMap.size());
            ArrayList<Long> invId = new ArrayList<Long>(paramMap.size());
            StringBuilder qtyErrorSb = new StringBuilder();
            boolean isPredict = false;
            for (Map<String, Object> map : paramMap) {
                entryIdBillIdMap.put(map.get("billEntryId"), map.get("billId"));
                invId.add((Long)map.get("invId"));
                isPredict = (Boolean)map.get("isPredict");
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("baseQty")) > 0) {
                    qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"baseQty"}));
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("qty")) > 0) {
                    qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"qty"}));
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("qty2nd")) <= 0) continue;
                qtyErrorSb.append("billEntryId:").append(map.get("billEntryId")).append(ResManager.loadKDString((String)"{0} \u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ReserveService_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{"qty2nd"}));
            }
            if (qtyErrorSb.length() > 0) {
                result.setSuccess(false);
                result.setErrMsg(qtyErrorSb.toString());
                return result;
            }
            HashMap<Long, Long> aggInvMap = new HashMap(16);
            if (!isPredict) {
                aggInvMap = kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.getAggInvMap(balNumber, invId, null);
            }
            List<String> aggFieldList = ReserveAggregateHelper.getAggregateField();
            Map<Object, DynamicObject> aggMap = ReserveService.getAggInfoMap(isAggregate, invId, aggFieldList, balColMap);
            for (Map<String, Object> map : paramMap) {
                ReserveService.buildEntryReserveResult(balNumber, isAggregate, entryReserveResultList, map, aggMap, aggFieldList, aggInvMap);
            }
            Map<Object, DynamicObject> requestBillMap = ReserveService.getRequestBillMap(billName, paramMap);
            ReserveRecordHelper.initSelectInfo();
            ArrayList<StdInvResult> stdInvResults = new ArrayList<StdInvResult>(8);
            for (int i = 0; i < entryReserveResultList.size(); ++i) {
                stdInvResults.addAll(((EntryReserveResult)entryReserveResultList.get(i)).getStdInvResultList());
            }
            Map<Object, DynamicObject> supInfoMap = ReserveRecordHelper.getSupInfoMap(stdInvResults);
            Map<Long, Integer> entryIdExpireDateMap = ReserveRecordHelper.getInventoryExpireMap(stdInvResults, null);
            for (EntryReserveResult entryResult : entryReserveResultList) {
                List<StdInvResult> stdInv = entryResult.getStdInvResultList();
                DynamicObject requestBill = requestBillMap.get(entryIdBillIdMap.get(entryResult.getEntryId()));
                DynamicObject scheme = null;
                ReserveContext context = new ReserveContext(requestBill, scheme);
                context.setReserveType("4");
                if (isAggregate) {
                    ReserveRecordHelper.createAggregateReserveRecord(entryResult, context, billReserveRecordList, stdInv, entryIdExpireDateMap);
                    continue;
                }
                ReserveRecordHelper.createDetailReserveRecord(entryResult, context, billReserveRecordList, stdInv, supInfoMap, entryIdExpireDateMap);
            }
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ThreadCache.put((Object)"ReserveOpType", (Object)"autoreserve");
            ReserveRecordHandler.createReserveRecordNotSup(billReserveRecordList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrMsg(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.addAll(billReserveRecordList);
        result.setCol(col);
        return result;
    }
}

