/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.reserve.form.NegativeInvTipConfEdit;

public class NegativeTipCfSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            this.checkData(data);
        }
    }

    private void checkData(ExtendedDataEntity data) {
        DynamicObjectCollection dynamicObjectCollection;
        boolean noneMatch;
        DynamicObject dataEntity = data.getDataEntity();
        String number = dataEntity.getString("number");
        if (StringUtils.isNotEmpty((String)number)) {
            DynamicObject dynamicObject;
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            Object id = dataEntity.get("id");
            if (id != null) {
                qFilter.and(new QFilter("id", "!=", id));
            }
            if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)"im_negative_tip_cf", (String)"id", (QFilter[])qFilter.toArray())) != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NegativeTipCfSaveValidator_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
                return;
            }
        }
        if (noneMatch = (dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity")).stream().noneMatch(item -> item.getBoolean("tipcol"))) {
            String msg = String.format(ResManager.loadKDString((String)"\u63d0\u793a\u7ef4\u5ea6\u672a\u52fe\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NegativeTipCfSaveValidator_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), new Object[0]);
            this.addMessage(data, msg, ErrorLevel.Error);
            return;
        }
        DynamicObject balTb = dataEntity.getDynamicObject("baltb");
        String billScopeStr = dataEntity.getString("billscope");
        if (balTb != null && StringUtils.isNotEmpty((String)billScopeStr)) {
            DynamicObject[] dynamicObjects;
            QFilter qFilter = new QFilter("baltb", "=", balTb.getPkValue());
            Object id = dataEntity.get("id");
            if (id != null) {
                qFilter.and(new QFilter("id", "!=", id));
            }
            if ((dynamicObjects = BusinessDataServiceHelper.load((String)"im_negative_tip_cf", (String)"id,baltb,billscope", (QFilter[])qFilter.toArray())) == null) {
                return;
            }
            HashSet<String> stringSet = new HashSet<String>();
            for (DynamicObject obj : dynamicObjects) {
                String[] bills;
                String[] str = obj.getString("billscope");
                if (!StringUtils.isNotEmpty((String)str)) continue;
                for (String bill : bills = str.split(",")) {
                    stringSet.add(bill);
                }
            }
            StringBuilder buffer = new StringBuilder();
            String[] bills = billScopeStr.split(",");
            List<DynamicObject> billScopeList = NegativeInvTipConfEdit.getBillScopeList(balTb);
            Map<String, String> map = billScopeList.stream().collect(Collectors.toMap(item -> item.getString("number"), item -> item.getString("name")));
            for (String bill : bills) {
                if (!StringUtils.isNotEmpty((String)bill) || !stringSet.contains(bill)) continue;
                buffer.append(map.get(bill)).append(",");
            }
            if (buffer.length() > 0) {
                String msg = ResManager.loadKDString((String)"\u4f59\u989d\u8868\uff1a{0}\uff0c\u5355\u636e\u5b9e\u4f53\uff1a{1}\uff0c\u5df2\u5b58\u5728\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NegativeTipCfSaveValidator_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{balTb.getString("name"), buffer.substring(0, buffer.lastIndexOf(","))});
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
    }
}

