/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;

public class ReserveInvRuleValidator
extends AbstractValidator {
    private final List<String> compareList = new ArrayList<String>(Arrays.asList("=", "A", "F"));

    public void validate() {
        block0: for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkRuleFiled(entity);
            Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
            boolean isAggregate = (Boolean)aggregateCfg.get("isAggregate");
            boolean compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
            if (!isAggregate || !compatibleDetail || entity.getDataEntity().getBoolean("ispredict")) continue;
            List aggregateFieldList = (List)aggregateCfg.get("aggregateField");
            DynamicObject billObj = entity.getDataEntity();
            Long pkValue = (Long)billObj.getPkValue();
            StringBuilder sql = new StringBuilder();
            sql.append("select a.f_number, a.faggregate,b.f_strategy_id from t_msmod_reserve_scheme a join ").append("t_scheme_strategy b on a.fid = b.fid  where b.f_strategy_id in(").append("select c.fid from t_msmod_stragtegy c join t_scheme_ruleentry d on c.fid=d.fid where d.f_pick_inv_rule_id = ").append(pkValue).append(") ");
            DataSet dataSet = this.DBQueryDataSet(sql);
            boolean hasDetailScheme = false;
            while (dataSet.hasNext()) {
                if (dataSet.next().getBoolean("faggregate").booleanValue()) continue;
                hasDetailScheme = true;
            }
            if (!hasDetailScheme) continue;
            DynamicObjectCollection ruleEntryList = billObj.getDynamicObjectCollection("rule_entry");
            for (String field : aggregateFieldList) {
                boolean isFind = false;
                for (DynamicObject ruleRow : ruleEntryList) {
                    if (!this.compareList.contains(ruleRow.getString("compare_type")) || !field.equals(ruleRow.getString("std_inv_col_no"))) continue;
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                String msg = ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\uff0c\u9884\u7559\u89c4\u5219\u5df2\u88ab\u660e\u7ec6\u9884\u7559\u65b9\u6848\u5f15\u7528\uff0c\u975e\u9884\u8ba1\u5165\u9884\u7559\u89c4\u5219\u9700\u8981\u914d\u7f6e\u6240\u6709\u603b\u91cf\u9884\u7559\u7ef4\u5ea6\u7684\u4f9b\u9700\u5339\u914d\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u89c4\u5219\u3002", (String)"ReserveInvRuleValidator_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                this.addMessage(entity, msg, ErrorLevel.Error);
                continue block0;
            }
        }
    }

    private DataSet DBQueryDataSet(StringBuilder sql) {
        return DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
    }

    private void checkRuleFiled(ExtendedDataEntity entity) {
        DynamicObject billObj = entity.getDataEntity();
        DynamicObjectCollection ruleEntryList = billObj.getDynamicObjectCollection("rule_entry");
        Map<String, String> balColMap = ColsMapHelper.findBillColMaps(entity.getDataEntity().get("supsrcobj.id").toString(), "msmod_std_inv_field").getBalColMap();
        String materiel = balColMap.get("materiel");
        String billEntry = balColMap.get("billentry");
        if (materiel != null) {
            String[] materielArray = materiel.split("\\.");
            for (DynamicObject ruleRow : ruleEntryList) {
                String requireBillCol;
                int seq = (Integer)ruleRow.get("seq");
                String compareType = ruleRow.getString("compare_type");
                if (("=".equals(compareType) || ">".equals(compareType) || "<".equals(compareType)) && ("".equals(requireBillCol = ruleRow.getString("require_bill_col")) || requireBillCol == null)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9884\u7559\u89c4\u5219\u201d\u7b2c%1$s\u884c\u201c\u53d6\u503c\u65b9\u5f0f\u201d\u3002", (String)"ReserveInvRuleValidator_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), seq));
                }
                String supCol = balColMap.get(ruleRow.getString("std_inv_col_no"));
                if (materielArray.length != 1 || billEntry == null || supCol == null || !supCol.startsWith(billEntry)) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u9884\u7559\u7684\u7269\u6599\u662f\u5355\u5934\u5b57\u6bb5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5355\u636e\u4f53\uff08\u5206\u5f55\uff09\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u6620\u5c04\u914d\u7f6e\u3002", (String)"RuleEngine_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        }
    }
}

