/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.strategy.StrategyEngine;

public class ReserveStrategyValidator
extends AbstractValidator {
    private final List<String> compareList = new ArrayList<String>(Arrays.asList("=", "A", "F"));

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billObj = entity.getDataEntity();
            DynamicObjectCollection entryList = billObj.getDynamicObjectCollection("rule_entry");
            if (entryList == null) continue;
            Long pkValue = (Long)entity.getDataEntity().getPkValue();
            StringBuilder sql = new StringBuilder();
            sql.append("select a.f_number, a.faggregate,b.f_strategy_id from t_msmod_reserve_scheme a left join ").append("t_scheme_strategy b on a.fid = b.fid where b.f_strategy_id = ").append(pkValue);
            DataSet dataSet = this.DBQueryDataSet(sql);
            this.checkSchemeDetail(entity, entryList, dataSet);
        }
    }

    private DataSet DBQueryDataSet(StringBuilder sql) {
        return DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
    }

    private void checkSchemeDetail(ExtendedDataEntity entity, DynamicObjectCollection entryList, DataSet dataSet) {
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        boolean isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        List aggregateField = (List)aggregateCfg.get("aggregateField");
        boolean compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
        boolean hasDetailScheme = false;
        while (dataSet.hasNext()) {
            if (dataSet.next().getBoolean("faggregate").booleanValue()) continue;
            hasDetailScheme = true;
        }
        if (isAggregate && compatibleDetail && hasDetailScheme) {
            Map<Object, DynamicObject> ruleMap = StrategyEngine.getRuleMap(entryList);
            for (DynamicObject rule : ruleMap.values()) {
                if (rule.getBoolean("ispredict")) continue;
                DynamicObjectCollection ruleEntryList = rule.getDynamicObjectCollection("rule_entry");
                for (String field : aggregateField) {
                    boolean isFind = false;
                    for (DynamicObject ruleRow : ruleEntryList) {
                        if (!this.compareList.contains(ruleRow.getString("compare_type")) || !field.equals(ruleRow.getString("std_inv_col_no"))) continue;
                        isFind = true;
                        break;
                    }
                    if (isFind) continue;
                    String msg = ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\uff0c\u9884\u7559\u7b56\u7565\u88ab\u660e\u7ec6\u9884\u7559\u65b9\u6848\u5f15\u7528\uff0c\u975e\u9884\u8ba1\u5165\u9884\u7559\u89c4\u5219\u9700\u8981\u914d\u7f6e\u6240\u6709\u603b\u91cf\u9884\u7559\u7ef4\u5ea6\u7684\u4f9b\u9700\u5339\u914d\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u89c4\u5219\u3002", (String)"ReserveStrategyValidator_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                    this.addMessage(entity, msg, ErrorLevel.Error);
                    return;
                }
            }
        }
    }
}

