/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ReserveDataUpgradeServiceImpl
implements IUpgradeService {
    private final DBRoute scmRoute = new DBRoute("scm");
    private static final String[] sqlFileds = new String[]{"FNUMBER", "F_SOURCE_BILL AS FSOURCEBILL", "F_TARGET_OBJ AS FTARGETOBJ", "FCREATORID AS FCREATERID", "FCREATETIME AS FCREATEDATE", "FMODIFIERID", "FMODIFYTIME AS FMODIFYDATE", "FENABLE AS FISENABLE", "'0ZACM0PE=J24' AS FBIZAPPID"};
    private static final String[] sqlEntryFileds = new String[]{"FID", "FSEQ", "F_TARGET_COL_NAME AS FTARGETOBJCOLNO", "F_TARGET_COL AS FTARGETOBJCOL", "F_SOURCE_COL_NAME AS FSOURCEBILLCOLNO", "F_SOURCE_COL AS FSOURCEBILLCOL"};
    private static final String[] sqlLFileds = new String[]{"FID", "FLOCALEID", "FNAME"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.reserveSchemeUp();
        this.reserveRuleUp();
        this.mapCfgUp();
        this.reserveRecodrUp();
        result.setSuccess(true);
        return result;
    }

    private void reserveRecodrUp() {
        String supSql = "update t_msmod_reserverecord set fbalentryid = f_bal_id where 1=1";
        DB.execute((DBRoute)this.scmRoute, (String)supSql);
    }

    private void mapCfgUp() {
        String supSql = "select fid from t_sbs_billfieldmap where ftargetobj = 'msmod_std_inv_field' and fid not in(1165019949589434368,1225328658986566656,1292127761950835712)";
        String delSql = "delete t_sbs_billfieldmap where fid  in ";
        String delESql = "delete t_sbs_billfieldmap_e where fid  in";
        DataSet supCfgData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.scmRoute, (String)supSql);
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (supCfgData.hasNext()) {
            Row next = supCfgData.next();
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append(next.get("fid").toString());
        }
        sb.append(" )");
        String subSql = sb.toString();
        if (i > 0) {
            DB.execute((DBRoute)this.scmRoute, (String)(delSql + subSql));
            DB.execute((DBRoute)this.scmRoute, (String)(delESql + subSql));
        }
        this.reserveMapUp();
    }

    private void reserveMapUp() {
        String algoKey = this.getClass().getName();
        String fSql = "SELECT FID FROM  T_MSMOD_FIELD_MAPPING WHERE F_TARGET_OBJ = 'msmod_std_request_bill' ";
        DataSet fids = DB.queryDataSet((String)algoKey, (DBRoute)this.scmRoute, (String)fSql);
        ArrayList<Long> oldIds = new ArrayList<Long>(16);
        StringBuilder sbF = new StringBuilder(" FID IN ( ");
        int i = 0;
        while (fids.hasNext()) {
            Row row = fids.next();
            if (i > 0) {
                sbF.append(" ,");
            }
            sbF.append(row.get("FID"));
            oldIds.add(row.getLong("FID"));
            ++i;
        }
        if (i == 0) {
            return;
        }
        sbF.append(" )");
        String filter = sbF.toString();
        long[] ids = DB.genLongIds((String)"T_SBS_BILLFIELDMAP", (int)oldIds.size());
        this.excuteMapSql(sqlFileds, "T_MSMOD_FIELD_MAPPING", "T_SBS_BILLFIELDMAP", filter, "FID", ids);
        this.excuteMapSql(sqlEntryFileds, "T_MSMOD_FIELDS", "T_SBS_BILLFIELDMAP_E", filter, "FENTRYID", null);
        this.excuteMapSql(sqlLFileds, "T_MSMOD_FIELD_MAPPING_L", "T_SBS_BILLFIELDMAP_L", filter, "FPKID", null);
        ArrayList<Object[]> fidParams = new ArrayList<Object[]>(oldIds.size());
        for (int j = 0; j < oldIds.size(); ++j) {
            Object[] pIds = new Object[]{ids[j], oldIds.get(j)};
            fidParams.add(pIds);
        }
        DB.executeBatch((DBRoute)this.scmRoute, (String)"UPDATE T_SBS_BILLFIELDMAP_E set fid = ? where fid = ?", fidParams);
        DB.executeBatch((DBRoute)this.scmRoute, (String)"UPDATE T_SBS_BILLFIELDMAP_L set fid = ? where fid = ?", fidParams);
    }

    private void excuteMapSql(String[] fields, String srcTable, String tarTable, String filter, String pKey, long[] ids) {
        int i;
        StringBuilder sel = new StringBuilder("SELECT ");
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (i2 > 0) {
                sel.append(" ,");
            }
            sel.append(fields[i2]);
        }
        sel.append(" FROM ").append(srcTable).append(" WHERE ").append(filter);
        DataSet oldData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.scmRoute, (String)sel.toString());
        Field[] newFields = oldData.getRowMeta().getFields();
        int paramLenth = newFields.length + 1;
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        while (oldData.hasNext()) {
            Row row = oldData.next();
            Object[] obj = new Object[paramLenth];
            for (int i3 = 1; i3 < paramLenth; ++i3) {
                obj[i3] = row.get(newFields[i3 - 1].getName());
            }
            params.add(obj);
        }
        if (ids == null) {
            ids = DB.genLongIds((String)tarTable, (int)params.size());
        }
        for (int i4 = 0; i4 < params.size(); ++i4) {
            ((Object[])params.get((int)i4))[0] = ids[i4];
        }
        StringBuilder inSql = new StringBuilder(" INSERT INTO ");
        inSql.append(tarTable).append(" ( ").append(pKey).append(" , ");
        for (i = 0; i < newFields.length; ++i) {
            if (i > 0) {
                inSql.append(" ,");
            }
            inSql.append(newFields[i].getName());
        }
        inSql.append(" ) VALUES ( ? ");
        for (i = 0; i < newFields.length; ++i) {
            inSql.append(" , ? ");
        }
        inSql.append(" ) ");
        DB.executeBatch((DBRoute)this.scmRoute, (String)inSql.toString(), params);
    }

    private void reserveRuleUp() {
        String strategySql = "select t1.f_pick_inv_rule_id, t.f_require_bill_id from t_msmod_stragtegy t inner join t_scheme_ruleentry t1 on t.fid = t1.fid";
        DataSet strategys = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.scmRoute, (String)strategySql);
        String ruleSql = "update t_msmod_reserve_rule set fdemandsrcobj = ?  where fid = ?";
        String ruleSql1 = "update t_msmod_reserve_rule set fsupsrcobj = 'im_inv_realbalance'";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        while (strategys.hasNext()) {
            Object[] requireParam = new Object[2];
            Row row = strategys.next();
            requireParam[0] = row.get("f_require_bill_id");
            requireParam[1] = row.get("f_pick_inv_rule_id");
            if (params.size() > 1000) {
                this.executeRuleSql(ruleSql, params);
                params.clear();
            }
            params.add(requireParam);
        }
        if (params.size() > 0) {
            this.executeRuleSql(ruleSql, params);
        }
        DB.execute((DBRoute)this.scmRoute, (String)ruleSql1);
    }

    private void executeRuleSql(String ruleSql, List<Object[]> params) {
        DB.executeBatch((DBRoute)this.scmRoute, (String)ruleSql, params);
    }

    private void reserveSchemeUp() {
        String sql = "update t_msmod_reserve_scheme set fautoreserve = '1' ,f_data_status = 'A'";
        String sql1 = "update t_msmod_reserve_scheme set fsupdiff = 'A' where f_result_handler in ('2','6')";
        String sql2 = "update t_msmod_reserve_scheme set fsupdiff = 'B' where f_result_handler in ('1','3','4')";
        DB.execute((DBRoute)this.scmRoute, (String)sql);
        DB.execute((DBRoute)this.scmRoute, (String)sql1);
        DB.execute((DBRoute)this.scmRoute, (String)sql2);
    }
}

