/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.mpscmm.msbd.reserve.business.helper.ReserveRecordDataSetHelper;

public class ReserveRecordUpgradeNewServiceImpl
implements IUpgradeService {
    private static int SNSET_LIMIT_CHECK = 2000;
    private static Log logger = LogFactory.getLog(ReserveRecordUpgradeNewServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            List<QFilter> getRecordFilter = this.getRecordFilter();
            ReserveRecordDataSetHelper helper = new ReserveRecordDataSetHelper();
            DataSet dataSet = helper.getReserveRecordInfo(getRecordFilter);
            this.upGradeReserveRecord(dataSet);
            result.setSuccess(true);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return result;
    }

    private List<QFilter> getRecordFilter() {
        ArrayList<QFilter> recordFilters = new ArrayList<QFilter>(16);
        recordFilters.add(new QFilter("base_qty", "<>", (Object)BigDecimal.ZERO).or(new QFilter("qty", "<>", (Object)BigDecimal.ZERO)));
        return recordFilters;
    }

    private void upGradeReserveRecord(DataSet reserveRecord) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(SNSET_LIMIT_CHECK);
        String sql = "update t_msmod_reserverecord set f_r_customer = ?, f_r_biz_date = ?, f_r_invorg = ?, f_r_sale_dept = ?, f_r_sale_operator = ?, f_r_sale_org = ?, f_s_unit2nd = ?, f_s_entryseq = ?, f_s_invstatus = ?, f_s_configuredcode = ?, f_s_keeper_type = ?, f_s_project = ?, f_s_owner_type = ?, f_s_billnum = ?, f_s_keeper = ?, f_s_location = ?, f_s_lotnum = ?, f_s_baseunit = ?, f_s_materiel = ?,  f_s_invtype = ?, f_s_org = ?, f_s_auxpty = ?, f_s_warehouse = ?, f_s_owner = ?, f_s_unit = ? where fid = ?";
        while (reserveRecord.hasNext()) {
            Row row = reserveRecord.next();
            Object[] object = new Object[]{row.get("r_customer") == null ? Long.valueOf(0L) : row.get("r_customer"), row.get("r_biz_date"), row.get("r_invorg") == null ? Long.valueOf(0L) : row.get("r_invorg"), row.get("r_sale_dept") == null ? Long.valueOf(0L) : row.get("r_sale_dept"), row.get("r_sale_operator") == null ? Long.valueOf(0L) : row.get("r_sale_operator"), row.get("r_sale_org") == null ? Long.valueOf(0L) : row.get("r_sale_org"), row.get("s_unit2nd") == null ? Long.valueOf(0L) : row.get("s_unit2nd"), row.get("s_entryseq") == null ? Long.valueOf(0L) : row.get("s_entryseq"), row.get("s_invstatus") == null ? Long.valueOf(0L) : row.get("s_invstatus"), row.get("s_configuredcode") == null ? Long.valueOf(0L) : row.get("s_configuredcode"), row.get("s_keeper_type") == null ? "" : row.get("s_keeper_type"), row.get("s_project") == null ? Long.valueOf(0L) : row.get("s_project"), row.get("s_owner_type") == null ? "" : row.get("s_owner_type"), row.get("s_billnum") == null ? "" : row.get("s_billnum"), row.get("s_keeper") == null ? Long.valueOf(0L) : row.get("s_keeper"), row.get("s_location") == null ? Long.valueOf(0L) : row.get("s_location"), row.get("s_lotnum") == null ? "" : row.get("s_lotnum"), row.get("s_baseunit") == null ? Long.valueOf(0L) : row.get("s_baseunit"), row.get("s_materiel") == null ? Long.valueOf(0L) : row.get("s_materiel"), row.get("s_invtype") == null ? Long.valueOf(0L) : row.get("s_invtype"), row.get("s_org") == null ? Long.valueOf(0L) : row.get("s_org"), row.get("s_auxpty") == null ? Long.valueOf(0L) : row.get("s_auxpty"), row.get("s_warehouse") == null ? Long.valueOf(0L) : row.get("s_warehouse"), row.get("s_owner") == null ? Long.valueOf(0L) : row.get("s_owner"), row.get("s_unit") == null ? Long.valueOf(0L) : row.get("s_unit"), row.get("reserveid")};
            if (paramList.size() >= SNSET_LIMIT_CHECK) {
                this.DBMathod(paramList, sql);
                paramList.clear();
            }
            paramList.add(object);
        }
        if (!paramList.isEmpty()) {
            this.DBMathod(paramList, sql);
        }
    }

    private void DBMathod(List<Object[]> paramList, String sql) {
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramList);
    }
}

