/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.webapi;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class AutoReserveApiService
extends AbstractBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        super.doCustomService(params);
        LinkedHashMap data = (LinkedHashMap)params.get("data");
        String formId = (String)data.get("formid");
        Object[] billIds = (Long[])data.get("billids");
        if (StringUtils.isBlank((CharSequence)formId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u53c2\u6570formid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoReserveApiService_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        if (billIds == null || billIds.length == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u53c2\u6570billIds\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoReserveApiService_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        Map bills = BusinessDataServiceHelper.loadFromCache((Object[])billIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)formId));
        if (bills.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u9700\u8981\u9884\u7559\u7684\u5355\u636e\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AutoReserveApiService_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        String result = this.reserveBills(bills.values());
        return ApiResult.success((Object)result);
    }

    private String reserveBills(Collection<DynamicObject> bills) {
        try (TraceSpan batchSpan = Tracer.create((String)"AutoReserveApiService", (String)"reserveBills");){
            ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
            ArrayList resultList = new ArrayList(bills.size());
            bills.forEach(originalRequestBill -> resultList.add(ReserveService.reserveByBill(originalRequestBill)));
            String string = JSON.toJSONString(resultList);
            return string;
        }
    }
}

