/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.webapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.record.RecordReleaseModle;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;

public class ReleaseReserveApiService
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(ReleaseReserveApiService.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        super.doCustomService(params);
        LinkedHashMap data = (LinkedHashMap)params.get("data");
        String formId = (String)data.get("formid");
        List billIds = (List)data.get("billids");
        if (StringUtils.isBlank((CharSequence)formId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u53c2\u6570formid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoReserveApiService_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        if (billIds == null || billIds.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u53c2\u6570billIds\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoReserveApiService_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
        ThreadCache.put((Object)"ReserveOpType", (Object)"release2");
        this.releaseReserve(formId, billIds);
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6210\u529f\u3002", (String)"ReleaseReserveApiService_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
    }

    private void releaseReserve(String formId, List<Object> billIds) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReleaseReserveApiService", (String)"releaseReserve");){
            QFilter fs = new QFilter("release_bill", "=", (Object)formId);
            fs.and("enable", "=", (Object)"1");
            DynamicObject releaseRule = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_release_rule", (QFilter[])fs.toArray());
            if (releaseRule == null) {
                return;
            }
            Object pkValue = releaseRule.getPkValue();
            QFilter qFilter = new QFilter("id", "=", pkValue);
            DataSet releaseRuleDataSet = QueryServiceHelper.queryDataSet((String)ReleaseReserveApiService.class.getName(), (String)"msmod_release_rule", (String)"entryentity.releasetype as releasetype,entryentity.priority as priority", (QFilter[])qFilter.toArray(), null);
            Map releaseBill = BusinessDataServiceHelper.loadFromCache((Object[])billIds.toArray(), (String)formId);
            RecordReleaseModle releaseModle = RecordReleaseModle.getInstance(formId, ReleaseReserveApiService.getValidateReleaseIdList(billIds, releaseRule, releaseBill), releaseRule);
            ReserveRecordHandler.reserveReleaseQty(releaseModle.matchReleaseRecord(releaseRuleDataSet));
        }
    }

    private static List<Object> getValidateReleaseIdList(List<Object> ids, DynamicObject releaseRule, Map<Object, DynamicObject> releaseBill) {
        String schemeFilterStr = releaseRule.getString("filter_value_tag");
        ArrayList<Object> realIdList = new ArrayList<Object>(ids.size());
        for (Object id : ids) {
            try {
                if (!FilterParser.execExcelFormula(schemeFilterStr, releaseBill.get(id))) continue;
                realIdList.add(id);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                realIdList.add(id);
            }
        }
        return realIdList;
    }
}

