/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.mpscmm.msbd.algorithm.business.helper.PreinBillMappingHelper;
import kd.mpscmm.msbd.algorithm.model.bill.CalBillModelConfig;

public class BillMappingCache {
    private final Map<String, Map<String, Map<String, String>>> billMaps = new HashMap<String, Map<String, Map<String, String>>>(16);
    private final Map<String, Map<String, CalBillModelConfig>> billConfig = new HashMap<String, Map<String, CalBillModelConfig>>(16);
    private static volatile BillMappingCache instance = null;

    private BillMappingCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BillMappingCache getInstance() {
        if (instance != null) return instance;
        Class<BillMappingCache> clazz = BillMappingCache.class;
        synchronized (BillMappingCache.class) {
            if (instance != null) return instance;
            instance = BillMappingCache.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static BillMappingCache build() {
        BillMappingCache cache = new BillMappingCache();
        cache.loadMappingInfo();
        return cache;
    }

    public CalBillModelConfig getModelConfig(String entity, String entrykey) {
        Map<String, CalBillModelConfig> map = this.billConfig.get(entity);
        if (map == null) {
            return null;
        }
        return map.get(entrykey);
    }

    public Map<String, String> getBillFields(String entity, String billKey) {
        Map<String, String> fieldInfos;
        Map<String, Map<String, String>> entryToField = this.billMaps.get(entity);
        if (entryToField != null && (fieldInfos = entryToField.get(billKey)) != null) {
            return new HashMap<String, String>(fieldInfos);
        }
        return Collections.emptyMap();
    }

    public Map<String, Set<String>> getAllBillModelFields() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Map<String, Map<String, String>>> entrySet : this.billMaps.entrySet()) {
            String entity = entrySet.getKey();
            HashSet<String> fields = new HashSet<String>(16);
            for (Map<String, String> modelFields : entrySet.getValue().values()) {
                fields.addAll(modelFields.keySet());
            }
            result.put(entity, fields);
        }
        return result;
    }

    private void loadMappingInfo() {
        Map<String, Map<String, Map<String, String>>> preinMappingInfo = PreinBillMappingHelper.getPreinMappingInfo();
        this.billMaps.putAll(preinMappingInfo);
        for (Map.Entry<String, Map<String, Map<String, String>>> billMap : this.billMaps.entrySet()) {
            String billEntity = billMap.getKey();
            Map<String, Map<String, String>> entryKeyToMapInfos = billMap.getValue();
            HashMap<String, CalBillModelConfig> billConfigs = new HashMap<String, CalBillModelConfig>(entryKeyToMapInfos.size());
            for (Map.Entry<String, Map<String, String>> entryKeyToMapInfo : entryKeyToMapInfos.entrySet()) {
                String entryKey = entryKeyToMapInfo.getKey();
                Map<String, String> billMapInfo = entryKeyToMapInfo.getValue();
                CalBillModelConfig billConfig = new CalBillModelConfig(billEntity, billMapInfo);
                billConfigs.put(entryKey, billConfig);
            }
            this.billConfig.put(billEntity, billConfigs);
        }
    }
}

