/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.factory;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.algorithm.lang.ModelLang;
import kd.mpscmm.msbd.algorithm.model.bill.FieldInfo;

public class FieldInfoFactory {
    public static FieldInfo getFieldInfo(MainEntityType entityType, String fieldKey) {
        DecimalProp decimalProp;
        String controlPropName;
        IDataEntityProperty property = entityType.findProperty(fieldKey);
        FieldInfo info = FieldInfoFactory.buildFieldInfo(entityType, fieldKey, property);
        if (property instanceof DecimalProp && StringUtils.isNotEmpty((CharSequence)(controlPropName = (decimalProp = (DecimalProp)property).getControlPropName()))) {
            IDataEntityProperty controlProp = entityType.findProperty(controlPropName);
            info.setControlFieldInfo(FieldInfoFactory.buildFieldInfo(entityType, controlPropName, controlProp));
            if (property instanceof QtyProp) {
                info.setFieldProp("qty");
            } else if (property instanceof PriceProp) {
                info.setFieldProp("price");
            } else if (property instanceof AmountProp) {
                info.setFieldProp("amount");
            }
        }
        return info;
    }

    private static FieldInfo buildFieldInfo(MainEntityType entityType, String fieldKey, IDataEntityProperty property) {
        if (property == null) {
            throw new KDBizException(ModelLang.fieldNotExist(entityType, fieldKey));
        }
        if (property.getParent() instanceof SubEntryType) {
            return FieldInfo.subEntryField(fieldKey);
        }
        if (property.getParent() instanceof EntryType) {
            return FieldInfo.entryField(fieldKey);
        }
        return FieldInfo.headField(fieldKey);
    }
}

