/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.common.entity;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msbd.algorithm.business.mapper.PrecisionMapper;
import kd.mpscmm.msbd.algorithm.common.utils.DynamicObjectUtils;
import kd.mpscmm.msbd.algorithm.model.bill.CalBillModelConfig;
import kd.mpscmm.msbd.algorithm.model.bill.FieldInfo;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalBillModel;

public class EntryPrecInfo {
    private CalBillModelConfig config;
    private PrecisionMapper precisionMapper = new PrecisionMapper();
    private Set<String> fieldInfos = new HashSet<String>(16);
    private Map<Long, DynamicObject> unitInfos = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObject> currencyInfos = new HashMap<Long, DynamicObject>(16);

    public EntryPrecInfo(CalBillModelConfig config, Set<String> fieldInfos) {
        this.config = config;
        this.fieldInfos = fieldInfos;
    }

    public void addPrecisionDataInfo(DynamicObject entry) {
        for (String modelKey : this.fieldInfos) {
            FieldInfo controlFieldInfo;
            DynamicObject controlValue;
            FieldInfo fieldInfo = this.config.getFieldInfoByModelKey(modelKey);
            if (fieldInfo == null || fieldInfo.getControlFieldInfo() == null || (controlValue = DynamicObjectUtils.getValueFromEntry(entry, controlFieldInfo = fieldInfo.getControlFieldInfo())) == null) continue;
            String controlValueType = controlValue.getDataEntityType().getName();
            if ("bd_measureunits".equals(controlValueType)) {
                this.unitInfos.put(controlValue.getLong("id"), controlValue);
                continue;
            }
            if (!"bd_currency".equals(controlValueType)) continue;
            this.currencyInfos.put(controlValue.getLong("id"), controlValue);
        }
    }

    public void loadPrecision() {
        this.precisionMapper.load("qty", this.unitInfos.values());
        this.precisionMapper.load("price", this.currencyInfos.values());
        this.precisionMapper.load("amount", this.currencyInfos.values());
    }

    public Object handleResultPrecision(ICalBillModel billModel, String targetField, Object value) {
        FieldInfo fieldInfo = this.config.getFieldInfoByModelKey(targetField);
        if (fieldInfo == null) {
            return value;
        }
        FieldInfo controlFieldInfo = fieldInfo.getControlFieldInfo();
        if (controlFieldInfo != null) {
            String fieldProp = fieldInfo.getFieldProp();
            Integer precision = null;
            DynamicObject controlObj = (DynamicObject)billModel.getValue(controlFieldInfo.getFieldKey());
            if (controlObj == null) {
                return value;
            }
            if ("price".equals(fieldProp)) {
                precision = this.precisionMapper.get("price", controlObj.getLong("id"));
            } else if ("amount".equals(fieldProp)) {
                precision = this.precisionMapper.get("amount", controlObj.getLong("id"));
            } else if ("qty".equals(fieldProp)) {
                precision = this.precisionMapper.get("qty", controlObj.getLong("id"));
            }
            if (precision != null) {
                value = ((BigDecimal)value).setScale((int)precision, 4);
            }
        }
        return value;
    }
}

