/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.form;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.algorithm.business.cache.BillMappingCache;
import kd.mpscmm.msbd.algorithm.business.cache.CalculateExprLocalCache;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;
import kd.mpscmm.msbd.algorithm.form.AbstractMSBDFormPlugin;
import kd.mpscmm.msbd.algorithm.lang.ModelLang;
import kd.mpscmm.msbd.algorithm.model.AlgorithmExecutor;
import kd.mpscmm.msbd.algorithm.model.bill.CalBillModelConfig;
import kd.mpscmm.msbd.algorithm.model.bill.impl.MappingBillEntryModel;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class AlgorithmValidationFormEdit
extends AbstractMSBDFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                QFilter filter = new QFilter("id", "in", BillMappingCache.getInstance().getAllBillModelFields().keySet());
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.getListFilterParameter().setFilter(filter);
            }
        }, "billobj");
        this.addClickListeners(new String[]{"billno", "executerange"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("billno".equals(key)) {
            String billType = ((DynamicObject)this.getValue("billobj")).getString("number");
            ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)billType, (boolean)false);
            basedataF7Param.setMultiSelect(false);
            basedataF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billNoSelectF7"));
            basedataF7Param.getListFilterParameter().setFilter(new QFilter("billno", "=", (Object)"CGRK-231120-000001"));
            this.getView().showForm((FormShowParameter)basedataF7Param);
        } else if ("executerange".equals(key)) {
            String billType = ((DynamicObject)this.getValue("billobj")).getString("number");
            String entryKey = this.getStrValue("entrykey");
            String changeProp = this.getStrValue("changeprop");
            String billId = this.getStrValue("billid");
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(billId), (String)billType);
            if (billObj == null) {
                throw new KDBizException("bill not exist!");
            }
            CalBillModelConfig config = BillMappingCache.getInstance().getModelConfig(billType, entryKey);
            String changeModelProp = config.getModelFieldBySrcField(changeProp);
            if (changeModelProp == null) {
                throw new KDBizException(ModelLang.notConfigProp(changeProp));
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billType);
            IDataEntityProperty property = entityType.findProperty(changeProp);
            DynamicObject fristEntry = (DynamicObject)billObj.getDynamicObjectCollection(entryKey).get(0);
            Object changeValue = this.getChangeValue(property);
            if (changeValue != null) {
                if (property.getParent() == null) {
                    property.setValueFast((Object)fristEntry, (Object)billObj);
                } else {
                    property.setValueFast((Object)fristEntry, changeValue);
                }
            }
            MappingBillEntryModel entryModel = new MappingBillEntryModel(config, billType, fristEntry);
            List<ICalculateExpr> sortedExprs = CalculateExprLocalCache.getInstance().getBillCalExprsByRealTime(entryModel, changeModelProp);
            AlgorithmExecutor executor = new AlgorithmExecutor(sortedExprs);
            Map<String, Object> doCalculate = executor.doCalculate(entryModel);
            this.getModel().deleteEntryData("rangecalexpr");
            for (ICalculateExpr expr : sortedExprs) {
                int i = this.getModel().createNewEntryRow("rangecalexpr");
                this.getModel().setValue("tgtfield", (Object)expr.getTargetField(), i);
                this.getModel().setValue("tgtcalexpr", (Object)expr.toString(), i);
                this.getModel().setValue("targetvalue", doCalculate.get(expr.getTargetField()), i);
            }
            List<Map<String, Object>> batchEntryCalculate = AlgorithmHelper.batchEntryCalculate(billType, Collections.singletonList(fristEntry), changeProp);
            this.getView().showMessage(batchEntryCalculate.toString());
        }
    }

    private Object getChangeValue(IDataEntityProperty property) {
        Object changeValue = null;
        String value = (String)this.getValue("changevalue");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        changeValue = property instanceof DecimalProp ? new BigDecimal(value) : value;
        return changeValue;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("billobj".equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            MainEntityType entry = EntityMetadataCache.getDataEntityType((String)newValue.getString("number"));
            Map allEntities = entry.getAllEntities();
            HashMap<String, LocaleString> comboValues = new HashMap<String, LocaleString>(16);
            for (EntityType entity : allEntities.values()) {
                if (!entity.getClass().equals(EntryType.class)) continue;
                comboValues.put(entity.getName(), entity.getDisplayName());
            }
            this.setComboValues("entrykey", comboValues);
        } else if ("entrykey".equals(name)) {
            String entrykey = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((CharSequence)entrykey)) {
                return;
            }
            String billType = ((DynamicObject)this.getValue("billobj")).getString("number");
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            HashMap<String, LocaleString> comboValues = new HashMap<String, LocaleString>(16);
            Map<String, String> fieldInfos = BillMappingCache.getInstance().getBillFields(billType, entrykey);
            for (Map.Entry<String, String> infoEntry : fieldInfos.entrySet()) {
                IDataEntityProperty property = billEntityType.findProperty(infoEntry.getValue());
                comboValues.put(property.getName(), property.getDisplayName());
            }
            this.setComboValues("changeprop", comboValues);
        } else if ("billno".equals(name)) {
            String billno = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject object = QueryServiceHelper.queryOne((String)((DynamicObject)this.getValue("billobj")).getString("number"), (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            if (object == null) {
                throw new KDBizException("bill not exsit!");
            }
            this.getModel().setValue("billid", object.get("id"));
        }
        super.propertyChanged(e);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "billNoSelectF7": {
                this.billNoSelectF7(e.getReturnData());
                break;
            }
        }
    }

    private void billNoSelectF7(Object returnObj) {
        if (returnObj == null) {
            return;
        }
        ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnObj;
        if (selectRows.isEmpty()) {
            return;
        }
        this.getModel().setValue("billno", (Object)selectRows.get(0).getBillNo());
    }
}

