/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.bill;

import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.algorithm.business.factory.FieldInfoFactory;
import kd.mpscmm.msbd.algorithm.lang.ModelLang;
import kd.mpscmm.msbd.algorithm.model.bill.FieldInfo;

public class CalBillModelConfig {
    private String billEntity = null;
    private Map<String, FieldInfo> billFieldMapping = new HashMap<String, FieldInfo>(16);

    public CalBillModelConfig(String billEntity, Map<String, String> billMapping) {
        this.initBillMappingInfo(billEntity, billMapping);
    }

    private void initBillMappingInfo(String billEntity, Map<String, String> billMapping) {
        this.billEntity = billEntity;
        if (billMapping == null) {
            throw new KDBizException(ModelLang.notConfigBill(billEntity));
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        for (Map.Entry<String, String> entryInfo : billMapping.entrySet()) {
            String modelKey = entryInfo.getKey();
            String fieldKey = entryInfo.getValue();
            FieldInfo fieldInfo = FieldInfoFactory.getFieldInfo(entityType, fieldKey);
            this.billFieldMapping.put(modelKey, fieldInfo);
        }
    }

    public String getModelFieldBySrcField(String sourceField) {
        for (Map.Entry<String, FieldInfo> mapEntry : this.billFieldMapping.entrySet()) {
            if (!mapEntry.getValue().getFieldKey().equals(sourceField)) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    public FieldInfo getFieldInfoByModelKey(String modelKey) {
        FieldInfo fieldInfo = this.billFieldMapping.get(modelKey);
        return fieldInfo;
    }

    public String getBillEntity() {
        return this.billEntity;
    }
}

