/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.mpscmm.msbd.algorithm.model.expr.impl.AbstractCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.ConditionCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.ConstsCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.FormulaCalculateExpr;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class MulCondtionCalculateExpr
extends AbstractCalculateExpr {
    private ICalculateExpr defaultExpr = null;
    private List<ConditionCalculateExpr> conditons = new ArrayList<ConditionCalculateExpr>(16);

    public MulCondtionCalculateExpr(String targetField) {
        super(targetField);
    }

    public MulCondtionCalculateExpr(String targetField, Map<String, ICalculateExpr> exprs) {
        super(targetField);
        for (Map.Entry<String, ICalculateExpr> exprEntry : exprs.entrySet()) {
            this.addConditionExpr(exprEntry.getKey(), exprEntry.getValue());
        }
    }

    public void addConditionExpr(String condition, String formulaExpr) {
        FormulaCalculateExpr expr = FormulaCalculateExpr.create(this.getTargetField(), formulaExpr);
        this.addConditionExpr(condition, expr);
    }

    public final void addConditionExpr(String condition, ICalculateExpr expr) {
        this.conditons.add(ConditionCalculateExpr.create(this.getTargetField(), condition, expr));
    }

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>(16);
        for (ConditionCalculateExpr condition : this.conditons) {
            factors.addAll(condition.getCalFactors());
        }
        if (this.defaultExpr != null) {
            factors.addAll(this.defaultExpr.getCalFactors());
        }
        return factors;
    }

    public Object calculate(Map<String, Object> billInfo) {
        for (ConditionCalculateExpr condition : this.conditons) {
            if (!condition.isMatch(billInfo).booleanValue()) continue;
            return condition.calculate(billInfo);
        }
        if (this.defaultExpr != null) {
            return this.defaultExpr.calculate(billInfo);
        }
        return null;
    }

    public void setDefaultValue(Object defValue) {
        this.setDefaultExpr(new ConstsCalculateExpr(this.getTargetField(), defValue));
    }

    public void setDefaultExpr(String expr) {
        this.setDefaultExpr(FormulaCalculateExpr.create(this.getTargetField(), expr));
    }

    public void setDefaultExpr(ICalculateExpr defaultExpr) {
        this.defaultExpr = defaultExpr;
    }

    public String toString() {
        return this.conditons.toString();
    }
}

