/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl.purin;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class DeductibleRateExpr
implements ICalculateExpr {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private static final Long PROFORMA_INVOICE_BIZ = 1571047306646894592L;

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>(3);
        factors.add("billtype");
        factors.add("taxpayertype");
        factors.add("invoicebiztype");
        factors.add("material");
        factors.add("taxrate");
        return factors;
    }

    public String getTargetField() {
        return "deductiblerate";
    }

    public Object calculate(Map<String, Object> billInfo) {
        Object billtypeObj = billInfo.get("billtype");
        if (billtypeObj != null && "im_PurInBill_FARM_BT_S".equals(((DynamicObject)billtypeObj).getString("number"))) {
            DynamicObject materialInfo = (DynamicObject)billInfo.get("material");
            BigDecimal entryDeductibleRate = (BigDecimal)billInfo.get("deductiblerate");
            if (materialInfo != null && (entryDeductibleRate == null || entryDeductibleRate.compareTo(BigDecimal.ZERO) == 0)) {
                DynamicObject material = materialInfo.getDynamicObject("masterid");
                entryDeductibleRate = material.getBigDecimal("deductiblerate");
            }
            return entryDeductibleRate;
        }
        DynamicObject invoiceBiz = (DynamicObject)billInfo.get("invoicebiztype");
        Long invoiceBizId = invoiceBiz != null ? invoiceBiz.getLong("id") : 0L;
        Object taxPayerType = billInfo.get("taxpayertype");
        if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
            return billInfo.get("taxrate");
        }
        return BigDecimal.ZERO;
    }
}

