/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl.purin;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class InterCostAmountExpr
implements ICalculateExpr {
    private static final BOSExpression expr = new BOSExpression("baseamountandtax - curdeductibleamt");

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>(expr.getVars());
        factors.add("billtype");
        factors.add("taxpayertype");
        return factors;
    }

    public String getTargetField() {
        return "intercostamt";
    }

    public Object calculate(Map<String, Object> billInfo) {
        if (this.isNotFarmAndNoneTaxPayer(billInfo)) {
            return BigDecimal.ZERO;
        }
        return FormulaEngine.execExcelFormula((Expr)expr.getExpr(), billInfo);
    }

    private boolean isNotFarmAndNoneTaxPayer(Map<String, Object> billInfo) {
        Object billtypeObj = billInfo.get("billtype");
        if (billtypeObj != null && "im_PurInBill_FARM_BT_S".equals(((DynamicObject)billtypeObj).getString("number"))) {
            return false;
        }
        return StringUtils.isBlank((Object)billInfo.get("taxpayertype"));
    }

    public String toString() {
        return "intercostamt = " + expr.toString();
    }
}

