/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl.purin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.formula.FormulaEngine;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class NoTaxDeductibleAmountExpr
implements ICalculateExpr {
    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>(3);
        factors.add("amount");
        factors.add("deductiblerate");
        factors.add("exchangerate");
        factors.add("settlecurrency");
        factors.add("settlecurrency.amtprecision");
        factors.add("quotation");
        return factors;
    }

    public String getTargetField() {
        return "curdeductibleamt";
    }

    public Object calculate(Map<String, Object> billInfo) {
        BigDecimal curdeductibleamt = (BigDecimal)FormulaEngine.execExcelFormula((String)"amount * deductiblerate / 100", billInfo);
        if (null == curdeductibleamt) {
            return BigDecimal.ZERO;
        }
        curdeductibleamt = curdeductibleamt.setScale((int)((Integer)billInfo.getOrDefault("settlecurrency.amtprecision", 2)), RoundingMode.HALF_UP);
        Object quotation = billInfo.get("quotation");
        BigDecimal exchangerate = (BigDecimal)billInfo.getOrDefault("exchangerate", BigDecimal.ZERO);
        if ("0".equals(quotation)) {
            return curdeductibleamt.multiply(exchangerate);
        }
        if ("1".equals(quotation) && BigDecimal.ZERO.compareTo(exchangerate) != 0) {
            return curdeductibleamt.divide(exchangerate, 10, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}

