/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.provider;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.mpscmm.msbd.algorithm.model.expr.impl.ConstsCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.DiscountTypeConditionExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.ExrateConvertCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.FormulaCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.AmountAndTaxExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.DeductibleRateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.InterCostAmountExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.TaxDeductibleAmountExpr;
import kd.mpscmm.msbd.algorithm.model.expr.provider.AbstractModelExprProvider;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public final class TaxModelBillExprProvider
extends AbstractModelExprProvider {
    public List<ICalculateExpr> provide(String billentity, String changedProp) {
        ArrayList<ICalculateExpr> cals = new ArrayList<ICalculateExpr>(16);
        cals.add(FormulaCalculateExpr.create("price", "priceandtax / ( 1 + taxrate / 100 )"));
        cals.add(FormulaCalculateExpr.create("amount", "amountandtax - taxamount"));
        if ("actualtaxprice".equals(changedProp)) {
            DiscountTypeConditionExpr amountAndTaxExpr = new DiscountTypeConditionExpr("amountandtax");
            amountAndTaxExpr.setRateExpr("priceandtax * qty * (1 - discountrate / 100 )");
            amountAndTaxExpr.setAmountExpr("(priceandtax - discountrate) * qty");
            amountAndTaxExpr.setDefaultExpr("priceandtax * qty");
            cals.add(amountAndTaxExpr);
        } else {
            cals.add(new AmountAndTaxExpr());
        }
        DiscountTypeConditionExpr discountAmountExpr = new DiscountTypeConditionExpr("discountamount");
        discountAmountExpr.setRateExpr("priceandtax * ( discountrate / 100 ) * qty");
        discountAmountExpr.setAmountExpr("discountrate * qty");
        discountAmountExpr.setDefaultExpr(new ConstsCalculateExpr("discountamount", BigDecimal.ZERO));
        cals.add(discountAmountExpr);
        cals.add(FormulaCalculateExpr.create("taxamount", "amountandtax / ( 100 + taxrate ) * taxrate"));
        cals.add(new ExrateConvertCalculateExpr("baseamountandtax", "amountandtax"));
        cals.add(new ExrateConvertCalculateExpr("basetaxamount", "taxamount"));
        cals.add(FormulaCalculateExpr.create("baseamount", "baseamountandtax - basetaxamount"));
        if ("amountandtax".equals(changedProp)) {
            DiscountTypeConditionExpr priceAndTaxExpr = new DiscountTypeConditionExpr("priceandtax");
            priceAndTaxExpr.setRateExpr("amountandtax / qty / (1 - discountrate/100)");
            priceAndTaxExpr.setAmountExpr("amountandtax / qty + discountrate");
            priceAndTaxExpr.setDefaultExpr("amountandtax / qty");
            cals.add(priceAndTaxExpr);
        } else if ("actualtaxprice".equals(changedProp)) {
            DiscountTypeConditionExpr discountRateExpr = new DiscountTypeConditionExpr("discountrate");
            discountRateExpr.setRateExpr("(priceandtax - actualtaxprice) / priceandtax");
            discountRateExpr.setAmountExpr("priceandtax - actualtaxprice");
            discountRateExpr.setDefaultValue(BigDecimal.ZERO);
            cals.add(discountRateExpr);
        } else if ("discountamount".equals(changedProp)) {
            DiscountTypeConditionExpr discountRateExpr = new DiscountTypeConditionExpr("discountrate");
            discountRateExpr.setRateExpr("discountamount /(priceandtax * qty )");
            discountRateExpr.setAmountExpr("discountamount / qty");
            discountRateExpr.setDefaultValue(BigDecimal.ZERO);
            cals.add(discountRateExpr);
        }
        if ("im_purinbill".equals(billentity) || "im_ospurinbill".equals(billentity)) {
            cals.add(new DeductibleRateExpr());
            cals.add(new TaxDeductibleAmountExpr());
            cals.add(new InterCostAmountExpr());
        }
        cals.addAll(this.getCommonPreinBillAlgorithm(billentity, changedProp));
        return cals;
    }

    public String getKey() {
        return "taxbill";
    }
}

