/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.sdk.mpscmm.msbd.expoint.datacontrol.IDataCtrlCasePlugin;

public class ExpointHelper {
    public static void beforeQuery(QFilter qfilter, CtrlSchemeInfo schemeInfo, final String field) {
        boolean isFieldGroup;
        Long customerId;
        Set<Long> groupSet;
        String entityId = schemeInfo.getEntityId();
        if ("customer".equals(field) && "msbd_cusmaterctrl".equalsIgnoreCase(entityId) && !CommonUtils.isNull(groupSet = ExpointHelper.getCustomerGrpSet(customerId = (Long)schemeInfo.getMEMapping().getLeftValueMap().get(field)))) {
            qfilter.or(new QFilter("entryentity.customergroup", "in", groupSet));
        }
        if ("operatorgroup".equals(field) && ("msbd_salopermaterctrl".equalsIgnoreCase(entityId) || "msbd_salopercusctrl".equalsIgnoreCase(entityId) || "msbd_puropermaterctrl".equalsIgnoreCase(entityId))) {
            qfilter.and(new QFilter("entryentity.operator", "=", (Object)0L));
        }
        boolean bl = isFieldGroup = "operatorgroup".equals(field) || "auxoperatorgroup".equals(field);
        if (isFieldGroup && "im_invoperatormat".equalsIgnoreCase(entityId)) {
            qfilter.and(new QFilter("controldimension", "in", (Object)new String[]{"OPERGRP_MATER", "OPERGRP_MATERGRP"}));
        }
        if (isFieldGroup && "im_warehousesetup".equalsIgnoreCase(entityId)) {
            qfilter.and(new QFilter("operatorentity.operatoruser", "=", (Object)0L));
        }
        try {
            HashMap<String, Object> map;
            List returnList;
            PluginProxy pluginProxy = PluginProxy.create(null, IDataCtrlCasePlugin.class, (String)"MPSCMM_MSBD_DATACONTROL", null);
            final Object value = schemeInfo.getMEMapping().getLeftValueMap().get(field);
            if (!CommonUtils.isNull((Object)value) && !CommonUtils.isNull((Object)(returnList = pluginProxy.callReplace(arg_0 -> ExpointHelper.lambda$beforeQuery$0(schemeInfo, map = new HashMap<String, Object>(){
                {
                    this.put(field, value);
                }
            }, arg_0))))) {
                for (Map qFilterMap : returnList) {
                    for (Map.Entry next : qFilterMap.entrySet()) {
                        if (next.getKey() == null) continue;
                        if (next.getValue() == IDataCtrlCasePlugin.QFilterLogic.AND) {
                            qfilter.and((QFilter)next.getKey());
                        }
                        if (next.getValue() != IDataCtrlCasePlugin.QFilterLogic.OR) continue;
                        qfilter.or((QFilter)next.getKey());
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f\u201c%1$s\u201d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"ExpointHelper_0", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]);
            msg = String.format(msg, "MPSCMM_MSBD_DATACONTROL");
            String msgTotal = msg + e.getMessage();
            throw new KDBizException(msgTotal);
        }
    }

    public static void beforeCalculate(CtrlSchemeInfo schemeInfo, Map<String, Set<Long>> map, Set<Long> datasByScheme) {
        String returnObj = schemeInfo.getReturnObj();
        ExpointHelper.relationDataConvert(map, datasByScheme, returnObj);
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IDataCtrlCasePlugin.class, (String)"MPSCMM_MSBD_DATACONTROL", null);
            List returnList = pluginProxy.callReplace(p -> p.beforeCalculate(schemeInfo.getNumber(), map));
            if (!CommonUtils.isNull((Object)returnList)) {
                for (Map dataMap : returnList) {
                    dataMap.forEach((k, v) -> {
                        if (returnObj.equals(k)) {
                            datasByScheme.addAll((Collection<Long>)v);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f\u201c%1$s\u201d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"ExpointHelper_0", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]);
            msg = String.format(msg, "MPSCMM_MSBD_DATACONTROL");
            String msgTotal = msg + e.getMessage();
            throw new KDBizException(msgTotal);
        }
    }

    private static void relationDataConvert(Map<String, Set<Long>> map, Set<Long> datasByScheme, String returnObj) {
        for (Map.Entry<String, Set<Long>> next : map.entrySet()) {
            if ("material".equals(returnObj) && "materialgroup".equals(next.getKey()) || "auxmaterial".equals(returnObj) && "auxmaterialgroup".equals(next.getKey())) {
                datasByScheme.addAll(ExpointHelper.getMaterialSetByGroup(next.getValue()));
            }
            if ("customer".equals(returnObj) && "customergroup".equals(next.getKey())) {
                datasByScheme.addAll(ExpointHelper.getCustomerSetByGroup(next.getValue()));
            }
            if ("supplier".equals(returnObj) && "suppliergroup".equals(next.getKey())) {
                datasByScheme.addAll(ExpointHelper.getSupplierSetByGroup(next.getValue()));
            }
            if ((!"warehouse".equals(returnObj) || !"warehousegroup".equals(next.getKey())) && (!"auxwarehouse".equals(returnObj) || !"auxwarehousegroup".equals(next.getKey()))) continue;
            datasByScheme.addAll(ExpointHelper.getWarehouseSetByGroup(next.getValue()));
        }
    }

    private static Set<Long> getCustomerGrpSet(Long customer) {
        HashSet<Long> groupSet = new HashSet<Long>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroupdetail", (String)"group", (QFilter[])new QFilter[]{new QFilter("customer", "=", (Object)customer)});
        for (DynamicObject groupDetail : objectMap.values()) {
            DynamicObject group = groupDetail.getDynamicObject("group");
            if (group == null) continue;
            groupSet.add((Long)group.getPkValue());
        }
        return groupSet;
    }

    private static Set<Long> getMaterialSetByGroup(Set<Long> materialGrpSet) {
        HashSet<Long> materialSet = new HashSet<Long>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material", (QFilter[])new QFilter[]{new QFilter("group", "in", materialGrpSet)});
        for (DynamicObject materialGrp : objectMap.values()) {
            if (materialGrp == null || materialGrp.getDynamicObject("material") == null) continue;
            materialSet.add((Long)materialGrp.getDynamicObject("material").getPkValue());
        }
        return materialSet;
    }

    private static Set<Long> getCustomerSetByGroup(Set<Long> customerGrpSet) {
        HashSet<Long> customerSet = new HashSet<Long>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroupdetail", (String)"customer", (QFilter[])new QFilter[]{new QFilter("group", "in", customerGrpSet)});
        for (DynamicObject customerGrp : objectMap.values()) {
            if (customerGrp == null || customerGrp.getDynamicObject("customer") == null) continue;
            customerSet.add((Long)customerGrp.getDynamicObject("customer").getPkValue());
        }
        return customerSet;
    }

    private static Set<Long> getSupplierSetByGroup(Set<Long> supplierGrpSet) {
        HashSet<Long> supplierSet = new HashSet<Long>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_suppliergroupdetail", (String)"supplier", (QFilter[])new QFilter[]{new QFilter("group", "in", supplierGrpSet)});
        for (DynamicObject supplierGrp : objectMap.values()) {
            if (supplierGrp == null || supplierGrp.getDynamicObject("customer") == null) continue;
            supplierSet.add((Long)supplierGrp.getDynamicObject("customer").getPkValue());
        }
        return supplierSet;
    }

    private static Set<Long> getWarehouseSetByGroup(Set<Long> warehouseGrpSet) {
        HashSet<Long> warehouseSet = new HashSet<Long>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "in", warehouseGrpSet)});
        for (DynamicObject warehouse : objectMap.values()) {
            if (warehouse == null) continue;
            warehouseSet.add((Long)warehouse.getPkValue());
        }
        return warehouseSet;
    }

    private static /* synthetic */ Map lambda$beforeQuery$0(CtrlSchemeInfo schemeInfo, Map map, IDataCtrlCasePlugin p) {
        return p.beforeQuery(schemeInfo.getNumber(), map);
    }
}

