/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.pojo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ModelMapping {
    protected Map<String, String> ModelMapping = new LinkedHashMap<String, String>(8);
    protected Map<String, Object> LeftValueMap = new LinkedHashMap<String, Object>(8);
    protected Map<String, Object> RightValueMap = new LinkedHashMap<String, Object>(8);

    public Map<String, String> getModelMapping() {
        return this.ModelMapping;
    }

    public Map<String, Object> getLeftValueMap() {
        return this.LeftValueMap;
    }

    public Map<String, Object> getRightValueMap() {
        return this.RightValueMap;
    }

    public void setModelMapping(Map<String, String> modelMapping) {
        this.ModelMapping = modelMapping;
    }

    public Map<String, Object> convert2LVMap() {
        if (CommonUtils.isNull(this.RightValueMap)) {
            return this.LeftValueMap;
        }
        for (Map.Entry<String, String> entry : this.ModelMapping.entrySet()) {
            String lField = entry.getKey();
            String rField = entry.getValue();
            Object rValue = this.RightValueMap.get(rField);
            if (rValue == null) continue;
            this.LeftValueMap.put(lField, rValue);
        }
        return this.LeftValueMap;
    }

    public Map<String, Object> convert2RVMap(List<String> inputConditionList) {
        if (CommonUtils.isNull(this.LeftValueMap)) {
            return this.RightValueMap;
        }
        HashSet<String> fields = new HashSet<String>();
        for (String contidion : inputConditionList) {
            String[] conditionFields = contidion.split(",");
            fields.addAll(Arrays.asList(conditionFields));
        }
        for (Map.Entry<String, String> entry : this.ModelMapping.entrySet()) {
            Object lValue;
            String lField = entry.getKey();
            String rField = entry.getValue();
            if (!fields.contains(lField) || (lValue = this.LeftValueMap.get(lField)) == null) continue;
            this.RightValueMap.put(rField, lValue);
        }
        return this.RightValueMap;
    }
}

