/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datacontrol.business.helper.ExpointHelper;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlDataInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.ModelMapping;
import kd.mpscmm.msbd.datacontrol.business.service.CtrlDataProcessor;
import kd.mpscmm.msbd.datacontrol.business.untils.ExpressionUtils;

public class DataCtrlService {
    private static final Log log = LogFactory.getLog(DataCtrlService.class);

    public static Map<String, Set<Long>> calcuCtrlData(CtrlStrategyInfo strategyInfo) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(4);
        ModelMapping mbMapping = strategyInfo.getMBMapping();
        Map<String, CtrlSchemeInfo> ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
        ArrayList<CtrlDataInfo> datas = new ArrayList<CtrlDataInfo>(8);
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeColl.values()) {
            ModelMapping meMapping = schemeInfo.getMEMapping();
            if (CommonUtils.isNull(mbMapping.getLeftValueMap())) continue;
            meMapping.getLeftValueMap().putAll(mbMapping.getLeftValueMap());
            Map<String, String> meMap = meMapping.getModelMapping();
            List<String> inputConditionList = schemeInfo.getInputConditionList();
            Map<String, Object> meRvMap = meMapping.convert2RVMap(inputConditionList);
            boolean isSchemeMatched = false;
            ArrayList<CtrlDataInfo> schemeDatas = new ArrayList<CtrlDataInfo>(8);
            for (int i = 0; i < inputConditionList.size(); ++i) {
                StringBuilder selectFields;
                String[] conditionFields;
                String inputCondition = inputConditionList.get(i);
                QFilter qfilter = null;
                for (String field : conditionFields = inputCondition.split(",")) {
                    if ("".equals(field)) continue;
                    Object value = meRvMap.get(meMap.get(field));
                    if (CommonUtils.isNull((Object)meMap.get(field)) || CommonUtils.isNull((Object)value)) {
                        qfilter = null;
                        break;
                    }
                    QFilter fieldQFilter = null;
                    fieldQFilter = value instanceof Collection ? new QFilter(meMap.get(field), "in", value) : new QFilter(meMap.get(field), "=", value);
                    ExpointHelper.beforeQuery(fieldQFilter, schemeInfo, field);
                    if (qfilter == null) {
                        qfilter = fieldQFilter;
                        continue;
                    }
                    qfilter.and(fieldQFilter);
                }
                if (qfilter == null) continue;
                QFilter dataRangeQfilter = DataCtrlService.getDataRangeQFilter(schemeInfo.getDataRangeQfilter(), schemeInfo.getEntityId());
                if (dataRangeQfilter != null) {
                    qfilter.and(dataRangeQfilter);
                }
                if (CommonUtils.isNull((Object)(selectFields = new StringBuilder(meMap.get(schemeInfo.getOutputResultList().get(i)))).toString())) continue;
                String controlType = meMap.get("controltype");
                if (StringUtils.isNotEmpty((CharSequence)controlType)) {
                    selectFields.append(",").append(controlType);
                }
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)DataCtrlService.class.getName(), (String)schemeInfo.getEntityId(), (String)selectFields.toString(), (QFilter[])new QFilter[]{qfilter}, null);){
                    schemeDatas.addAll(DataCtrlService.assembleCtrlDatas(ds, schemeInfo, schemeInfo.getOutputResultList().get(i)));
                }
                isSchemeMatched = true;
            }
            if (!isSchemeMatched) {
                strategyInfo.getUnMatchedSchemes().add(schemeInfo.getNumber());
                continue;
            }
            if (schemeDatas.size() == 0) {
                resultMap.put("ALLOW_DATA", new HashSet());
                resultMap.put("LIMIT_DATA", new HashSet());
                log.info("dataControl_resultmap:" + resultMap);
                return resultMap;
            }
            datas.addAll(schemeDatas);
        }
        if (strategyInfo.getUnMatchedSchemes().size() > 0) {
            if (strategyInfo.isAllUnMatched()) {
                return null;
            }
            String expression = strategyInfo.getSchemeExpression();
            for (String scheme : strategyInfo.getUnMatchedSchemes()) {
                expression = ExpressionUtils.removeString(expression, scheme);
            }
            strategyInfo.setSchemeExpression(expression);
        }
        CtrlDataProcessor processor = new CtrlDataProcessor(strategyInfo);
        processor.processData(datas);
        resultMap.put("ALLOW_DATA", processor.getAllowData());
        resultMap.put("LIMIT_DATA", processor.getLimitData());
        log.info("dataControl_resultmap:" + resultMap);
        return resultMap;
    }

    private static QFilter getDataRangeQFilter(String dataRangeQfilter, String entityId) {
        if (StringUtils.isNotEmpty((CharSequence)dataRangeQfilter)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)dataRangeQfilter, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityId), condition);
            fb.buildFilter();
            return fb.getQFilter();
        }
        return null;
    }

    private static List<CtrlDataInfo> assembleCtrlDatas(DataSet ds, CtrlSchemeInfo schemeInfo, String outputResult) {
        if (ds == null) {
            return null;
        }
        ArrayList<CtrlDataInfo> dataList = new ArrayList<CtrlDataInfo>(8);
        Map<String, String> meMap = schemeInfo.getMEMapping().getModelMapping();
        for (Row row : ds) {
            CtrlDataInfo data = new CtrlDataInfo();
            String field = meMap.get(outputResult);
            if (row.getLong(field) == null || row.getLong(field) == 0L) continue;
            data.setData(row.getLong(field));
            data.setOutputResult(outputResult);
            data.setCtrlScheme(schemeInfo.getNumber());
            String ctrlType = meMap.get("controltype");
            if (StringUtils.isNotEmpty((CharSequence)ctrlType) && ("LIMIT".equals(row.get(ctrlType)) || "0".equals(row.get(ctrlType)))) {
                data.setAllow(Boolean.FALSE);
            } else {
                data.setAllow(Boolean.TRUE);
            }
            dataList.add(data);
        }
        return dataList;
    }
}

