/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.untils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ExpressionUtils {
    public static Set<Long> evaluateExpression(String expression, Map<String, Set<Long>> dataSetMap) {
        Stack<Set<Long>> stack = new Stack<Set<Long>>();
        Stack<Character> ops = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '(') {
                int j = i;
                int cnt = 0;
                while (i < expression.length()) {
                    if (expression.charAt(i) == '(') {
                        ++cnt;
                    }
                    if (expression.charAt(i) == ')') {
                        --cnt;
                    }
                    if (cnt == 0) break;
                    ++i;
                }
                Set<Long> set = ExpressionUtils.evaluateExpression(expression.substring(j + 1, i), dataSetMap);
                stack.push(set);
            } else if (!ExpressionUtils.isLogic(c) && c != ' ') {
                StringBuilder dataSetName = new StringBuilder();
                dataSetName.append(c);
                while (i + 1 < expression.length() && !ExpressionUtils.isLogic(expression.charAt(i + 1))) {
                    if (expression.charAt(i + 1) != ' ') {
                        dataSetName.append(expression.charAt(i + 1));
                    }
                    ++i;
                }
                Set set = dataSetMap.getOrDefault(dataSetName.toString(), new HashSet(4));
                stack.push(set);
            } else if (ExpressionUtils.isLogic(c)) {
                ops.push(Character.valueOf(c));
            } else {
                if (c == ' ') continue;
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            if (stack.size() < 2 || ops.isEmpty()) continue;
            Set set2 = (Set)stack.pop();
            Set set1 = (Set)stack.pop();
            char op = ((Character)ops.pop()).charValue();
            Set<Long> result = ExpressionUtils.calculate(set1, set2, op);
            stack.push(result);
        }
        if (stack.size() != 1 || !ops.isEmpty()) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        return (Set)stack.pop();
    }

    public static boolean validateExpression(String expression) {
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '(') {
                stack.push(Character.valueOf(ch));
                continue;
            }
            if (ch != ')') continue;
            if (stack.isEmpty()) {
                return false;
            }
            stack.pop();
        }
        return stack.isEmpty();
    }

    public static String removeString(String expression, String str) {
        char afterOp;
        int index = (expression = expression.replaceAll("\\s+", "")).indexOf(str);
        if (index == -1) {
            return expression;
        }
        char beforeOp = index > 0 ? (char)expression.charAt(index - 1) : (char)' ';
        char c = afterOp = index + str.length() < expression.length() ? (char)expression.charAt(index + str.length()) : (char)' ';
        if (beforeOp == '(' && afterOp == ')') {
            return expression;
        }
        if (!ExpressionUtils.isLogic(beforeOp) && !ExpressionUtils.isLogic(afterOp)) {
            return expression.substring(0, index) + expression.substring(index + str.length());
        }
        if (ExpressionUtils.isLogic(beforeOp) && ExpressionUtils.isLogic(afterOp)) {
            if (beforeOp == afterOp) {
                return expression.substring(0, index - 1) + expression.substring(index + str.length());
            }
            if (beforeOp == '&' || afterOp == '|') {
                return expression.substring(0, index - 1) + expression.substring(index + str.length());
            }
            return expression.substring(0, index) + expression.substring(index + str.length() + 1);
        }
        if (!ExpressionUtils.isLogic(beforeOp) || !ExpressionUtils.isLogic(afterOp)) {
            return expression.substring(0, ExpressionUtils.isLogic(beforeOp) ? index - 1 : index) + expression.substring(index + str.length() + (ExpressionUtils.isLogic(afterOp) ? 1 : 0));
        }
        return expression;
    }

    private static Set<Long> calculate(Set<Long> set1, Set<Long> set2, char op) {
        HashSet<Long> result = new HashSet<Long>();
        if (op == '&') {
            result.addAll(set1);
            result.retainAll(set2);
        } else if (op == '|') {
            result.addAll(set1);
            result.addAll(set2);
        } else {
            throw new IllegalArgumentException("Invalid operator: " + op);
        }
        return result;
    }

    private static boolean isLogic(char c) {
        return c == '&' || c == '|';
    }
}

