/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class DataCtrlStrategyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit dataCtrlScheme;
        this.addClickListeners(new String[]{"ctrlfield"});
        BasedataEdit bizbill = (BasedataEdit)this.getView().getControl("bizbill");
        if (bizbill != null) {
            bizbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dataCtrlScheme = (BasedataEdit)this.getView().getControl("datactrlscheme")) != null) {
            dataCtrlScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "bizbill": {
                List srcbills;
                QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                QFilter mappingQfilter = new QFilter("targetobj", "=", (Object)"msbd_datactrlmodel");
                mappingQfilter.and(new QFilter("isenable", "=", (Object)true));
                Map mappings = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{mappingQfilter});
                if (!CommonUtils.isNull((Object)mappings) && !CommonUtils.isNull(srcbills = mappings.values().stream().filter(dyn -> dyn.get("sourcebill") != null).map(dyn -> dyn.getDynamicObject("sourcebill").getPkValue()).collect(Collectors.toList()))) {
                    qFilter = new QFilter("id", "in", srcbills);
                }
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "datactrlscheme": {
                String ctrlField = (String)this.getModel().getValue("ctrlfield");
                if (CommonUtils.isNull((Object)ctrlField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u63a7\u5236\u5b57\u6bb5\u201d\u3002", (String)"DataCtrlStrategyPlugin_0", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject billMapping = (DynamicObject)this.getModel().getValue("billmapping");
                Map srcMap = FieldMapHelper.getFieldMapById((Long)((Long)billMapping.getPkValue()), null);
                if (CommonUtils.isNull((Object)srcMap)) break;
                if (CommonUtils.isNull(srcMap.get(ctrlField))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u201d\u4e2d\u9700\u8981\u5305\u542b\u201c\u63a7\u5236\u5b57\u6bb5\u201d\uff0c\u4e14\u6807\u8bc6\u9700\u8981\u4fdd\u6301\u4e00\u81f4\u3002", (String)"DataCtrlStrategyPlugin_1", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                ArrayList schemeIds = new ArrayList(8);
                if (entrys != null) {
                    entrys.forEach(k -> {
                        if (k.get("datactrlscheme") != null) {
                            schemeIds.add(k.getDynamicObject("datactrlscheme").getPkValue());
                        }
                    });
                }
                QFilter q2 = new QFilter("returnobject", "=", srcMap.get(ctrlField));
                if (schemeIds.size() > 0) {
                    QFilter q3 = new QFilter("id", "not in", schemeIds);
                    q2.and(q3);
                }
                showParameter.getListFilterParameter().getQFilters().add(q2);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (fieldKey) {
            case "bizbill": {
                this.changeBizBill(changeSet);
                break;
            }
            case "ctrlfield": {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
        }
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey().toLowerCase();
        if ("ctrlfield".equals(key)) {
            DynamicObject bizBill = (DynamicObject)this.getModel().getValue("bizbill");
            if (bizBill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u5355\u636e\u201d\u3002", (String)"DataCtrlStrategyPlugin_2", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]));
                return;
            }
            MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)bizBill.getString("number"));
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.addMatchedClassTypes(BasedataProp.class);
            option.setIncludePKField(false);
            option.setIncludeBDPropPK(false);
            option.setOnlyPhysicsField(false);
            option.setIncludeBDRefProp(true);
            option.setIncludeEntryEntityAsKeyPrefix(false);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
            showParameter.getCustomParams().put("treenodes", nodesJson);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ctrlfield"));
            this.getView().showForm(showParameter);
        }
    }

    private void changeBizBill(ChangeData[] changeSet) {
        Object newValue = changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        if (newValue != null) {
            DynamicObject bizBill = (DynamicObject)newValue;
            QFilter targetQfilter = new QFilter("targetobj", "=", (Object)"msbd_datactrlmodel");
            QFilter sourceQfilter = new QFilter("sourcebill", "=", (Object)bizBill.getString("number"));
            DynamicObject mappings = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{targetQfilter, sourceQfilter});
            model.setValue("billmapping", (Object)mappings);
        } else {
            model.setValue("billmapping", null);
        }
        model.setValue("ctrlfield", null);
        model.deleteEntryData("entryentity");
        model.createNewEntryRow("entryentity");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String prop;
        MainEntityType sourceEntityType;
        IDataEntityProperty property;
        DynamicObject bizBill;
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId)) {
            return;
        }
        if ("ctrlfield".equals(actionId) && returnData instanceof String && StringUtils.isNotBlank((Object)returnData) && (bizBill = (DynamicObject)this.getModel().getValue("bizbill")) != null && (property = (sourceEntityType = MetadataServiceHelper.getDataEntityType((String)((String)bizBill.getPkValue()))).findProperty(prop = ((String)returnData).split("\\.")[0])) != null) {
            String field = (String)returnData;
            IDataEntityType parent = property.getParent();
            while (!parent.getName().equals(bizBill.getPkValue())) {
                field = parent.getName().concat(".").concat(field);
                parent = parent.getParent();
            }
            this.getModel().setValue("ctrlfield", (Object)field);
        }
    }
}

