/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.builder;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.MarkDownHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;

public abstract class QuoteCalLogBuilder {
    private String sceneType;

    public QuoteCalLogBuilder(String sceneType) {
        this.sceneType = sceneType;
    }

    public String build(QuoteCalcColl quoteCalcColl, String calcStrategyID, int seq, List<String> resultList) {
        StringBuilder logSchemeText = new StringBuilder();
        QuoteCalcInfo quoteCalcInfo = quoteCalcColl.getQuoteCalcInfo(calcStrategyID);
        String calcStrategyName = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u7b97\u7b56\u7565\uff1a", (String)"QuoteCalLogBuilder_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq);
        String calcStrategyName_t = quoteCalcInfo.getName();
        calcStrategyName_t = calcStrategyName_t.replaceAll("_", "\\\\_");
        StringBuilder calcStrategyName_s = new StringBuilder(calcStrategyName).append(calcStrategyName_t);
        logSchemeText.append((CharSequence)MarkDownHelper.getFourLevel(calcStrategyName_s));
        String preConditionDesc = quoteCalcInfo.getQuotePreConditonDesc();
        String terminationSign = quoteCalcInfo.getTerminationSignX();
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditon(seq, preConditionDesc));
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditonResult(seq));
        if (!this.getCancel()) {
            if (this.getAnalysisCalcStrategy()) {
                logSchemeText.append("\n\n");
                StringBuilder analysisCalcStrategy = new StringBuilder();
                analysisCalcStrategy.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u7b56\u7565\u7684\u5177\u4f53\u53d6\u4ef7\u8fc7\u7a0b\u8bf7\u67e5\u770b\u5b9a\u4ef7\u8fc7\u7a0b\u3002", (String)"QuoteCalLogBuilder_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(analysisCalcStrategy)));
            }
            logSchemeText.append("\n\n");
            String resultStr = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\uff1a", (String)"QuoteCalLogBuilder_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(new StringBuilder(resultStr))));
            if (resultList == null || resultList.size() == 0) {
                logSchemeText.append("\n\n");
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteCalLogBuilder_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0])))));
            } else {
                for (String result : resultList) {
                    logSchemeText.append("\n\n");
                    logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(result))));
                }
            }
            logSchemeText.append("\n\n");
            String schemeTemination = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u7b97\u7b56\u7565\u7ec8\u6b62\u6761\u4ef6\uff1a", (String)"QuoteCalLogBuilder_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq);
            MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)quoteCalcInfo.getQuoteType());
            Map allFileds = quoteBillType.getAllFields();
            String[] subFields = terminationSign.split("\\.");
            String terminationSignField = subFields[subFields.length - 1];
            String terminationSignName = ((IDataEntityProperty)allFileds.get(terminationSignField)).getDisplayName().toString();
            logSchemeText.append(MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(schemeTemination).append(this.getTerminationResult(terminationSignName)))).toString());
        }
        return logSchemeText.toString();
    }

    abstract boolean getAnalysisCalcStrategy();

    abstract boolean getCancel();

    abstract boolean getPreConditonResult();

    abstract String getTerminationResult(String var1);

    private String preConditonResult(int seq) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u7b97\u7b56\u7565\u524d\u7f6e\u6761\u4ef6\u7ed3\u679c\uff1a", (String)"QuoteCalLogBuilder_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq));
        boolean preConditonResult = this.getPreConditonResult();
        result.append(preConditonResult);
        if (preConditonResult) {
            result = MarkDownHelper.thicker(result);
        }
        return MarkDownHelper.putTwoSpace(result).toString();
    }

    private String preConditon(int seq, String preConditionDesc) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u7b97\u7b56\u7565\u524d\u7f6e\u6761\u4ef6\uff1a", (String)"QuoteCalLogBuilder_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq));
        result = MarkDownHelper.putTwoSpace(result);
        result.append("\n\n");
        if (StringUtils.isNotEmpty((CharSequence)preConditionDesc)) {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(preConditionDesc)));
        } else {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8ba1\u7b97\u7b56\u7565\u524d\u7f6e\u6761\u4ef6\u3002", (String)"QuoteCalLogBuilder_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]))));
        }
        return result.toString();
    }
}

