/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.builder;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.MarkDownHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.OrderEnum;

public abstract class QuoteLogBuilder {
    private String sceneType;

    public QuoteLogBuilder(String sceneType) {
        this.sceneType = sceneType;
    }

    public String build(QuoteSchemeColl quoteSchemeColl, String schemeID, int seq, List<String> resultList) {
        StringBuilder logSchemeText = new StringBuilder();
        QuoteSchemeInfo quoteSchemeInfo = quoteSchemeColl.getQuoteSchemes(schemeID);
        String schemeName = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\uff1a", (String)"QuoteLogBuilder_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq);
        String schemeName_t = quoteSchemeInfo.getName();
        schemeName_t = schemeName_t.replaceAll("_", "\\\\_");
        StringBuilder schemeName_s = new StringBuilder(schemeName).append(schemeName_t);
        logSchemeText.append((CharSequence)MarkDownHelper.getFourLevel(schemeName_s));
        String preConditionDesc = quoteSchemeInfo.getQuotePreConditonDesc();
        String terminationSign = quoteSchemeInfo.getTerminationSignX();
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditon(seq, preConditionDesc));
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditonResult(seq));
        if (!this.getCancel()) {
            StringBuilder mappingField;
            int s;
            logSchemeText.append("\n\n");
            StringBuilder analysisScheme = new StringBuilder();
            analysisScheme.append(ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u65b9\u6848\uff1a", (String)"QuoteLogBuilder_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(analysisScheme)));
            logSchemeText.append("\n\n");
            String fieldMapping = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a", (String)"QuoteLogBuilder_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(fieldMapping)));
            for (s = 0; s < quoteSchemeInfo.getQuoteDimensionsDes().size(); ++s) {
                logSchemeText.append("\n\n");
                mappingField = new StringBuilder();
                mappingField.append(quoteSchemeInfo.getQuoteSourceDimensionsDes().get(s)).append("/").append(OperatorEnum.getName(quoteSchemeInfo.getOperators().get(s))).append("/").append(quoteSchemeInfo.getQuoteDimensionsDes().get(s));
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(mappingField));
            }
            for (s = 0; s < quoteSchemeInfo.getConfigureDimensionDes().size(); ++s) {
                logSchemeText.append("\n\n");
                mappingField = new StringBuilder();
                mappingField.append(quoteSchemeInfo.getConfigureSourceDimensionDes().get(s)).append("/").append(OperatorEnum.getName(quoteSchemeInfo.getConfigureOperators().get(s))).append("/").append(quoteSchemeInfo.getConfigureDimensionDes().get(s));
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(mappingField));
            }
            logSchemeText.append("\n\n");
            String otherConditon = ResManager.loadKDString((String)"\u4ef7\u683c\u6765\u6e90\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(otherConditon)));
            logSchemeText.append("\n\n");
            if (StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSrcFilterDes())) {
                String quoteSrcFilterDes = MarkDownHelper.formatConditon(quoteSchemeInfo.getQuoteSrcFilterDes());
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(quoteSrcFilterDes)));
            } else {
                String unSettring = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(unSettring)));
            }
            logSchemeText.append("\n\n");
            String priceSort = ResManager.loadKDString((String)"\u4ef7\u683c\u6392\u5e8f\uff1a", (String)"QuoteLogBuilder_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(priceSort)));
            if (quoteSchemeInfo.getSortSignsDes().size() > 0) {
                for (int s2 = 0; s2 < quoteSchemeInfo.getSortSignsDes().size(); ++s2) {
                    logSchemeText.append("\n\n");
                    StringBuilder sortField = new StringBuilder();
                    sortField.append(quoteSchemeInfo.getSortSignsDes().get(s2)).append("/").append(OrderEnum.getName(quoteSchemeInfo.getSortOrders().get(s2)));
                    logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(sortField));
                }
            } else {
                logSchemeText.append("\n\n");
                String unSort = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6392\u5e8f", (String)"QuoteLogBuilder_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(unSort)));
            }
            logSchemeText.append("\n\n");
            String resultStr = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\uff1a", (String)"QuoteLogBuilder_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(new StringBuilder(resultStr))));
            if (resultList == null || resultList.size() == 0) {
                logSchemeText.append("\n\n");
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteLogBuilder_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0])))));
            } else {
                for (String result : resultList) {
                    logSchemeText.append("\n\n");
                    logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(result))));
                }
            }
            logSchemeText.append("\n\n");
            logSchemeText.append(this.multiValueResult());
            logSchemeText.append("\n\n");
            String schemeTemination = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u7ec8\u6b62\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq);
            MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)quoteSchemeInfo.getQuoteType());
            String terminationSignName = QuoteLogHelper.getTerminateFieldDisplayName(quoteBillType, terminationSign);
            logSchemeText.append(MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(schemeTemination).append(this.getTerminationResult(terminationSignName)))).toString());
        }
        return logSchemeText.toString();
    }

    abstract boolean getCancel();

    abstract boolean getPreConditonResult();

    abstract String getTerminationResult(String var1);

    private String preConditonResult(int seq) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6\u7ed3\u679c\uff1a", (String)"QuoteLogBuilder_10", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq));
        boolean preConditonResult = this.getPreConditonResult();
        result.append(preConditonResult);
        if (preConditonResult) {
            result = MarkDownHelper.thicker(result);
        }
        return MarkDownHelper.putTwoSpace(result).toString();
    }

    private String preConditon(int seq, String preConditionDesc) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_11", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq));
        result = MarkDownHelper.putTwoSpace(result);
        result.append("\n\n");
        if (StringUtils.isNotEmpty((CharSequence)preConditionDesc)) {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(preConditionDesc)));
        } else {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6\u3002", (String)"QuoteLogBuilder_12", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]))));
        }
        return result.toString();
    }

    abstract String multiValueResult();
}

