/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterValue;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class PriceHelper {
    private static final Log LOGGER = LogFactory.getLog(PriceHelper.class);
    private static final String HEADER = "header";
    private static final String ENTRY = "entry";
    private static final String RESULT = "result";

    public static String getLeftName(String sign) {
        return new StringBuffer(PriceConst.LEFT).append(new StringBuffer(sign.replaceAll("\\.", "__"))).toString();
    }

    public static String getRightName(String sign) {
        return new StringBuffer(PriceConst.RIGHT).append(new StringBuffer(sign.replaceAll("\\.", "__"))).toString();
    }

    public static String backRightName(String sign) {
        sign = sign.replace(PriceConst.RIGHT, "").replaceAll("__", "\\.");
        return sign;
    }

    public static String getSimpleLeftName(String field) {
        return PriceConst.LEFT + field;
    }

    public static FilterBuilder convertFullStringToQFilter(String runcondition, String srcType) {
        if (StringUtils.isNotEmpty((String)runcondition) && StringUtils.isNotEmpty((String)srcType)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)runcondition, CRCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), crCondition.getFilterCondition());
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (StringUtils.isNotEmpty((String)runcondition) && StringUtils.isNotEmpty((String)srcType)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static FilterCondition convertStringToCondition(String runcondition) {
        if (StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            return condition;
        }
        return null;
    }

    public static FilterCondition convertFullStringToCondition(String runcondition) {
        if (StringUtils.isNotEmpty((String)runcondition)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)runcondition, CRCondition.class);
            return crCondition.getFilterCondition();
        }
        return null;
    }

    public static String dataTypeAdapte(QFilter totalFilter, MainEntityType headType) {
        HashMap<String, Set<String>> convertMap = new HashMap<String, Set<String>>(16);
        PriceHelper.parseFilter(totalFilter, headType, convertMap);
        return PriceHelper.transferDateType(totalFilter.toString(), convertMap);
    }

    private static void parseFilter(QFilter totalFilter, MainEntityType headType, Map<String, Set<String>> converMap) {
        if (!totalFilter.isExpressValue()) {
            PriceHelper.transferAndRecDataType(totalFilter, headType, converMap);
        } else {
            String valueAlias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(totalFilter.getValue().toString().replaceAll("\\.", "__"))).toString();
            totalFilter.__setValue((Object)valueAlias);
        }
        if (!"1".equals(totalFilter.getProperty())) {
            String alias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(totalFilter.getProperty().replaceAll("\\.", "__"))).toString();
            totalFilter.__setProperty(alias);
        }
        List listFilterNest = totalFilter.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            PriceHelper.parseFilter(nestFilter, headType, converMap);
        }
    }

    private static String transferDateType(String conditionStr, Map<String, Set<String>> convertMap) {
        if (convertMap.get("date") != null) {
            for (String date : convertMap.get("date")) {
                Pattern p = Pattern.compile("'" + date + "'");
                Matcher m = p.matcher(conditionStr);
                conditionStr = m.replaceAll("cast('" + date + "' as timestamp)");
            }
        }
        LOGGER.info("final filterstr:" + conditionStr);
        return conditionStr;
    }

    private static void transferAndRecDataType(QFilter totalFilter, MainEntityType headType, Map<String, Set<String>> converMap) {
        block8: {
            Object valueK;
            block12: {
                String value;
                block13: {
                    IDataEntityProperty ep;
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    if (!"is not null".equals(totalFilter.getCP())) break block7;
                                    totalFilter.__setValue(null);
                                    break block8;
                                }
                                if (!(totalFilter.getValue() instanceof QEmptyValue) && (!"not exists".equals(totalFilter.getCP()) || totalFilter.getValue() == null || !(totalFilter.getValue() instanceof QFilterValue) || !"1 = 1".equals(totalFilter.getValue().toString()))) break block9;
                                IDataEntityProperty ep2 = DataSetHelper.findPropertys((EntityType)headType, totalFilter.getProperty());
                                totalFilter.__setCP("is null");
                                totalFilter.__setValue(null);
                                if (ep2 instanceof LongProp && "id".equals(ep2.getName())) {
                                    totalFilter.or(new QFilter(totalFilter.getProperty(), "=", (Object)Long.valueOf("0")));
                                }
                                break block8;
                            }
                            ep = DataSetHelper.findPropertys((EntityType)headType, totalFilter.getProperty());
                            if (!(ep instanceof BooleanProp)) break block10;
                            totalFilter.__setValue((Object)("1".equals(totalFilter.getValue()) ? 1 : 0));
                            break block8;
                        }
                        if (!(ep instanceof DateProp) && !(ep instanceof DateTimeProp)) break block11;
                        if (totalFilter.getValue() != null) {
                            final Date value2 = (Date)totalFilter.getValue();
                            final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            if (converMap.get("date") == null) {
                                converMap.put("date", new HashSet(){
                                    {
                                        this.add(format.format(value2));
                                    }
                                });
                            } else {
                                converMap.get("date").add(format.format(value2));
                            }
                        }
                        break block8;
                    }
                    if (ep instanceof TimeProp || !(ep instanceof TextProp) || totalFilter.getValue() == null) break block8;
                    valueK = totalFilter.getValue();
                    if (!(valueK instanceof String)) break block12;
                    value = (String)totalFilter.getValue();
                    if (!"''".equals(value) && !"' '".equals(value)) break block13;
                    totalFilter.__setValue((Object)"");
                    break block8;
                }
                if (!"\"\"".equals(value) && !"\" \"".equals(value)) break block8;
                totalFilter.__setValue((Object)"");
                break block8;
            }
            if (valueK instanceof List) {
                List valueList = (List)valueK;
                for (int s = 0; s < valueList.size(); ++s) {
                    String value = (String)valueList.get(s);
                    if ("''".equals(value) || "' '".equals(value)) {
                        valueList.set(s, "");
                        continue;
                    }
                    if (!"\"\"".equals(value) && !"\" \"".equals(value)) continue;
                    valueList.set(s, "");
                }
            }
        }
    }

    public static List<QFilter> transferToQFilters(QFilter totalFilter) {
        if (totalFilter == null) {
            return null;
        }
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        if (!"1".equals(totalFilter.getProperty())) {
            result.add(totalFilter);
        }
        List listFilterNest = totalFilter.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            List<QFilter> nestFilters = PriceHelper.transferToQFilters(nestFilter);
            if (nestFilters == null) continue;
            result.addAll(nestFilters);
        }
        return result;
    }

    public static String generateRowKey(PriceEntityKeyInfo PriceEntityKeyInfo2, Row row) {
        StringBuilder key = new StringBuilder();
        key.append(row.get(PriceEntityKeyInfo2.getLEFTIDFIELDS().get(0)));
        for (int i = 1; i < PriceEntityKeyInfo2.getLEFTIDFIELDS().size(); ++i) {
            String idField = PriceEntityKeyInfo2.getLEFTIDFIELDS().get(i);
            key.append("__").append(row.get(idField));
        }
        return key.toString();
    }

    public static String generateKey(PriceEntityKeyInfo quoteKeyInfo, Row row, String priceField) {
        StringBuilder newKey = new StringBuilder();
        for (String idField : quoteKeyInfo.getLEFTIDFIELDS()) {
            newKey.append(row.get(idField)).append("$$");
        }
        newKey.append(priceField);
        return newKey.toString();
    }

    public static String generateSimpleKey(PriceEntityKeyInfo quoteKeyInfo, Row row, String priceField) {
        StringBuilder newKey = new StringBuilder();
        if (quoteKeyInfo.getLEFTIDFIELDS().size() == 1) {
            for (String idField : quoteKeyInfo.getLEFTIDFIELDS()) {
                newKey.append(row.get(idField)).append("$$");
            }
        } else {
            for (int i = 0; i < quoteKeyInfo.getLEFTIDFIELDS().size() - 1; ++i) {
                newKey.append(row.get(quoteKeyInfo.getLEFTIDFIELDS().get(i))).append("$$");
            }
        }
        newKey.append(priceField);
        return newKey.toString();
    }

    public static boolean isNumeric(String str) {
        Pattern pattern;
        Matcher isNum;
        if ("-".equals(str.substring(0, 1))) {
            str = str.replaceFirst("-", "");
        }
        return (isNum = (pattern = Pattern.compile("\\d+(|\\.)?\\d*")).matcher(str)).matches();
    }
}

