/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.advanceprice;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.formula.FormulaEngine;
import kd.bos.lang.Lang;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceFormulaExprInfo;

public class PriceFormulaHelper {
    private static final String FOCUS = "focus";
    private static final String[] OPERATERS = new String[]{"+", "-", "*", "/"};
    private static final String CURSOR_INDEX = "cursorIndex";
    private static final String CTRL_KEY = "ctrlKey";
    private static final String SET_TEXTAREA_CURSOR_POSITION = "setTextareaCursorPosition";
    private static final String FDESCRIPTION = "fdescription";
    private static final String FTRANEXPR = "ftranexpr";
    private static final String FEXPRESSION = "fexpression";

    public static void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int cursorIndex;
        int pos = PriceFormulaHelper.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = str.length();
        } else {
            String insertStr = " " + str + " ";
            expression = PriceFormulaHelper.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
        cursorMap.put(CURSOR_INDEX, cursorIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static void backSpaceExpression(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (!StringUtils.isBlank((CharSequence)expression)) {
            int cursorIndex = PriceFormulaHelper.getCursorIndex(view, buttonKey, textFieldKey);
            String part1 = expression.substring(0, cursorIndex);
            String part2 = expression.substring(cursorIndex);
            String partDel = part1;
            for (String str : OPERATERS) {
                int lastIndex = partDel.lastIndexOf(str);
                if (lastIndex <= 0 || !"".equals((partDel = partDel.substring(lastIndex + str.length())).trim())) continue;
                partDel = str;
                break;
            }
            String[] fieldList = partDel.split(" ");
            for (int i = fieldList.length - 1; i >= 0; --i) {
                if ("".equals(fieldList[i].trim())) continue;
                partDel = fieldList[i];
                break;
            }
            expression = part1.substring(0, part1.lastIndexOf(partDel)) + part2;
            cursorIndex = part1.substring(0, part1.lastIndexOf(partDel)).length();
            view.getModel().setValue(textFieldKey, (Object)expression);
            HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
            cursorMap.put(CURSOR_INDEX, cursorIndex);
            cursorMap.put(CTRL_KEY, textFieldKey);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
        }
    }

    public static String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    public static int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get(FOCUS) != null) {
                Map focus = (Map)map.get(FOCUS);
                if (focus.get(textFieldKey) != null) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    public static void setCursorIndex(IFormView view, String textFieldKey, int focusIndex) {
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
        cursorMap.put(CURSOR_INDEX, focusIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static PriceFormulaExprInfo deserialize(String json) {
        PriceFormulaExprInfo formulaObj = null;
        formulaObj = StringUtils.isEmpty((CharSequence)json) ? PriceFormulaExprInfo.getInstance() : (PriceFormulaExprInfo)SerializationUtils.fromJsonString((String)json, PriceFormulaExprInfo.class);
        return formulaObj;
    }

    public static String tranExpression(String expression, String json) {
        String[] vars = PriceFormulaHelper.extractVariables(expression);
        String tranExpression = PriceFormulaHelper.tranExpression(expression, json, vars);
        return tranExpression;
    }

    public static String tranExpression(String expression, String json, String[] vars) {
        String expressionDesc = expression;
        if (vars == null || vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            } else {
                String curNodeId;
                TreeNode curNode;
                String[] split = string.split("\\.", 2);
                if (split.length > 1 && (curNode = rootNode.getTreeNode(curNodeId = split[1], 5)) != null) {
                    varCaption = curNode.getText();
                }
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static void getFormulaObj(IDataModel model, PriceFormulaExprInfo formulaObj) {
        String expression = (String)model.getValue(FEXPRESSION);
        formulaObj.setExpression(expression);
        String desc = (String)model.getValue(FDESCRIPTION);
        formulaObj.getDescription().setItem(Lang.get().toString(), (Object)desc);
        String tranexpr = (String)model.getValue(FTRANEXPR);
        formulaObj.getLocaleExprTran().setItem(Lang.get().toString(), (Object)tranexpr);
    }

    public static void initData(IDataModel model, String conditonJson) {
        PriceFormulaExprInfo formulaObj = PriceFormulaHelper.deserialize(conditonJson);
        model.setValue(FEXPRESSION, (Object)formulaObj.getExpression());
        if (!formulaObj.getLocaleExprTran().isEmpty()) {
            model.setValue(FTRANEXPR, (Object)formulaObj.getLocaleExprTran().getLocaleValue());
        }
    }

    public static String[] extractVariables(String expression) {
        String[] vars = FormulaEngine.extractVariables((String)expression);
        return vars;
    }
}

