/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.quote;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;

public class QuoteOtherHelper {
    public static String generateSchemeKey(Object pk, int seq) {
        StringBuilder key = new StringBuilder();
        key.append(pk.toString()).append("__").append(seq);
        return key.toString();
    }

    public static boolean isEntryPriceField(String resultField, List<String> entryNames) {
        for (String entryName : entryNames) {
            if (!resultField.contains(entryName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimensionMode(DynamicObject quoteScheme) {
        return quoteScheme.getDynamicObject("quoteentity") != null && "msbd_pricetax_expenses".equals(quoteScheme.getDynamicObject("quoteentity").getString("number"));
    }

    public static String getPriceSourceEntity(DynamicObject quoteScheme) {
        if (quoteScheme.getDynamicObject("pricesourceentity") != null) {
            String sourceEntity = quoteScheme.getDynamicObject("pricesourceentity").getString("number");
            if (QuoteOtherHelper.isDimensionMode(quoteScheme)) {
                sourceEntity = "msbd_pricetax_expenses";
            }
            return sourceEntity;
        }
        return null;
    }

    public static boolean isNewMode(DynamicObject quoteStrategy) {
        return Boolean.TRUE.equals(quoteStrategy.getBoolean("isnewmode"));
    }

    public static String getFullCaption(MainEntityType quoteBillType, String quoteSign) {
        String quoteSignDes = "";
        String[] quoteSignRex = quoteSign.split("\\.");
        if (quoteSignRex.length > 1) {
            String quoteSignHead = quoteSignRex[0];
            if (quoteBillType.getAllEntities().containsKey(quoteSignHead)) {
                int index = quoteSign.indexOf(46, 0);
                quoteSign = quoteSign.substring(index + 1);
                quoteSignDes = EntityParseHelper.buildPropFullCaption((EntityType)quoteBillType, (String)quoteSign);
            } else {
                quoteSignDes = EntityParseHelper.buildPropFullCaption((EntityType)quoteBillType, (String)quoteSign);
            }
        } else {
            quoteSignDes = EntityParseHelper.buildPropFullCaption((EntityType)quoteBillType, (String)quoteSign);
        }
        return quoteSignDes;
    }

    public static void loadCaption(IDataModel model, String quoteentity, String entryName, String quotesign, String quoteSignNameField, AtomicBoolean change) {
        DynamicObject quoteBill = (DynamicObject)model.getValue(quoteentity);
        if (quoteBill != null) {
            String quoteBillNum = quoteBill.getString("number");
            MainEntityType quoteType = EntityMetadataCache.getDataEntityType((String)quoteBillNum);
            for (int row = 0; row < model.getEntryRowCount(entryName); ++row) {
                String tempFieldId;
                IDataEntityProperty findProperty;
                String quoteSign = (String)model.getValue(quotesign, row);
                if (!StringUtils.isNotEmpty((CharSequence)quoteSign)) continue;
                String[] quoteSign_sub = quoteSign.split("\\.");
                if (quoteSign_sub.length > 1 && (findProperty = quoteType.findProperty(tempFieldId = quoteSign_sub[0])) instanceof EntryProp) {
                    int index = quoteSign.indexOf(46, 0);
                    quoteSign = quoteSign.substring(index + 1);
                }
                String quoteSignName = EntityParseHelper.buildPropFullCaption((EntityType)quoteType, (String)quoteSign);
                quoteSignName = QuoteOtherHelper.reduceFieldName(quoteBillNum, quoteSignName);
                model.setValue(quoteSignNameField, (Object)quoteSignName, row);
                change.set(true);
            }
        }
    }

    private static String reduceFieldName(String quoteBillNum, String fieldCaption) {
        String[] fieldCaption_sub;
        if ("msbd_pricetax_expenses".equals(quoteBillNum) && (fieldCaption_sub = fieldCaption.split("\\.")).length >= 2) {
            int index = fieldCaption.indexOf(46, 0);
            fieldCaption = fieldCaption.substring(index + 1);
        }
        return fieldCaption;
    }
}

