/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;

public class AdvancedPricingProInfo {
    private String billNo;
    private Long materialId;
    private BigDecimal qty;
    private Long unit;
    private Long currency;
    private String quoteEntity;
    private Long quoteStrategy;
    private Long calStrategy;
    private Long billId;
    private Long entryId;
    private Long org;
    private String key;
    private List<CalFactor> calFactorList = new ArrayList<CalFactor>();
    private List<CalFormula> calFormulaList = new ArrayList<CalFormula>();
    private static final Log logger = LogFactory.getLog(AdvancedPricingProInfo.class);

    private AdvancedPricingProInfo() {
    }

    public static AdvancedPricingProInfo createInstance() {
        return new AdvancedPricingProInfo();
    }

    public static CalFactor createCalFactor() {
        return new CalFactor();
    }

    public static CalFormula createCalFormula() {
        return new CalFormula();
    }

    public static void savePricingProcessInfoList(List<AdvancedPricingProInfo> pricingProcessInfoList) {
        ThreadPools.executeOnce((String)"pricingprocesslist", () -> {
            List<DynamicObject> pricingProcessObjList = pricingProcessInfoList.stream().map(row -> AdvancedPricingProInfo.getPricingProcessObj(row)).collect(Collectors.toList());
            List keyList = pricingProcessInfoList.stream().map(row -> row.getKey()).collect(Collectors.toList());
            try (TXHandle h = TX.requiresNew((String)"AdvancedPricingProInfoList");){
                try {
                    logger.info("\u6279\u91cf\u5316\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u5f00\u59cb\u3002");
                    if (keyList != null && keyList.size() > 0) {
                        QFilter KeyFilter = new QFilter("key", "in", keyList);
                        DeleteServiceHelper.delete((String)"msbd_pricingprocess", (QFilter[])new QFilter[]{KeyFilter});
                        SaveServiceHelper.save((DynamicObject[])pricingProcessObjList.toArray(new DynamicObject[0]));
                    }
                    logger.info("\u6279\u91cf\u5316\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u7ed3\u675f\u3002");
                }
                catch (Exception kde) {
                    logger.error("\u6279\u91cf\u5316\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38:{}", (Object)Arrays.toString(kde.getStackTrace()));
                    h.markRollback();
                    throw kde;
                }
            }
        });
    }

    public static void savePricingProcessInfo(AdvancedPricingProInfo pricingProcessInfo) {
        ThreadPools.executeOnce((String)"pricingprocess", () -> {
            try (TXHandle h = TX.requiresNew((String)"AdvancedPricingProInfo");){
                try {
                    logger.info("\u9010\u6761\u5316\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u5f00\u59cb\u3002");
                    String uniqueKey = pricingProcessInfo.getKey();
                    if (uniqueKey != null) {
                        QFilter KeyFilter = new QFilter("key", "=", (Object)uniqueKey);
                        DeleteServiceHelper.delete((String)"msbd_pricingprocess", (QFilter[])new QFilter[]{KeyFilter});
                        DynamicObject obj = AdvancedPricingProInfo.getPricingProcessObj(pricingProcessInfo);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                    }
                    logger.info("\u9010\u6761\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u7ed3\u675f");
                }
                catch (Exception kde) {
                    logger.error("\u9010\u6761\u5f02\u6b65\u6301\u4e45\u5316\u5b9a\u4ef7\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38:{}", (Object)Arrays.toString(kde.getStackTrace()));
                    h.markRollback();
                    throw kde;
                }
            }
        });
    }

    private static DynamicObject getPricingProcessObj(AdvancedPricingProInfo pricingProcessInfo) {
        List<CalFormula> calFormulaList;
        DynamicObject pricingProcess = BusinessDataServiceHelper.newDynamicObject((String)"msbd_pricingprocess");
        pricingProcess.set("billNo", (Object)pricingProcessInfo.getBillNo());
        pricingProcess.set("material", (Object)pricingProcessInfo.getMaterialId());
        pricingProcess.set("qty", (Object)pricingProcessInfo.getQty());
        pricingProcess.set("unit", (Object)pricingProcessInfo.getUnit());
        pricingProcess.set("quoteStrategy", (Object)pricingProcessInfo.getQuoteStrategy());
        pricingProcess.set("calStrategy", (Object)pricingProcessInfo.getCalStrategy());
        pricingProcess.set("billId", (Object)pricingProcessInfo.getBillId());
        pricingProcess.set("entryId", (Object)pricingProcessInfo.getEntryId());
        pricingProcess.set("key", (Object)pricingProcessInfo.getKey());
        pricingProcess.set("org", (Object)pricingProcessInfo.getOrg());
        pricingProcess.set("quoteentity", (Object)pricingProcessInfo.getQuoteEntity());
        pricingProcess.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        pricingProcess.set("currency", (Object)pricingProcessInfo.getCurrency());
        pricingProcess.set("createtime", (Object)TimeServiceHelper.now());
        List<CalFactor> calFactorList = pricingProcessInfo.getCalFactorList();
        if (calFactorList != null && calFactorList.size() > 0) {
            DynamicObjectCollection calFactorColl = pricingProcess.getDynamicObjectCollection("factor");
            for (int i = 0; i < calFactorList.size(); ++i) {
                BigDecimal price;
                CalFactor calFactor = calFactorList.get(i);
                DynamicObject calFactorRow = calFactorColl.addNew();
                calFactorRow.set("seq", (Object)(i + 1));
                calFactorRow.set("quoteschemegroup", (Object)calFactor.getQuoteSchemeGroup());
                if (calFactor.getConfiguredValue() != null) {
                    calFactorRow.set("configuredvalue", (Object)calFactor.getConfiguredValue());
                }
                price = (price = calFactor.getPrice()) == null ? BigDecimal.ZERO : price;
                calFactorRow.set("price", (Object)price);
                if (calFactor.getResult() != null) {
                    calFactorRow.set("result", (Object)calFactor.getResult());
                }
                calFactorRow.set("quotesuccess", (Object)calFactor.getQuoteSuccess());
                calFactorRow.set("required", (Object)calFactor.getRequired());
            }
        }
        if ((calFormulaList = pricingProcessInfo.getCalFormulaList()) != null && calFormulaList.size() > 0) {
            DynamicObjectCollection calFormulaColl = pricingProcess.getDynamicObjectCollection("calformula");
            for (int i = 0; i < calFormulaList.size(); ++i) {
                CalFormula calFormula = calFormulaList.get(i);
                DynamicObject calFormulaRow = calFormulaColl.addNew();
                calFormulaRow.set("seq", (Object)(i + 1));
                calFormulaRow.set("formula", (Object)calFormula.getFormula());
                BigDecimal priceResult = calFormula.getPriceResult();
                priceResult = priceResult == null ? BigDecimal.ZERO : priceResult;
                calFormulaRow.set("priceresult", (Object)priceResult);
                calFormulaRow.set("calresult", (Object)calFormula.getCalResult());
                if (calFormula.getCalResult() != null) {
                    calFormulaRow.set("calresult", (Object)calFormula.getCalResult());
                }
                calFormulaRow.set("quotesignname", (Object)calFormula.getQuoteSignName());
                calFormulaRow.set("quotesign", (Object)calFormula.getQuoteSign());
                calFormulaRow.set("processfactor", (Object)calFormula.getProcessFactor());
                calFormulaRow.set("formuladescription", (Object)calFormula.getFormulaDescription());
                calFormulaRow.set("formulades", (Object)calFormula.getFormulaDes());
            }
        }
        return pricingProcess;
    }

    public Long getMaterialId() {
        return this.materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getBillId() {
        return this.billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public Long getCurrency() {
        return this.currency;
    }

    public void setCurrency(Long currency) {
        this.currency = currency;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Long getUnit() {
        return this.unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }

    public Long getQuoteStrategy() {
        return this.quoteStrategy;
    }

    public void setQuoteStrategy(Long quoteStrategy) {
        this.quoteStrategy = quoteStrategy;
    }

    public Long getCalStrategy() {
        return this.calStrategy;
    }

    public void setCalStrategy(Long calStrategy) {
        this.calStrategy = calStrategy;
    }

    public List<CalFactor> getCalFactorList() {
        return this.calFactorList;
    }

    public void setCalFactorList(List<CalFactor> calFactorList) {
        this.calFactorList = calFactorList;
    }

    public List<CalFormula> getCalFormulaList() {
        return this.calFormulaList;
    }

    public void setCalFormulaList(List<CalFormula> calFormulaList) {
        this.calFormulaList = calFormulaList;
    }

    public String toString() {
        return "AdvancedPricingProInfo{billNo='" + this.billNo + '\'' + ", materialId=" + this.materialId + ", qty=" + this.qty + ", unit=" + this.unit + ", currency=" + this.currency + ", quoteEntity='" + this.quoteEntity + '\'' + ", quoteStrategy=" + this.quoteStrategy + ", calStrategy=" + this.calStrategy + ", billId=" + this.billId + ", entryId=" + this.entryId + ", org=" + this.org + ", key='" + this.key + '\'' + ", calFactorList=" + this.calFactorList + ", calFormulaList=" + this.calFormulaList + '}';
    }

    public String getQuoteEntity() {
        return this.quoteEntity;
    }

    public void setQuoteEntity(String quoteEntity) {
        this.quoteEntity = quoteEntity;
    }

    public Long getOrg() {
        return this.org;
    }

    public void setOrg(Long org) {
        this.org = org;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public static class CalFormula {
        private String formula;
        private BigDecimal priceResult;
        private String calResult;
        private String quoteSignName;
        private String quoteSign;
        private Long processFactor;
        private String formulaDes;
        private String formulaDescription;

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public BigDecimal getPriceResult() {
            return this.priceResult;
        }

        public void setPriceResult(BigDecimal priceResult) {
            this.priceResult = priceResult;
        }

        public String getCalResult() {
            return this.calResult;
        }

        public void setCalResult(String calResult) {
            this.calResult = calResult;
        }

        public String getQuoteSignName() {
            return this.quoteSignName;
        }

        public void setQuoteSignName(String quoteSignName) {
            this.quoteSignName = quoteSignName;
        }

        public String getQuoteSign() {
            return this.quoteSign;
        }

        public void setQuoteSign(String quoteSign) {
            this.quoteSign = quoteSign;
        }

        public Long getProcessFactor() {
            return this.processFactor;
        }

        public void setProcessFactor(Long processFactor) {
            this.processFactor = processFactor;
        }

        public String getFormulaDescription() {
            return this.formulaDescription;
        }

        public void setFormulaDescription(String formulaDescription) {
            this.formulaDescription = formulaDescription;
        }

        public String getFormulaDes() {
            return this.formulaDes;
        }

        public void setFormulaDes(String formulaDes) {
            this.formulaDes = formulaDes;
        }

        public String toString() {
            return "CalFormula{formula='" + this.formula + '\'' + ", priceResult=" + this.priceResult + ", quoteSignName='" + this.quoteSignName + '\'' + ", quoteSign='" + this.quoteSign + '\'' + ", processFactor=" + this.processFactor + ", formulaDescription='" + this.formulaDescription + '\'' + '}';
        }
    }

    public static class CalFactor {
        private Long quoteSchemeGroup;
        private String configuredValue;
        private BigDecimal price;
        private String result;
        private String quoteSuccess;
        private boolean required;

        public CalFactor copy() {
            CalFactor newOne = new CalFactor();
            newOne.setQuoteSchemeGroup(this.getQuoteSchemeGroup());
            newOne.setQuoteSuccess(this.getQuoteSuccess());
            newOne.setRequired(this.required);
            return newOne;
        }

        public Long getQuoteSchemeGroup() {
            return this.quoteSchemeGroup;
        }

        public void setQuoteSchemeGroup(Long quoteSchemeGroup) {
            this.quoteSchemeGroup = quoteSchemeGroup;
        }

        public String getConfiguredValue() {
            return this.configuredValue;
        }

        public void setConfiguredValue(String configuredValue) {
            this.configuredValue = configuredValue;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getQuoteSuccess() {
            return this.quoteSuccess;
        }

        public void setQuoteSuccess(String quoteSuccess) {
            this.quoteSuccess = quoteSuccess;
        }

        public boolean getRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String toString() {
            return "CalFactor{quoteSchemeGroup=" + this.quoteSchemeGroup + ", configuredValue='" + this.configuredValue + '\'' + ", price=" + this.price + ", result=" + this.result + ", quoteSuccess='" + this.quoteSuccess + '\'' + ", required='" + this.required + '\'' + '}';
        }
    }
}

