/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceControlHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.common.enums.OrderEnum;

public class PriceControlSchemeInfo {
    private String pk;
    private int seq;
    private DynamicObject priceControlScheme;
    private List<String> dimensions = new ArrayList<String>();
    private List<String> dimensionDescs = new ArrayList<String>();
    private List<String> dimensionAliass = new ArrayList<String>();
    private List<String> sourceDimensions = new ArrayList<String>();
    private List<String> sourceDimensionDescs = new ArrayList<String>();
    private List<String> sourceDimensionAliass = new ArrayList<String>();
    private List<String> compareFields = new ArrayList<String>();
    private List<String> compareFieldAliass = new ArrayList<String>();
    private List<String> compareSourceFields = new ArrayList<String>();
    private List<String> compareSourceFieldAliass = new ArrayList<String>();
    private String srcConditon;
    private QFilter srcFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    private String srcConditonDesc;
    private String preConditon;
    private String preConditonDesc;
    private QFilter preFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    private List<QFilter> preFilters = new ArrayList<QFilter>();
    private PriceSourceKeyInfo priceControlSrcKeyInfo;
    private List<String> operators = new ArrayList<String>();
    private List<String> compares = new ArrayList<String>();
    private List<String> sortSignFields = new ArrayList<String>();
    private List<String> sortSignsDescs = new ArrayList<String>();
    private List<String> sortSignAliass = new ArrayList<String>();
    private List<String> sortOrders = new ArrayList<String>();

    public PriceControlSchemeInfo generateSchemeInfo(DynamicObject priceControlStrategySeqInfo) {
        this.priceControlScheme = priceControlStrategySeqInfo.getDynamicObject("pricecontrolscheme");
        this.seq = priceControlStrategySeqInfo.getInt("seq");
        this.pk = this.generateSchemeKey(this.priceControlScheme.getPkValue(), this.seq);
        this.generateEntryInfo();
        this.preConditon = priceControlStrategySeqInfo.getString("preconditionjson_tag");
        this.preConditonDesc = priceControlStrategySeqInfo.getString("preconditiondesc");
        FilterBuilder preFilterBuilder = PriceHelper.convertFullStringToQFilter(this.preConditon, this.priceControlScheme.getDynamicObject("controlentity").getString("number"));
        if (preFilterBuilder != null) {
            this.preFilter.and(preFilterBuilder.getQFilter());
            this.preFilters = preFilterBuilder.getQFilters();
        }
        this.srcConditon = priceControlStrategySeqInfo.getString("ctlsrcconditon_tag");
        this.srcConditonDesc = priceControlStrategySeqInfo.getString("ctlsrcconditondesc");
        FilterBuilder srcFilterBuilder = PriceHelper.convertFullStringToQFilter(this.srcConditon, this.priceControlScheme.getDynamicObject("controlsource").getString("number"));
        if (srcFilterBuilder != null) {
            this.srcFilter.and(srcFilterBuilder.getQFilter());
        }
        return this;
    }

    private PriceControlSchemeInfo generateEntryInfo() {
        if (this.priceControlScheme != null) {
            DynamicObjectCollection mappingEntry = this.priceControlScheme.getDynamicObjectCollection("mappingentry");
            for (Object mappingInfo : mappingEntry) {
                String controlSign = mappingInfo.getString("controlsign");
                String controlSignDesc = mappingInfo.getString("controlsignname");
                String matchFlag = mappingInfo.getString("matchflag");
                String sourceSign = mappingInfo.getString("sourcesign");
                String sourceSignDesc = mappingInfo.getString("sourcesignname");
                this.dimensions.add(controlSign);
                this.dimensionDescs.add(controlSignDesc);
                this.dimensionAliass.add(PriceHelper.getLeftName(controlSign));
                this.sourceDimensions.add(sourceSign);
                this.sourceDimensionDescs.add(sourceSignDesc);
                this.sourceDimensionAliass.add(PriceHelper.getRightName(sourceSign));
                this.operators.add(matchFlag);
            }
            DynamicObjectCollection compareEntry = this.priceControlScheme.getDynamicObjectCollection("compareentry");
            for (DynamicObject compareInfo : compareEntry) {
                String controlSignC = compareInfo.getString("controlcomp");
                String compareFlag = compareInfo.getString("compareflag");
                String sourceSignC = compareInfo.getString("sourcecomp");
                this.compareFields.add(controlSignC);
                this.compareFieldAliass.add(PriceHelper.getLeftName(controlSignC));
                this.compareSourceFields.add(sourceSignC);
                this.compareSourceFieldAliass.add(PriceHelper.getRightName(sourceSignC));
                this.compares.add(compareFlag);
            }
            DynamicObjectCollection sortEntry = this.priceControlScheme.getDynamicObjectCollection("controlsortentry");
            for (DynamicObject sortInfo : sortEntry) {
                String sortSign = sortInfo.getString("sortsign");
                this.sortSignFields.add(sortSign);
                this.sortSignsDescs.add(sortInfo.getString("sortsignname"));
                this.sortOrders.add(OrderEnum.getProptery(sortInfo.getString("order")));
                this.sortSignAliass.add(PriceHelper.getRightName(sortSign));
            }
            this.priceControlSrcKeyInfo = PriceControlHelper.getSrcCommonConst(this);
        }
        return this;
    }

    public List<String> mergeQuoteSourceFields() {
        ArrayList<String> allSourceSelecties = new ArrayList<String>();
        this.sourceDimensions.forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.compareSourceFields.forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.sortSignFields.forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        return allSourceSelecties;
    }

    public List<String> mergeQuoteSourceAlias() {
        ArrayList<String> allAliasSelecties = new ArrayList<String>();
        this.sourceDimensionAliass.forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.compareSourceFieldAliass.forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.sortSignAliass.forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        return allAliasSelecties;
    }

    private String generateSchemeKey(Object pk, int seq) {
        StringBuilder key = new StringBuilder();
        key.append(pk).append("__").append(seq);
        return key.toString();
    }

    public String getPk() {
        return this.pk;
    }

    public int getSeq() {
        return this.seq;
    }

    public DynamicObject getPriceControlScheme() {
        return this.priceControlScheme;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public List<String> getDimensionDescs() {
        return this.dimensionDescs;
    }

    public List<String> getDimensionAliass() {
        return this.dimensionAliass;
    }

    public List<String> getSourceDimensions() {
        return this.sourceDimensions;
    }

    public List<String> getSourceDimensionDescs() {
        return this.sourceDimensionDescs;
    }

    public List<String> getSourceDimensionAliass() {
        return this.sourceDimensionAliass;
    }

    public List<String> getCompareFields() {
        return this.compareFields;
    }

    public List<String> getCompareFieldAliass() {
        return this.compareFieldAliass;
    }

    public List<String> getCompareSourceFields() {
        return this.compareSourceFields;
    }

    public List<String> getCompareSourceFieldAliass() {
        return this.compareSourceFieldAliass;
    }

    public String getSrcConditon() {
        return this.srcConditon;
    }

    public QFilter getSrcFilter() {
        return this.srcFilter;
    }

    public String getSrcConditonDesc() {
        return this.srcConditonDesc;
    }

    public String getPreConditon() {
        return this.preConditon;
    }

    public String getPreConditonDesc() {
        return this.preConditonDesc;
    }

    public QFilter getPreFilter() {
        return this.preFilter;
    }

    public PriceSourceKeyInfo getPriceControlSrcKeyInfo() {
        return this.priceControlSrcKeyInfo;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public List<String> getCompares() {
        return this.compares;
    }

    public List<String> getSortSignFields() {
        return this.sortSignFields;
    }

    public List<String> getSortSignsDescs() {
        return this.sortSignsDescs;
    }

    public List<String> getSortSignAliass() {
        return this.sortSignAliass;
    }

    public List<String> getSortOrders() {
        return this.sortOrders;
    }

    public List<QFilter> getPreFilters() {
        return this.preFilters;
    }
}

