/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;

public abstract class QuoteProcessInfo {
    protected String name;
    protected String number;
    protected int seq;
    protected List<String> quoteResults = new ArrayList<String>();
    protected List<String> quoteResultsAlias = new ArrayList<String>();
    protected String id;
    protected String use;
    protected String quotePreConditon;
    protected String quotePreConditonDesc;
    protected List<QFilter> quotePreFilters = new ArrayList<QFilter>();
    protected String terminationSignInit;
    protected String terminationSignX;
    protected QFilter quotePreFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    protected String quoteType;
    protected String quoteSrcConditon;
    protected QFilter quoteSrcFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    protected String quoteSrcFilterDes;
    protected String quoteSrcType;

    protected QuoteProcessInfo generateProcessInfo(DynamicObject quoteInfo, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        this.quotePreConditon = quoteStrategySeqInfo.getPreCondition();
        this.quotePreConditonDesc = quoteStrategySeqInfo.getPreConditionDesc();
        this.terminationSignInit = StringUtils.isNotEmpty((String)quoteStrategySeqInfo.getTerminationSign()) ? quoteStrategySeqInfo.getTerminationSign() : "";
        this.seq = quoteStrategySeqInfo.getSeq();
        this.id = QuoteOtherHelper.generateSchemeKey(quoteInfo.getPkValue(), this.seq);
        this.name = quoteInfo.getString("name");
        this.number = quoteInfo.getString("number");
        this.quoteType = quoteStrategySeqInfo.getOrigialQuoteType();
        FilterBuilder quotePreBuilder = PriceHelper.convertFullStringToQFilter(this.quotePreConditon, this.quoteType);
        if (quotePreBuilder != null) {
            this.quotePreFilter.and(quotePreBuilder.getQFilter());
            this.quotePreFilters = quotePreBuilder.getQFilters();
        }
        this.quoteSrcConditon = quoteStrategySeqInfo.getSourceCondition();
        this.quoteSrcFilterDes = quoteStrategySeqInfo.getSourceConditionDesc();
        FilterBuilder quoteSrcBuilder = PriceHelper.convertFullStringToQFilter(this.quoteSrcConditon, this.quoteSrcType);
        if (quoteSrcBuilder != null) {
            this.quoteSrcFilter.and(quoteSrcBuilder.getQFilter());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getQuotePreConditonDesc() {
        return this.quotePreConditonDesc;
    }

    public List<QFilter> getQuotePreFilters() {
        return this.quotePreFilters;
    }

    public String getTerminationSignInit() {
        return this.terminationSignInit;
    }

    public QFilter getQuotePreFilter() {
        return this.quotePreFilter;
    }

    public String getQuoteType() {
        return this.quoteType;
    }

    public QFilter getQuoteSrcFilter() {
        return this.quoteSrcFilter;
    }

    public String getQuoteSrcFilterDes() {
        return this.quoteSrcFilterDes;
    }

    public String getQuoteSrcType() {
        return this.quoteSrcType;
    }

    public void setQuoteSrcFilter(QFilter quoteSrcFilter) {
        this.quoteSrcFilter = quoteSrcFilter;
    }

    public List<String> getQuoteResults() {
        return this.quoteResults;
    }

    public List<String> getQuoteResultsAlias() {
        return this.quoteResultsAlias;
    }

    public String getTerminationSignX() {
        return this.terminationSignX;
    }

    public void setQuotePreFilter(QFilter quotePreFilter) {
        this.quotePreFilter = quotePreFilter;
    }
}

