/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class QuoteCalcColl {
    private DynamicObject quoteStratege;
    private List<DynamicObject> calcStrateges = new ArrayList<DynamicObject>();
    private Map<String, QuoteCalcInfo> mapping = new HashMap<String, QuoteCalcInfo>();
    private List<QuoteCalcInfo> quoteCalcInfos = new ArrayList<QuoteCalcInfo>();

    public QuoteCalcColl(DynamicObject quoteStratege) {
        this.quoteStratege = quoteStratege;
    }

    public void applyStratege(DynamicObject calcStratege, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        this.calcStrateges.add(calcStratege);
        QuoteCalcInfo quoteCalcInfo = new QuoteCalcInfo();
        quoteCalcInfo.generateStrategeInfo(calcStratege, quoteStrategySeqInfo, this.quoteStratege);
        this.mapping.put(quoteCalcInfo.getId(), quoteCalcInfo);
        this.quoteCalcInfos.add(quoteCalcInfo);
    }

    public void load() {
        ArrayList<Long> schemePks = new ArrayList<Long>(16);
        HashSet<Long> groupPks = new HashSet<Long>(16);
        Map<Object, Object> groupMap = new HashMap();
        this.quoteCalcInfos.forEach(c -> {
            List<QuoteSchemeGroupInfo> groups = c.getSchemeGroupInfos();
            groups.forEach(g -> {
                if (PriceSourceEnum.SCHEME.getValue().equals(g.getPriceSource())) {
                    groupPks.add(g.getId());
                }
            });
        });
        if (groupPks.size() > 0) {
            groupMap = QuoteHelper.getActiveGroupInfo(groupPks);
            groupMap.forEach((k, v) -> {
                DynamicObjectCollection groupEntry = v.getDynamicObjectCollection("entry");
                groupEntry.forEach(ge -> {
                    DynamicObject scheme = ge.getDynamicObject("quotescheme");
                    if (scheme != null) {
                        schemePks.add(scheme.getLong("id"));
                    }
                });
            });
        }
        if (schemePks.size() > 0) {
            Map<Object, DynamicObject> schemeMap = QuoteHelper.getActiveSchemeInfo(schemePks, true);
            for (int i = 0; i < this.quoteCalcInfos.size(); ++i) {
                List<QuoteSchemeGroupInfo> groups = this.quoteCalcInfos.get(i).getSchemeGroupInfos();
                for (QuoteSchemeGroupInfo group : groups) {
                    if (groupMap.get(group.getId()) == null) continue;
                    DynamicObject groupOb = (DynamicObject)groupMap.get(group.getId());
                    DynamicObjectCollection groupEntry = groupOb.getDynamicObjectCollection("entry");
                    for (int j = 0; j < groupEntry.size(); ++j) {
                        DynamicObject scheme = ((DynamicObject)groupEntry.get(j)).getDynamicObject("quotescheme");
                        if (scheme == null || (scheme = schemeMap.get(scheme.getPkValue())) == null) continue;
                        String sourceCondition = ((DynamicObject)groupEntry.get(j)).getString("pricesourceprecon_tag");
                        String sourceConditionDesc = ((DynamicObject)groupEntry.get(j)).getString("pricesourceprecondesc");
                        String preCondition = ((DynamicObject)groupEntry.get(j)).getString("precondition_tag");
                        String preConditionDesc = ((DynamicObject)groupEntry.get(j)).getString("qu_preconditiondesc");
                        DynamicObjectCollection resultCollection = scheme.getDynamicObjectCollection("entryresult");
                        String teminationSign = "";
                        for (DynamicObject resultEntry : resultCollection) {
                            if (!resultEntry.getBoolean("schemegroupprice")) continue;
                            teminationSign = resultEntry.getString("sourcesignr");
                        }
                        if (!StringUtils.isNotEmpty((String)teminationSign)) continue;
                        QuoteStrategySeqInfo quoteStrategySeqInfo = new QuoteStrategySeqInfo(j + 1, teminationSign, preCondition, preConditionDesc, sourceCondition, sourceConditionDesc);
                        quoteStrategySeqInfo.setOrigialQuoteType(this.quoteCalcInfos.get(i).getQuoteType());
                        group.applyScheme(scheme, quoteStrategySeqInfo);
                    }
                }
            }
        }
    }

    public List<String> mergeDimension(List<String> dimensionSet) {
        this.quoteCalcInfos.forEach(q -> {
            q.getSchemeGroupInfos().forEach(d -> d.mergeDimension(dimensionSet));
            q.getQuotePreFilters().forEach(f -> this.generateDimension(dimensionSet, (QFilter)f));
        });
        return dimensionSet;
    }

    public List<String> mergeAlias(List<String> aliasSet) {
        this.quoteCalcInfos.forEach(q -> {
            q.getSchemeGroupInfos().forEach(d -> d.mergeAlias(aliasSet));
            q.getQuotePreFilters().forEach(f -> this.generateAlias(aliasSet, (QFilter)f));
        });
        return aliasSet;
    }

    public List<String> mergeTerminateSign(List<String> terminateSignSet) {
        this.quoteCalcInfos.forEach(qs -> {
            String terminationSign = qs.getTerminationSignX();
            if (!terminateSignSet.contains(terminationSign)) {
                terminateSignSet.add(terminationSign);
            }
        });
        return terminateSignSet;
    }

    public List<String> mergeQuoteResult(List<String> quoteResultSet) {
        this.quoteCalcInfos.forEach(q -> q.getQuoteResults().forEach(d -> {
            if (!quoteResultSet.contains(d)) {
                quoteResultSet.add((String)d);
            }
        }));
        return quoteResultSet;
    }

    public List<String> mergeQuoteResultAlias(List<String> quoteResultAliasSet) {
        this.quoteCalcInfos.forEach(q -> q.getQuoteResultsAlias().forEach(d -> {
            if (!quoteResultAliasSet.contains(d)) {
                quoteResultAliasSet.add((String)d);
            }
        }));
        return quoteResultAliasSet;
    }

    public List<DynamicObject> getCalcStrateges() {
        return this.calcStrateges;
    }

    public QuoteCalcInfo getQuoteCalcInfo(String qcID) {
        return this.mapping.get(qcID);
    }

    public DynamicObject getQuoteStratege() {
        return this.quoteStratege;
    }

    public void setQuoteStratege(DynamicObject quoteStratege) {
        this.quoteStratege = quoteStratege;
    }

    public List<QuoteCalcInfo> getQuoteCalcInfos() {
        return this.quoteCalcInfos;
    }

    private void generateDimension(List<String> dimensionSet, QFilter f) {
        if (!dimensionSet.contains(f.getProperty())) {
            dimensionSet.add(f.getProperty());
        }
        if (f.isExpressValue() && !dimensionSet.contains(f.getValue())) {
            dimensionSet.add(f.getValue().toString());
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateDimension(dimensionSet, nestFilter);
        }
    }

    private void generateAlias(List<String> aliasSet, QFilter f) {
        String valueAlias;
        String alias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString();
        if (!aliasSet.contains(alias)) {
            aliasSet.add(alias);
        }
        if (f.isExpressValue() && !aliasSet.contains(valueAlias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getValue().toString().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(valueAlias);
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateAlias(aliasSet, nestFilter);
        }
    }
}

