/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;

public class QuoteSchemeGroupInfo
extends QuoteSchemeColl {
    private Long id;
    private String number;
    private String name;
    private String mulPrice;
    private String quoteFieldSign;
    private String quoteFieldSignAlias;
    private String priceSource;
    private boolean isRequire;
    private Map<String, Object> groupResult = new HashMap<String, Object>();
    private Map<String, Object> featureResult = new HashMap<String, Object>();
    private Map<String, List<FeatureValueInfo>> featureValueResult = new HashMap<String, List<FeatureValueInfo>>();

    public QuoteSchemeGroupInfo(DynamicObject quoteStratege, Long id, String number, String name, String mulprice, String quoteFieldSign, String pricesource, boolean isRequire) {
        super(quoteStratege);
        this.id = id;
        this.number = number;
        this.mulPrice = mulprice;
        this.quoteFieldSign = quoteFieldSign;
        this.quoteFieldSignAlias = PriceHelper.getLeftName(quoteFieldSign);
        this.priceSource = pricesource;
        this.isRequire = isRequire;
        this.name = name;
    }

    @Override
    public List<String> mergeDimension(List<String> dimensionSet) {
        super.mergeDimension(dimensionSet);
        if (StringUtils.isNotEmpty((String)this.quoteFieldSign) && !dimensionSet.contains(this.quoteFieldSign)) {
            dimensionSet.add(this.quoteFieldSign);
        }
        return dimensionSet;
    }

    @Override
    public List<String> mergeAlias(List<String> alias) {
        super.mergeAlias(alias);
        if (StringUtils.isNotEmpty((String)this.quoteFieldSign) && !alias.contains(this.quoteFieldSignAlias)) {
            alias.add(this.quoteFieldSignAlias);
        }
        return alias;
    }

    public String getMulPrice() {
        return this.mulPrice;
    }

    public void setMulPrice(String mulPrice) {
        this.mulPrice = mulPrice;
    }

    public String getQuoteFieldSign() {
        return this.quoteFieldSign;
    }

    public void setQuoteFieldSign(String quoteFieldSign) {
        this.quoteFieldSign = quoteFieldSign;
    }

    public String getPriceSource() {
        return this.priceSource;
    }

    public void setPricesource(String pricesource) {
        this.priceSource = pricesource;
    }

    public Long getId() {
        return this.id;
    }

    public String getQuoteFieldSignAlias() {
        return this.quoteFieldSignAlias;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getGroupResult() {
        return this.groupResult;
    }

    public boolean isRequire() {
        return this.isRequire;
    }

    public Map<String, Object> getFeatureResult() {
        return this.featureResult;
    }

    public Map<String, List<FeatureValueInfo>> getFeatureValueResult() {
        return this.featureValueResult;
    }

    public void updateFeatureResult(FeatureValueInfo newValue, String mainKey) {
        List records = this.getFeatureValueResult().computeIfAbsent(mainKey, s -> new ArrayList());
        boolean isExists = false;
        for (int i = 0; i < records.size(); ++i) {
            FeatureValueInfo existRecord = (FeatureValueInfo)records.get(i);
            if (!(StringUtils.isEmpty((String)existRecord.getFeatureValue()) ? "" : existRecord.getFeatureValue()).equals(StringUtils.isEmpty((String)newValue.getFeatureValue()) ? "" : newValue.getFeatureValue())) continue;
            records.set(i, newValue);
            isExists = true;
        }
        if (!isExists) {
            records.add(newValue);
        }
    }
}

