/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.IPriceFormulaCalculate;

public class PriceFormulaExecutor {
    private List<IPriceFormulaCalculate> calExprs = new ArrayList<IPriceFormulaCalculate>(16);
    private IPriceFormulaCalculate calExpr;

    private PriceFormulaExecutor(List<IPriceFormulaCalculate> calExprs) {
        if (calExprs != null) {
            this.calExprs = calExprs;
        }
    }

    private PriceFormulaExecutor(IPriceFormulaCalculate calExpr) {
        this.calExpr = calExpr;
    }

    public static PriceFormulaExecutor create(List<IPriceFormulaCalculate> calExpr) {
        return new PriceFormulaExecutor(calExpr);
    }

    public static PriceFormulaExecutor create(IPriceFormulaCalculate calExpr) {
        return new PriceFormulaExecutor(calExpr);
    }

    private List<IPriceFormulaCalculate> getCalExprs() {
        return this.calExprs;
    }

    private IPriceFormulaCalculate getCalExpr() {
        return this.calExpr;
    }

    public Map<String, Object> calculate(Map<String, Object> valueMap) {
        List<IPriceFormulaCalculate> sortedCalExprs = this.getCalExprs();
        if (sortedCalExprs.size() <= 0) {
            sortedCalExprs.add(this.getCalExpr());
        }
        Map<String, Object> calculatedValueMap = this.calculateValue(sortedCalExprs, valueMap);
        return calculatedValueMap;
    }

    private Map<String, Object> calculateValue(List<IPriceFormulaCalculate> sortedCalExprs, Map<String, Object> valueMap) {
        HashMap<String, Object> calculatedValueMap = new HashMap<String, Object>(16);
        for (IPriceFormulaCalculate expr : sortedCalExprs) {
            if (expr == null) continue;
            String targetField = expr.getTargetField();
            Object calculateValue = expr.calculate(valueMap);
            calculatedValueMap.put(targetField, calculateValue);
        }
        return calculatedValueMap;
    }
}

