/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlPolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step.PriceControlStep;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceFieldConst;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorOpEnum;

public class PriceControlCompareStep
extends PriceControlStep {
    private static final Log log = LogFactory.getLog(PriceControlCompareStep.class);

    @Override
    public void excute(PriceControlPolicyParam priceControlPolicyParam) {
        PriceControlSchemeInfo priceControlSchemeInfo = priceControlPolicyParam.getQsInfo();
        DataSet result = priceControlPolicyParam.getResultSet();
        ArrayList<String> sorter = new ArrayList<String>();
        if (priceControlSchemeInfo.getSortSignAliass().size() > 0) {
            for (int i = 0; i < priceControlSchemeInfo.getSortSignAliass().size(); ++i) {
                String sign = priceControlSchemeInfo.getSortSignAliass().get(i);
                sorter.add(new StringBuffer(sign).append(" ").append(priceControlSchemeInfo.getSortOrders().get(i)).toString());
            }
        }
        if (sorter.size() > 0) {
            ArrayList<String> newSorter = new ArrayList<String>();
            newSorter.addAll(priceControlPolicyParam.getPriceEntityKeyInfo().getLEFTIDFIELDS());
            newSorter.addAll(sorter);
            result = result.orderBy(newSorter.toArray(new String[0]));
            result = this.getTopRows(priceControlPolicyParam, result);
            result = this.compare(priceControlSchemeInfo, result);
        } else {
            result = this.compare(priceControlSchemeInfo, result);
            result = this.getTopRows(priceControlPolicyParam, result);
        }
        result = this.buildResult(priceControlPolicyParam, result);
        priceControlPolicyParam.setResultSet(result);
    }

    private DataSet compare(PriceControlSchemeInfo priceControlSchemeInfo, DataSet result) {
        ArrayList<String> totalConditionStr = new ArrayList<String>(16);
        for (int i = 0; i < priceControlSchemeInfo.getCompares().size(); ++i) {
            ArrayList<String> conditions = new ArrayList<String>();
            String operator = priceControlSchemeInfo.getCompares().get(i);
            conditions.add(new StringBuffer(priceControlSchemeInfo.getCompareSourceFieldAliass().get(i)).append(" ").append(OperatorOpEnum.getProptery(operator)).append(priceControlSchemeInfo.getCompareFieldAliass().get(i)).toString());
            conditions.add(new StringBuffer(priceControlSchemeInfo.getCompareSourceFieldAliass().get(i)).append(" ").append(OperatorOpEnum.EQUALS_OP.getProptery()).append("0").toString());
            String conditionStr = String.join((CharSequence)" AND ", conditions);
            conditionStr = "(" + conditionStr + ")";
            totalConditionStr.add(conditionStr);
        }
        if (totalConditionStr.size() > 0) {
            String conditionStr = String.join((CharSequence)" OR ", totalConditionStr);
            result = result.filter(conditionStr);
        }
        return result;
    }

    protected DataSet buildResult(PriceControlPolicyParam priceControlPolicyParam, DataSet result) {
        ArrayList<String> selector = new ArrayList<String>(priceControlPolicyParam.getPriceEntityKeyInfo().getLEFTIDFIELDS().size() + PriceFieldConst.PRICELOG_SEARCHFIELDS.length);
        priceControlPolicyParam.getPriceEntityKeyInfo().getLEFTIDFIELDS().forEach(f -> selector.add((String)f));
        for (String field : PriceFieldConst.PRICELOG_SEARCHFIELDS) {
            selector.add(field);
        }
        result = result.select(selector.toArray(new String[selector.size()]));
        return result;
    }

    private DataSet getTopRows(PriceControlPolicyParam priceControlPolicyParam, DataSet result) {
        PriceControlSchemeInfo priceControlSchemeInfo = priceControlPolicyParam.getQsInfo();
        List<String> props = priceControlPolicyParam.getPriceEntityKeyInfo().getLEFTIDFIELDS();
        GroupbyDataSet groupby = result.groupBy(props.toArray(new String[props.size()]));
        LinkedHashSet<String> priceControlJoinCompareFields = new LinkedHashSet<String>(16);
        priceControlJoinCompareFields.addAll(priceControlSchemeInfo.getCompareFieldAliass());
        priceControlJoinCompareFields.addAll(priceControlSchemeInfo.getCompareSourceFieldAliass());
        for (String field : PriceFieldConst.PRICELOG_SEARCHFIELDS) {
            priceControlJoinCompareFields.add(field);
        }
        RowMeta newMeta = new RowMeta(result.getRowMeta().getFields());
        priceControlJoinCompareFields.forEach(fieldKey -> groupby.agg((CustomAggFunction)new CustomAggFunction<Object>("getTopRec", newMeta.getField(fieldKey).getDataType()){
            private int i;
            {
                this.i = 0;
            }

            public Object newAggValue() {
                return null;
            }

            public Object addValue(Object o, Object o2) {
                if (o == null) {
                    this.i = 0;
                }
                if (this.i == 0) {
                    ++this.i;
                    return DataSetHelper.defaultValue4Null(o2, this.getResultDataType());
                }
                return o;
            }

            public Object combineAggValue(Object o, Object t1) {
                return o;
            }

            public Object getResult(Object o) {
                return o;
            }
        }, fieldKey, fieldKey));
        result = groupby.finish();
        return result;
    }
}

