/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.AbstractPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;

public abstract class CalcPolicy
extends AbstractPolicy
implements AutoCloseable {
    private List<CalcStep> steps = new ArrayList<CalcStep>();
    private QuoteCalcInfo quoteCalcInfo;

    public CalcPolicy(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo) {
        super(quotePolicyParam);
        this.quoteCalcInfo = quoteCalcInfo;
    }

    @Override
    public void close() {
    }

    public void calc(QuoteLogProxy logProxy) {
        try {
            for (CalcStep s : this.steps) {
                s.excute(this.quotePolicyParam, this.quoteCalcInfo, logProxy);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void addStep(CalcStep invStep) {
        this.steps.add(invStep);
    }

    protected List<CalcStep> getSteps() {
        return this.steps;
    }

    public QuoteCalcInfo getQuoteCalcInfo() {
        return this.quoteCalcInfo;
    }
}

