/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteProcessInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.AbstractPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.CalcExecPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.CalcPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteEngine;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class QuoteAdvanceEngine
extends QuoteEngine {
    private static final Log log = LogFactory.getLog(QuoteAdvanceEngine.class);

    public QuoteAdvanceEngine(QuoteLogProxy logProxy) {
        super(logProxy);
    }

    @Override
    public Map<String, Object> startQuote(QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege, QuoteParam quoteParam) {
        QuoteCalcColl quoteCalColl = quoteStrategeColl.getQuoteCalcColl(quoteStratege);
        List<QuoteCalcInfo> quoteCalInfos = quoteCalColl.getQuoteCalcInfos();
        ArrayList<AbstractPolicy> calcPolicys = new ArrayList<AbstractPolicy>(quoteCalInfos.size());
        for (int i = 0; i < quoteCalInfos.size(); ++i) {
            QuoteCalcInfo qs = quoteCalInfos.get(i);
            if (!this.hasQuoteNext(quoteParam)) continue;
            QuotePolicyParam quotePolicyParam = new QuotePolicyParam(quoteParam.getQuoteOriginDataSet().copy(), (Long)quoteStratege.getDynamicObject("createorg").getPkValue(), quoteParam.getQccInfo(), quoteParam.getEntityType());
            quotePolicyParam.getOtherParam().putAll(quoteParam.getOtherParam());
            CalcExecPolicy policy = new CalcExecPolicy(quotePolicyParam, qs);
            calcPolicys.add(policy);
            policy.calc(this.logProxy);
            this.suplusDataSet(quoteParam, quotePolicyParam, qs);
        }
        Map<String, Object> calcResult = this.buildResult(calcPolicys, quoteParam, quoteStrategeColl, quoteStratege);
        Map<String, Object> schemeResult = super.startQuote(quoteStrategeColl, quoteStratege, quoteParam);
        calcResult.putAll(schemeResult);
        this.logProxy.setEndTime(TimeServiceHelper.now());
        return calcResult;
    }

    @Override
    protected Map<String, Object> buildResult(List<AbstractPolicy> quotePolicys, QuoteParam quoteParam, QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege) {
        HashMap<String, Object> addPriceMapping = new HashMap<String, Object>();
        for (int i = 0; i < quotePolicys.size(); ++i) {
            AbstractPolicy p = quotePolicys.get(i);
            if (!(p instanceof CalcPolicy)) continue;
            CalcPolicy calcPolicy = (CalcPolicy)p;
            addPriceMapping.putAll(calcPolicy.getQuoteCalcInfo().getAddResult());
        }
        Map<String, Object> priceMapping = super.buildResult(quotePolicys, quoteParam, quoteStrategeColl, quoteStratege);
        addPriceMapping.putAll(priceMapping);
        return addPriceMapping;
    }

    @Override
    protected void suplusDataSet(QuoteParam quoteParam, QuotePolicyParam quotePolicyParam, QuoteProcessInfo quoteProcessInfo) {
        if (quoteProcessInfo instanceof QuoteCalcInfo) {
            QuoteCalcInfo calcInfo = (QuoteCalcInfo)quoteProcessInfo;
            String terminationSign = quoteProcessInfo.getTerminationSignX();
            terminationSign = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(terminationSign.replaceAll("\\.", "__"))).toString();
            if (quotePolicyParam.getOtherParam().get("KEYRELATION") != null && calcInfo.getAddResult().size() > 0) {
                Map keyRelatition = (Map)quotePolicyParam.getOtherParam().get("KEYRELATION");
                Map<String, Object> addResult = calcInfo.getAddResult();
                String filterStr_no = new StringBuffer(terminationSign).append(" ").append("is null").toString();
                try (DataSet noResult = quotePolicyParam.getResultSet().copy().where(filterStr_no);){
                    for (Row removeRow : noResult) {
                        String mainKey = PriceHelper.generateRowKey(quoteParam.getQccInfo(), removeRow);
                        List removekeys = (List)keyRelatition.get(mainKey);
                        if (removekeys == null) continue;
                        for (String removeKey : removekeys) {
                            addResult.remove(removeKey);
                        }
                    }
                }
            }
        }
        super.suplusDataSet(quoteParam, quotePolicyParam, quoteProcessInfo);
    }
}

